/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.objectstyle.wolips.baseforplugins.logging.PluginLogger;
import org.objectstyle.wolips.jdt.classpath.model.EclipseFrameworkModel;
import org.osgi.framework.BundleContext;

public class JdtPlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "org.objectstyle.wolips.jdt.JdtPlugin";
    private static JdtPlugin plugin;
    private ResourceBundle resourceBundle;
    private PluginLogger pluginLogger = null;
    private Map<String, EclipseFrameworkModel> frameworkModels;

    public JdtPlugin() {
        plugin = this;
        this.frameworkModels = new HashMap<String, EclipseFrameworkModel>();
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.objectstyle.wolips.jdt.JdtPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static JdtPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = JdtPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.pluginLogger = new PluginLogger(PLUGIN_ID, false);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.frameworkModels = null;
        this.pluginLogger = null;
    }

    public PluginLogger getPluginLogger() {
        return this.pluginLogger;
    }

    public synchronized void invalidateFrameworkModel() {
        EclipseFrameworkModel.invalidateProjectRootCache();
        this.frameworkModels.clear();
    }

    public synchronized EclipseFrameworkModel getFrameworkModel(IProject project) {
        String projectName = project != null ? project.getName() : null;
        EclipseFrameworkModel frameworkModel = this.frameworkModels.get(projectName);
        if (frameworkModel == null || frameworkModel.shouldReload()) {
            frameworkModel = new EclipseFrameworkModel(project);
            this.frameworkModels.put(projectName, frameworkModel);
        }
        return frameworkModel;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }
}

