/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.classpath.model;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.objectstyle.woenvironment.frameworks.Framework;
import org.objectstyle.woenvironment.frameworks.FrameworkLibrary;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.woenvironment.frameworks.Version;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.SimpleParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.WOLXMLPropertyListSerialization;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.JdtPlugin;
import org.objectstyle.wolips.jdt.classpath.model.EclipseFolderRoot;
import org.objectstyle.wolips.jdt.classpath.model.EclipsePathFramework;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;
import org.objectstyle.wolips.variables.BuildProperties;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EclipseProjectFramework
extends Framework
implements IEclipseFramework {
    private IProject project;
    private IClasspathEntry[] cachedClasspathEntries;

    public EclipseProjectFramework(Root root, IProject project) {
        super(root, EclipseProjectFramework.frameworkNameForProject(project));
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public List<FrameworkLibrary> getFrameworkLibraries() {
        return new LinkedList<FrameworkLibrary>();
    }

    public IFramework resolveFramework() {
        IPath buildPath = this.project.getLocation().append("build");
        EclipsePathFramework pathFramework = new EclipsePathFramework((Root)new EclipseFolderRoot("Project", "Built Project Framework", buildPath.toFile(), buildPath.toFile()), buildPath.append(this.getName() + ".framework").toFile());
        return pathFramework;
    }

    public boolean isResolved() {
        return true;
    }

    @Override
    public synchronized IClasspathEntry[] getClasspathEntries() {
        if (this.cachedClasspathEntries == null) {
            LinkedList<IClasspathEntry> classpathEntries = new LinkedList<IClasspathEntry>();
            classpathEntries.add(JavaCore.newProjectEntry((IPath)this.project.getFullPath()));
            this.cachedClasspathEntries = classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]);
        }
        return (IClasspathEntry[])this.cachedClasspathEntries.clone();
    }

    public Version getVersion() {
        Version version = null;
        File pomFile = this.project.getLocation().append("pom.xml").toFile();
        if (pomFile.exists()) {
            try {
                String versionStr;
                Document pomDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(pomFile);
                pomDocument.normalize();
                NodeList versionNodes = (NodeList)XPathFactory.newInstance().newXPath().compile("//project/version").evaluate(pomDocument, XPathConstants.NODESET);
                if (versionNodes.getLength() == 0) {
                    versionNodes = (NodeList)XPathFactory.newInstance().newXPath().compile("//parent/version").evaluate(pomDocument, XPathConstants.NODESET);
                }
                if (versionNodes.getLength() > 0 && (versionStr = versionNodes.item(0).getFirstChild().getNodeValue()) != null) {
                    version = new Version(versionStr);
                }
            }
            catch (Throwable t) {
                JdtPlugin.getDefault().getPluginLogger().log(t);
            }
        } else {
            BuildProperties buildProperties = (BuildProperties)this.project.getAdapter(BuildProperties.class);
            if (buildProperties != null) {
                version = buildProperties.getVersion();
            }
            if (version == null) {
                version = super.getVersion();
            }
        }
        return version;
    }

    public Map<String, Object> getInfoPlist() {
        ProjectAdapter projectAdapter = (ProjectAdapter)this.project.getAdapter(ProjectAdapter.class);
        Map propertyList = null;
        if (projectAdapter != null) {
            try {
                BuildProperties buildProperties = (BuildProperties)this.project.getAdapter(BuildProperties.class);
                File infoPlist = buildProperties.getWOVersion().isAtLeastVersion(5, 6) ? this.project.getLocation().append("Info.plist").toFile() : projectAdapter.getWOJavaArchive().removeLastSegments(1).append("Info.plist").toFile();
                if (infoPlist.exists()) {
                    propertyList = (Map)WOLXMLPropertyListSerialization.propertyListWithContentsOfFile((File)infoPlist, (ParserDataStructureFactory)new SimpleParserDataStructureFactory());
                }
            }
            catch (Throwable t) {
                JdtPlugin.getDefault().getPluginLogger().log(t);
                propertyList = null;
            }
        }
        return propertyList;
    }

    public static String frameworkNameForProject(IProject project) {
        return project.getName();
    }

    public static void main(String[] args) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        File pomFile = new File("/Volumes/WebObjects56/JavaFoundation/pom.xml");
        Document pomDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(pomFile);
        pomDocument.normalize();
        NodeList versionNodes = (NodeList)XPathFactory.newInstance().newXPath().compile("//parent/version").evaluate(pomDocument, XPathConstants.NODESET);
        if (versionNodes.getLength() > 0) {
            String version = versionNodes.item(0).getFirstChild().getNodeValue();
            System.out.println("EclipseProjectFramework.main: " + version);
        }
        System.out.println("EclipseProjectFramework.main: " + versionNodes.getLength());
    }
}

