/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.api;

import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.objectstyle.wolips.bindings.api.AbstractApiModelElement;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.api.IValidation;
import org.objectstyle.wolips.bindings.api.Validation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Wo
extends AbstractApiModelElement {
    private static final String CLASS = "class";
    private static final String WOCOMPONENTCONTENT = "wocomponentcontent";

    protected Wo(Element element, ApiModel apiModel) {
        super(element, apiModel);
    }

    public ApiModel getModel() {
        return this.apiModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassName() {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            return this.element.getAttribute(CLASS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassName(String className) {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            this.element.setAttribute(CLASS, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComponentContent() {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            String value = this.element.getAttribute(WOCOMPONENTCONTENT);
            if (value == null) {
                return false;
            }
            return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComponentContent(boolean isComponentContent) {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            if (isComponentContent) {
                this.element.setAttribute(WOCOMPONENTCONTENT, "true");
            } else {
                this.element.setAttribute(WOCOMPONENTCONTENT, "false");
            }
            this.apiModel.markAsDirty();
        }
    }

    public List<Binding> getRequiredBindings() {
        LinkedList<Binding> requiredBindings = new LinkedList<Binding>();
        for (Binding binding : this.getBindings()) {
            if (!binding.isRequired()) continue;
            requiredBindings.add(binding);
        }
        return requiredBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Binding> getBindings() {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            NodeList bindingElements = this.element.getElementsByTagName("binding");
            LinkedList<Binding> bindings = new LinkedList<Binding>();
            for (int i = 0; i < bindingElements.getLength(); ++i) {
                Element bindingElement = (Element)bindingElements.item(i);
                Binding binding = new Binding(bindingElement, this.apiModel, this);
                bindings.add(binding);
            }
            return bindings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Validation> getValidations() {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            NodeList validationElements = this.element.getElementsByTagName("validation");
            LinkedList<Validation> validations = new LinkedList<Validation>();
            for (int i = 0; i < validationElements.getLength(); ++i) {
                Element validationElement = (Element)validationElements.item(i);
                Validation validation = new Validation(validationElement, this.apiModel);
                validations.add(validation);
            }
            return validations;
        }
    }

    public List<Validation> getAffectedValidations(String bindingName) {
        List<Validation> validations = this.getValidations();
        LinkedList<Validation> affectedValidations = new LinkedList<Validation>();
        for (Validation validation : validations) {
            if (!validation.isAffectedByBindingNamed(bindingName)) continue;
            affectedValidations.add(validation);
        }
        return affectedValidations;
    }

    public List<IValidation> getDeepAffectedValidations(String bindingName) {
        List<Validation> validations = this.getValidations();
        LinkedList<IValidation> affectedValidations = new LinkedList<IValidation>();
        for (Validation validation : validations) {
            validation.fillInValidationsAffectedByBindingNamed(bindingName, affectedValidations);
        }
        return affectedValidations;
    }

    public List<Validation> getFailedValidations(Map<String, String> bindings) {
        List<Validation> validations = this.getValidations();
        LinkedList<Validation> failedValidations = new LinkedList<Validation>();
        for (Validation validation : validations) {
            if (!validation.evaluate(bindings)) continue;
            failedValidations.add(validation);
        }
        return failedValidations;
    }

    public Binding getBinding(String name) {
        Binding matchingBinding = null;
        List<Binding> bindings = this.getBindings();
        for (int bindingNum = 0; matchingBinding == null && bindingNum < bindings.size(); ++bindingNum) {
            Binding binding = bindings.get(bindingNum);
            if (name == null || !name.equals(binding.getName())) continue;
            matchingBinding = binding;
        }
        return matchingBinding;
    }

    public boolean containsBinding(String name) {
        return this.getBinding(name) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding createBinding(String name) {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            Binding binding = this.getBinding(name);
            if (binding == null) {
                Element newBindingElement = this.element.getOwnerDocument().createElement("binding");
                newBindingElement.setAttribute("name", name);
                this.element.appendChild(newBindingElement);
                this.apiModel.markAsDirty();
                binding = this.getBinding(name);
            }
            return binding;
        }
    }

    public void removeBinding(String name) {
        Binding binding = this.getBinding(name);
        if (binding != null) {
            this.removeBinding(binding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBinding(Binding binding) {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            List<Validation> affectedValidations = this.getAffectedValidations(binding.getName());
            for (Validation affectedValidation : affectedValidations) {
                this.element.removeChild(affectedValidation.element);
            }
            this.element.removeChild(binding.element);
            this.apiModel.markAsDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPreview() {
        String preview = null;
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            NodeList previewNodes = this.element.getElementsByTagName("preview");
            if (previewNodes.getLength() == 1) {
                try {
                    StringWriter sw = new StringWriter();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    transformerFactory.setAttribute("indent-number", 4);
                    StreamResult output = new StreamResult(sw);
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("encoding", "UTF8");
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    for (int nodeNum = 0; nodeNum < previewNodes.getLength(); ++nodeNum) {
                        Element previewElement = (Element)previewNodes.item(nodeNum);
                        NodeList previewChildren = previewElement.getChildNodes();
                        for (int childNum = 0; childNum < previewChildren.getLength(); ++childNum) {
                            Node childElement = previewChildren.item(childNum);
                            if (childElement instanceof Element) {
                                transformer.transform(new DOMSource(childElement), output);
                                continue;
                            }
                            if (!(childElement instanceof Text)) continue;
                            sw.append(((Text)childElement).getTextContent());
                        }
                    }
                    preview = sw.toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    preview = null;
                }
            }
        }
        return preview;
    }
}

