/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.wod;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforplugins.util.StringUtilities;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.api.ApiCache;
import org.objectstyle.wolips.bindings.api.ApiModelException;
import org.objectstyle.wolips.bindings.api.ApiUtils;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.BindingValidationRule;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.bindings.wod.BindingValueKeyPath;
import org.objectstyle.wolips.bindings.wod.HtmlElementCache;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.SimpleWodBinding;
import org.objectstyle.wolips.bindings.wod.SimpleWodElement;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.bindings.wod.WodBindingDeprecationProblem;
import org.objectstyle.wolips.bindings.wod.WodBindingValueProblem;
import org.objectstyle.wolips.bindings.wod.WodProblem;

public abstract class AbstractWodBinding
implements IWodBinding {
    private static Set<String> VALID_OGNL_VALUES = new HashSet<String>();
    private boolean _validate = true;

    @Override
    public int compareTo(IApiBinding o) {
        return o == null ? -1 : (this.getName() == null ? -1 : this.getName().compareTo(o.getName()));
    }

    public boolean equals(Object o) {
        return o instanceof AbstractWodBinding && ComparisonUtils.equals((Object)((AbstractWodBinding)o).getName(), (Object)this.getName());
    }

    public int hashCode() {
        String name = this.getName();
        return name == null ? 0 : name.hashCode();
    }

    @Override
    public boolean isAction() {
        return ApiUtils.isActionBinding(this);
    }

    public void setValidate(boolean validate) {
        this._validate = validate;
    }

    @Override
    public boolean shouldValidate() {
        return this._validate;
    }

    @Override
    public void writeWodFormat(Writer writer) throws IOException {
        writer.write("  ");
        if (this.getNamespace() != null) {
            writer.write(this.getNamespace());
            writer.write(":");
        }
        writer.write(this.getName());
        writer.write(" = ");
        writer.write(this.getValue());
        writer.write(";");
    }

    @Override
    public void writeInlineFormat(Writer writer, String prefix, String suffix) throws IOException {
        writer.write(" ");
        if (this.getNamespace() != null) {
            writer.write(this.getNamespace());
            writer.write(":");
        }
        writer.write(this.getName());
        writer.write(" = ");
        if (this.isLiteral()) {
            writer.write(this.getValue());
        } else if (this.isOGNL()) {
            writer.write("\"");
            writer.write(this.getValue());
            writer.write("\"");
        } else {
            writer.write("\"");
            writer.write(prefix);
            writer.write(this.getValue());
            writer.write(suffix);
            writer.write("\"");
        }
    }

    @Override
    public boolean isTrueValue() {
        String bindingValue = this.getValue();
        return "true".equalsIgnoreCase(bindingValue) || "yes".equalsIgnoreCase(bindingValue);
    }

    public boolean isEmpty() {
        String bindingValue = this.getValue();
        return bindingValue == null || bindingValue.length() == 0;
    }

    public boolean isDigitsOnly() {
        String bindingValue = this.getValue();
        return !this.isEmpty() && StringUtilities.isNumericOnly((String)bindingValue);
    }

    public boolean isCaret() {
        String bindingValue = this.getValue();
        return bindingValue != null && bindingValue.startsWith("^");
    }

    @Override
    public boolean isLiteral() {
        String bindingValue = this.getValue();
        return bindingValue != null && bindingValue.startsWith("\"");
    }

    @Override
    public boolean isOGNL() {
        String bindingValue = this.getValue();
        return bindingValue != null && (bindingValue.startsWith("~") || bindingValue.startsWith("\"~"));
    }

    @Override
    public boolean isKeyPath() {
        return !this.isLiteral() && !this.isEmpty() && !this.isCaret() && !this.isOGNL() && !this.isDigitsOnly();
    }

    @Override
    public abstract int getLineNumber();

    public static List<WodProblem> getBindingProblems(String elementType, String keypath, IType javaFileType, TypeCache typeCache, HtmlElementCache htmlCache) throws JavaModelException, ApiModelException {
        SimpleWodBinding binding = new SimpleWodBinding(null, "_temp", keypath);
        return binding.getBindingProblems(elementType, javaFileType, typeCache, htmlCache);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fillInBindingProblems(IWodElement element, IApiBinding apiBinding, IJavaProject javaProject, IType javaFileType, List<WodProblem> problems, TypeCache cache, HtmlElementCache htmlCache) throws JavaModelException {
        block47: {
            String invalidOGNLSeverity;
            BindingValueKeyPath bindingValueKeyPath;
            int lineNumber;
            String bindingValue;
            String bindingName;
            String bindingNamespace;
            block49: {
                block48: {
                    String missingCollectionSeverity = Activator.getDefault().getPluginPreferences().getString("MissingCollectionSeverityKey");
                    String missingComponentSeverity = Activator.getDefault().getPluginPreferences().getString("MissingComponentSeverityKey");
                    String missingNSKVCSeverity = Activator.getDefault().getPluginPreferences().getString("MissingNSKVCSeverityKey");
                    String ambiguousSeverity = Activator.getDefault().getPluginPreferences().getString("AmbiguousSeverityKey");
                    String atOperatorSeverity = Activator.getDefault().getPluginPreferences().getString("AtOperatorSeverityKey");
                    String helperFunctionSeverity = Activator.getDefault().getPluginPreferences().getString("HelperFunctionSeverityKey");
                    if (!this.shouldValidate()) break block47;
                    bindingNamespace = this.getNamespace();
                    bindingName = this.getName();
                    bindingValue = this.getValue();
                    boolean explicitlyValid = false;
                    String javaFileTypeName = javaFileType.getElementName();
                    if (javaFileTypeName != null) {
                        List<BindingValidationRule> bindingValidationRules = ApiCache.getBindingValidationRules();
                        for (int i = 0; !explicitlyValid && i < bindingValidationRules.size(); ++i) {
                            BindingValidationRule bindingValidationRule = bindingValidationRules.get(i);
                            if (!javaFileTypeName.matches(bindingValidationRule.getTypeRegex())) continue;
                            explicitlyValid = bindingValue != null && bindingValue.matches(bindingValidationRule.getValidBindingRegex());
                        }
                    }
                    if (explicitlyValid) break block47;
                    lineNumber = this.getLineNumber();
                    if (!this.isKeyPath()) break block48;
                    boolean checkKeyPath = true;
                    String valueNamespace = this.getValueNamespace();
                    if (valueNamespace != null) {
                        if ("var".equals(valueNamespace)) {
                            if (htmlCache != null && bindingValue != null) {
                                htmlCache.getVars().add(bindingValue);
                            }
                            checkKeyPath = false;
                        } else {
                            checkKeyPath = false;
                        }
                    }
                    if (checkKeyPath) {
                        String validKeyPath;
                        BindingValueKey[] bindingValueKeyPath2 = new BindingValueKeyPath(bindingValue, javaFileType, javaProject, cache);
                        if (!bindingValueKeyPath2.isValid() || bindingValueKeyPath2.isWOComponent() && !"ignore".equals(missingComponentSeverity) || bindingValueKeyPath2.isNSKeyValueCoding() && !"ignore".equals(missingNSKVCSeverity) && !bindingValueKeyPath2.isNSCollection()) {
                            boolean warning = bindingValueKeyPath2.isValid() ? false : (bindingValueKeyPath2.isWOComponent() ? "warning".equals(missingComponentSeverity) : (bindingValueKeyPath2.isNSKeyValueCoding() ? "warning".equals(missingCollectionSeverity) : false));
                            String invalidKey = bindingValueKeyPath2.getInvalidKey();
                            String validKeyPath2 = bindingValueKeyPath2.getValidKeyPath();
                            if ((validKeyPath2 != null && validKeyPath2.length() != 0 || htmlCache == null || !htmlCache.getVars().contains(invalidKey)) && validKeyPath2 != null) {
                                if (validKeyPath2.length() == 0) {
                                    problems.add(new WodBindingValueProblem(element, this, bindingName, "There is no key '" + invalidKey + "' in " + javaFileType.getElementName(), this.getValuePosition(), lineNumber, false));
                                } else {
                                    problems.add(new WodBindingValueProblem(element, this, bindingName, "There is no key '" + invalidKey + "' for the keypath '" + validKeyPath2 + "' in " + javaFileType.getElementName(), this.getValuePosition(), lineNumber, false));
                                }
                            }
                        } else if (bindingValueKeyPath2.isNSCollection()) {
                            String validKeyPath3;
                            if (!"ignore".equals(missingCollectionSeverity) && (validKeyPath3 = bindingValueKeyPath2.getValidKeyPath()) != null) {
                                if (validKeyPath3.length() == 0) {
                                    problems.add(new WodBindingValueProblem(element, this, bindingName, "Unable to verify key '" + bindingValueKeyPath2.getInvalidKey() + "' because " + javaFileType.getElementName() + " passes through a collection", this.getValuePosition(), lineNumber, "warning".equals(missingCollectionSeverity)));
                                } else {
                                    problems.add(new WodBindingValueProblem(element, this, bindingName, "Unable to verify key '" + bindingValueKeyPath2.getInvalidKey() + "' because the keypath '" + validKeyPath3 + "' in " + javaFileType.getElementName() + " passes through a collection", this.getValuePosition(), lineNumber, "warning".equals(missingCollectionSeverity)));
                                }
                            }
                        } else if (bindingValueKeyPath2.isWOComponent()) {
                            String validKeyPath4;
                            if (!"ignore".equals(missingComponentSeverity) && (validKeyPath4 = bindingValueKeyPath2.getValidKeyPath()) != null) {
                                if (validKeyPath4.length() == 0) {
                                    problems.add(new WodBindingValueProblem(element, this, bindingName, "Unable to verify the key '" + bindingValueKeyPath2.getInvalidKey() + "' because " + javaFileType.getElementName() + " is a component.", this.getValuePosition(), lineNumber, "warning".equals(missingComponentSeverity)));
                                } else {
                                    problems.add(new WodBindingValueProblem(element, this, bindingName, "Unable to verify the key '" + bindingValueKeyPath2.getInvalidKey() + "' because the keypath '" + validKeyPath4 + "' in " + javaFileType.getElementName() + " is a component.", this.getValuePosition(), lineNumber, "warning".equals(missingComponentSeverity)));
                                }
                            }
                        } else if (bindingValueKeyPath2.isNSKeyValueCoding()) {
                            String validKeyPath5;
                            if (!"ignore".equals(missingNSKVCSeverity) && (validKeyPath5 = bindingValueKeyPath2.getValidKeyPath()) != null) {
                                if (validKeyPath5.length() == 0) {
                                    problems.add(new WodBindingValueProblem(element, this, bindingName, "Unable to verify the key '" + bindingValueKeyPath2.getInvalidKey() + "' because " + javaFileType.getElementName() + " implements NSKeyValueCoding", this.getValuePosition(), lineNumber, "warning".equals(missingNSKVCSeverity)));
                                } else {
                                    problems.add(new WodBindingValueProblem(element, this, bindingName, "Unable to verify the key '" + bindingValueKeyPath2.getInvalidKey() + "' because the keypath '" + validKeyPath5 + "' in " + javaFileType.getElementName() + " implements NSKeyValueCoding", this.getValuePosition(), lineNumber, "warning".equals(missingNSKVCSeverity)));
                                }
                            }
                        } else if (!"ignore".equals(ambiguousSeverity) && bindingValueKeyPath2.isAmbiguous() && (validKeyPath = bindingValueKeyPath2.getValidKeyPath()) != null) {
                            if (validKeyPath.length() == 0) {
                                problems.add(new WodBindingValueProblem(element, this, bindingName, "Unable to verify the key '" + bindingValueKeyPath2.getInvalidKey() + "' in " + javaFileType.getElementName(), this.getValuePosition(), lineNumber, "warning".equals(ambiguousSeverity)));
                            } else {
                                problems.add(new WodBindingValueProblem(element, this, bindingName, "Unable to verify the key '" + bindingValueKeyPath2.getInvalidKey() + "' for the path '" + validKeyPath + "' in " + javaFileType.getElementName(), this.getValuePosition(), lineNumber, "warning".equals(ambiguousSeverity)));
                            }
                        }
                        String operator = bindingValueKeyPath2.getOperator();
                        if (!"ignore".equals(atOperatorSeverity) && operator != null && !BindingReflectionUtils.getArrayOperators().contains(operator)) {
                            problems.add(new WodBindingValueProblem(element, this, bindingName, "Unable to verify operator '" + operator + "'", this.getValuePosition(), lineNumber, "warning".equals(atOperatorSeverity)));
                        }
                        String helperFunction = bindingValueKeyPath2.getHelperFunction();
                        if (!"ignore".equals(helperFunctionSeverity) && helperFunction != null) {
                            problems.add(new WodBindingValueProblem(element, this, bindingName, "Unable to verify helper function '" + helperFunction + "'", this.getValuePosition(), lineNumber, "warning".equals(helperFunctionSeverity)));
                        }
                        if (apiBinding != null && apiBinding.isWillSet() && bindingValueKeyPath2.isSettable()) {
                            // empty if block
                        }
                    }
                    break block49;
                }
                if (apiBinding == null || !apiBinding.isWillSet() || !this.isCaret()) {
                    // empty if block
                }
            }
            String deprecationSeverity = Activator.getDefault().getPluginPreferences().getString("DeprecatedBindingSeverityKey");
            if (!"ignore".equals(deprecationSeverity) && (bindingValueKeyPath = new BindingValueKeyPath(bindingValue, javaFileType, javaProject, cache)).isValid() && bindingValueKeyPath.getBindingKeys() != null) {
                for (BindingValueKey bindingKey : bindingValueKeyPath.getBindingKeys()) {
                    if (!BindingReflectionUtils.bindingPointsToDeprecatedValue(bindingKey)) continue;
                    problems.add(new WodBindingDeprecationProblem(element, this, bindingName, "The key '" + bindingName + "' uses a value that is deprecated.", this.getValuePosition(), lineNumber, "warning".equals(deprecationSeverity)));
                    break;
                }
            }
            if (!"ignore".equals(invalidOGNLSeverity = Activator.getDefault().getPluginPreferences().getString("InvalidOGNLSeverityKey")) && this.isOGNL()) {
                boolean inQuotes = bindingValue.startsWith("\"");
                if (inQuotes) {
                    bindingValue = bindingValue.substring(1, bindingValue.length() - 1);
                }
                Object ognl = bindingValue.substring(1);
                ognl = ((String)ognl).replaceAll("\\\\'", " ");
                ognl = ((String)ognl).replaceAll("'[^']*'", "''");
                if (inQuotes) {
                    ognl = ((String)ognl).replaceAll("\\\\\"[^\"]*\\\\\"", "\\\"\\\"");
                } else {
                    ognl = ((String)ognl).replaceAll("\\\\\"", " ");
                    ognl = ((String)ognl).replaceAll("\"[^\"]*\"", "\"\"");
                }
                ognl = (String)ognl + " ";
                int identifierStartChar = -1;
                for (int i = 0; i < ((String)ognl).length(); ++i) {
                    String nextStr;
                    char ch = ((String)ognl).charAt(i);
                    if (identifierStartChar == -1) {
                        if (!Character.isJavaIdentifierStart(ch) && ch != '@' && ch != '#') continue;
                        identifierStartChar = i;
                        continue;
                    }
                    if (Character.isJavaIdentifierPart(ch) || ch == '.' || ch == '@' || ch == '#') continue;
                    String ognlBindingValue = ((String)ognl).substring(identifierStartChar, i);
                    if (!(ognlBindingValue.startsWith("@") || ognlBindingValue.startsWith("#") || VALID_OGNL_VALUES.contains(ognlBindingValue.toLowerCase()) || (nextStr = ((String)ognl).substring(i).trim()).startsWith("("))) {
                        SimpleWodBinding ognlBinding = new SimpleWodBinding(bindingNamespace, bindingName, "ognl", ognlBindingValue, this.getNamespacePosition(), this.getNamePosition(), this.getValueNamespacePosition(), this.getValuePosition(), this.getLineNumber());
                        try {
                            LinkedList<WodProblem> ognlProblems = new LinkedList<WodProblem>();
                            ognlBinding.fillInBindingProblems(element, apiBinding, javaProject, javaFileType, ognlProblems, cache, htmlCache);
                            for (WodProblem ognlProblem : ognlProblems) {
                                problems.add(new WodBindingValueProblem(element, this, bindingName, ognlProblem.getMessage(), this.getValuePosition(), lineNumber, ognlProblem.isWarning() || "warning".equals(invalidOGNLSeverity)));
                            }
                        }
                        catch (Exception e) {
                            Activator.getDefault().log(e);
                        }
                    }
                    identifierStartChar = -1;
                }
            }
        }
    }

    @Override
    public String getDefaults() {
        return null;
    }

    @Override
    public int getSelectedDefaults() {
        return ApiUtils.getSelectedDefaults(this);
    }

    @Override
    public String[] getValidValues(String partialValue, IJavaProject javaProject, IType componentType, TypeCache typeCache) {
        return new String[0];
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean isWillSet() {
        return false;
    }

    @Override
    public boolean isValueWithin(IRegion region) {
        Position valuePosition = this.getValuePosition();
        return valuePosition != null && valuePosition.getOffset() <= region.getOffset() && valuePosition.getOffset() + valuePosition.getLength() > region.getOffset();
    }

    @Override
    public boolean isNameWithin(IRegion region) {
        Position namePosition = this.getNamePosition();
        return namePosition != null && namePosition.getOffset() <= region.getOffset() && namePosition.getOffset() + namePosition.getLength() > region.getOffset();
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": name = " + this.getName() + "; value = " + this.getValue() + "]";
    }

    public List<WodProblem> getBindingProblems(String elementType, IType javaFileType, TypeCache typeCache, HtmlElementCache htmlCache) throws JavaModelException, ApiModelException {
        Wo wo;
        LinkedList<WodProblem> problems = new LinkedList<WodProblem>();
        Binding apiBinding = null;
        SimpleWodElement element = null;
        if (elementType != null && (wo = (element = new SimpleWodElement("_temp", elementType)).getApi(javaFileType.getJavaProject(), typeCache)) != null) {
            apiBinding = wo.getBinding(this.getName());
        }
        this.fillInBindingProblems(element, apiBinding, javaFileType.getJavaProject(), javaFileType, problems, new TypeCache(), htmlCache);
        return problems;
    }

    static {
        VALID_OGNL_VALUES.add("and");
        VALID_OGNL_VALUES.add("band");
        VALID_OGNL_VALUES.add("bor");
        VALID_OGNL_VALUES.add("eq");
        VALID_OGNL_VALUES.add("gt");
        VALID_OGNL_VALUES.add("gte");
        VALID_OGNL_VALUES.add("in");
        VALID_OGNL_VALUES.add("instanceof");
        VALID_OGNL_VALUES.add("lt");
        VALID_OGNL_VALUES.add("lte");
        VALID_OGNL_VALUES.add("neq");
        VALID_OGNL_VALUES.add("not");
        VALID_OGNL_VALUES.add("null");
        VALID_OGNL_VALUES.add("neq");
        VALID_OGNL_VALUES.add("new");
        VALID_OGNL_VALUES.add("or");
        VALID_OGNL_VALUES.add("shl");
        VALID_OGNL_VALUES.add("shr");
        VALID_OGNL_VALUES.add("this");
        VALID_OGNL_VALUES.add("ushr");
        VALID_OGNL_VALUES.add("xor");
    }
}

