/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.wod;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.bindings.wod.ITypeOwner;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.locate.LocateException;

public class BindingValueKeyPath {
    private IJavaProject _javaProject;
    private IType _contextType;
    private String[] _bindingKeyNames;
    private BindingValueKey[] _bindingKeys;
    private String _originalKeyPath;
    private String _validKeyPath;
    private String _operator;
    private String _invalidKey;
    private boolean _valid;
    private boolean _nsCollection;
    private boolean _woComponent;
    private boolean _nsKVC;
    private boolean _ambiguous;
    private String _helperFunction;
    private TypeCache _cache;
    private Boolean _gettable;
    private Boolean _settable;

    public BindingValueKeyPath(String keyPath, IType contextType) throws JavaModelException {
        this(keyPath, contextType, contextType.getJavaProject(), new TypeCache());
    }

    public BindingValueKeyPath(String keyPath, ITypeOwner typeOwner) throws CoreException, LocateException {
        this(keyPath, typeOwner.getType(), typeOwner.getType().getJavaProject(), typeOwner.getCache());
    }

    public BindingValueKeyPath(String keyPath, IType contextType, TypeCache cache) throws JavaModelException {
        this(keyPath, contextType, contextType.getJavaProject(), cache);
    }

    public BindingValueKeyPath(String keyPath, IType contextType, IJavaProject javaProject, TypeCache cache) throws JavaModelException {
        this._cache = cache;
        this._javaProject = javaProject;
        this._contextType = contextType;
        this._valid = true;
        this._originalKeyPath = keyPath;
        boolean isKeyPath = true;
        if (keyPath != null && keyPath.length() > 0) {
            char ch = keyPath.charAt(0);
            if (ch == '\"' || ch == '\'') {
                isKeyPath = false;
            } else if (Character.isDigit(ch)) {
                isKeyPath = false;
            }
        }
        if (isKeyPath) {
            String partialKeyPath;
            if (keyPath != null) {
                int pipeIndex = keyPath.indexOf(124);
                if (pipeIndex == -1) {
                    partialKeyPath = keyPath;
                } else {
                    partialKeyPath = keyPath.substring(0, pipeIndex);
                    this._helperFunction = keyPath.substring(pipeIndex + 1);
                }
            } else {
                partialKeyPath = "";
            }
            int atIndex = partialKeyPath.indexOf(64);
            if (atIndex != -1) {
                this._operator = partialKeyPath.substring(atIndex + 1);
                partialKeyPath = partialKeyPath.substring(0, atIndex);
            }
            String[] bindingKeyNames = partialKeyPath.split("\\.");
            boolean forceValid = false;
            if (bindingKeyNames.length > 0 && bindingKeyNames[bindingKeyNames.length - 1].endsWith("VALID")) {
                bindingKeyNames[bindingKeyNames.length - 1] = bindingKeyNames[bindingKeyNames.length - 1].replaceFirst("\\s*//\\s*VALID", "");
                forceValid = true;
            }
            if (keyPath != null && keyPath.length() > 0 && keyPath.charAt(keyPath.length() - 1) == '.' && this._operator == null && this._helperFunction == null) {
                String[] bindingKeyNamesWithFinalBlank = new String[bindingKeyNames.length + 1];
                System.arraycopy(bindingKeyNames, 0, bindingKeyNamesWithFinalBlank, 0, bindingKeyNames.length);
                bindingKeyNamesWithFinalBlank[bindingKeyNamesWithFinalBlank.length - 1] = "";
                this._bindingKeyNames = bindingKeyNamesWithFinalBlank;
            } else {
                this._bindingKeyNames = bindingKeyNames;
            }
            if (BindingReflectionUtils.isBooleanValue(keyPath) || "null".equalsIgnoreCase(keyPath) || "nil".equalsIgnoreCase(keyPath)) {
                this._ambiguous = false;
                this._valid = true;
                this._nsKVC = false;
                this._woComponent = false;
                this._nsCollection = false;
            } else {
                int invalidKeyNum = -1;
                IType currentType = this._contextType;
                BindingValueKey currentBinding = null;
                LinkedList<BindingValueKey> bindingKeysList = new LinkedList<BindingValueKey>();
                for (int keyNum = 0; currentType != null && keyNum < this._bindingKeyNames.length; ++keyNum) {
                    boolean keyAccessible = false;
                    List<BindingValueKey> bindingAccessorKeys = cache.getBindingValueAccessorKeys(javaProject, currentType, this._bindingKeyNames[keyNum]);
                    if (bindingAccessorKeys.isEmpty() && keyNum == this._bindingKeyNames.length - 1) {
                        this._gettable = Boolean.FALSE;
                        List<BindingValueKey> bindingMutatorKeys = cache.getBindingValueMutatorKeys(javaProject, currentType, this._bindingKeyNames[keyNum]);
                        if (!bindingMutatorKeys.isEmpty()) {
                            keyAccessible = true;
                            this._settable = Boolean.TRUE;
                            BindingValueKey bindingKey = bindingMutatorKeys.get(0);
                            bindingKeysList.add(bindingKey);
                            currentType = null;
                            currentBinding = bindingKey;
                        }
                    } else if (!bindingAccessorKeys.isEmpty()) {
                        keyAccessible = true;
                        this._gettable = Boolean.TRUE;
                        BindingValueKey bindingKey = bindingAccessorKeys.get(0);
                        bindingKeysList.add(bindingKey);
                        currentType = bindingKey.getNextType(currentBinding);
                        currentBinding = bindingKey;
                    }
                    if (keyAccessible) continue;
                    if (BindingReflectionUtils.isNSKeyValueCoding(currentType, cache) || "java.lang.Object".equals(currentType.getFullyQualifiedName())) {
                        this._nsKVC = true;
                        if (BindingReflectionUtils.isNSCollection(currentType, cache)) {
                            this._nsCollection = true;
                            this._ambiguous = true;
                            invalidKeyNum = keyNum;
                            currentType = null;
                            continue;
                        }
                        if (BindingReflectionUtils.isWOComponent(currentType, cache)) {
                            this._woComponent = true;
                            this._ambiguous = true;
                            invalidKeyNum = keyNum;
                            currentType = null;
                            continue;
                        }
                        this._ambiguous = true;
                        invalidKeyNum = keyNum;
                        currentType = null;
                        continue;
                    }
                    this._valid = false;
                    invalidKeyNum = keyNum;
                    currentType = null;
                }
                if (forceValid) {
                    this._valid = true;
                } else if (invalidKeyNum != -1) {
                    StringBuffer validKeyPathBuffer = new StringBuffer();
                    if (invalidKeyNum > 0) {
                        for (int keyNum = 0; keyNum < invalidKeyNum; ++keyNum) {
                            validKeyPathBuffer.append(this._bindingKeyNames[keyNum]);
                            validKeyPathBuffer.append(".");
                        }
                        validKeyPathBuffer.setLength(validKeyPathBuffer.length() - 1);
                    }
                    this._validKeyPath = validKeyPathBuffer.toString();
                    this._invalidKey = this._bindingKeyNames[invalidKeyNum];
                }
                this._bindingKeys = bindingKeysList.toArray(new BindingValueKey[bindingKeysList.size()]);
            }
        }
    }

    public String getOriginalKeyPath() {
        return this._originalKeyPath;
    }

    public String getOperator() {
        return this._operator;
    }

    public boolean isWOComponent() {
        return this._woComponent;
    }

    public boolean isNSKeyValueCoding() {
        return this._nsKVC;
    }

    public boolean isNSCollection() {
        return this._nsCollection;
    }

    public String getValidKeyPath() {
        return this._validKeyPath;
    }

    public String getInvalidKey() {
        return this._invalidKey;
    }

    public String getHelperFunction() {
        return this._helperFunction;
    }

    public boolean isAmbiguous() {
        return this._ambiguous;
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean isGettable() {
        boolean gettable = false;
        gettable = this._gettable != null ? this._gettable.booleanValue() : this.isValid();
        return gettable;
    }

    public boolean isSettable() throws JavaModelException {
        boolean settable = false;
        if (this._settable != null) {
            settable = this._settable;
        } else {
            BindingValueKey lastBindingKey = this.getLastBindingKey();
            if (lastBindingKey != null) {
                IType declaringType;
                List<BindingValueKey> bindingKeys;
                IMember bindingMember = lastBindingKey.getBindingMember();
                if (bindingMember instanceof IField) {
                    settable = true;
                } else if (bindingMember instanceof IMethod && !(bindingKeys = this._cache.getBindingValueMutatorKeys(this._javaProject, declaringType = bindingMember.getDeclaringType(), lastBindingKey.getBindingName())).isEmpty()) {
                    settable = true;
                }
            }
        }
        return settable;
    }

    public String getLastBindingKeyName() {
        String lastBindingKeyName = this._bindingKeyNames != null && this._bindingKeyNames.length > 0 ? this._bindingKeyNames[this._bindingKeyNames.length - 1] : null;
        return lastBindingKeyName;
    }

    public String getNextToLastBindingKeyName() {
        String nextToLastBindingKeyName = this._bindingKeyNames.length > 1 ? this._bindingKeyNames[this._bindingKeyNames.length - 2] : null;
        return nextToLastBindingKeyName;
    }

    public BindingValueKey[] getBindingKeys() {
        return this._bindingKeys;
    }

    public boolean exists() {
        return this.getLastBindingKey() != null;
    }

    public boolean isSingleKey() {
        return this.getLength() == 1;
    }

    public boolean canAddKey() {
        return this.isValid() && !this.exists() && this.isSingleKey();
    }

    public BindingValueKey getLastBindingKey() {
        BindingValueKey lastBindingKey = this._bindingKeys != null && this._bindingKeys.length > 0 ? this._bindingKeys[this._bindingKeys.length - 1] : null;
        return lastBindingKey;
    }

    public BindingValueKey getNextToLastBindingKey() {
        BindingValueKey nextToLastBindingKey = this._bindingKeys.length > 1 ? this._bindingKeys[this._bindingKeys.length - 2] : null;
        return nextToLastBindingKey;
    }

    public IType getLastType() throws JavaModelException {
        BindingValueKey lastBindingKey = this.getLastBindingKey();
        IType lastType = lastBindingKey != null ? lastBindingKey.getNextType(this.getNextToLastBindingKey()) : this._contextType;
        return lastType;
    }

    public List<BindingValueKey> getPartialMatchesForLastBindingKey(boolean allowInheritanceDuplicates) throws JavaModelException {
        List<BindingValueKey> bindingKeysList = null;
        if (this._helperFunction == null) {
            if (this._operator != null) {
                bindingKeysList = BindingReflectionUtils.getBindingKeys(this._javaProject, this.getLastType(), "@" + this._operator, false, 0, allowInheritanceDuplicates, this._cache);
            } else if (this._bindingKeys == null) {
                bindingKeysList = BindingReflectionUtils.getBindingKeys(this._javaProject, this.getLastType(), this._originalKeyPath, false, 0, allowInheritanceDuplicates, this._cache);
            } else {
                BindingValueKey lastBindingKey;
                String partialBindingKeyName;
                if (this._bindingKeyNames.length == this._bindingKeys.length) {
                    partialBindingKeyName = this.getLastBindingKeyName();
                    lastBindingKey = this.getNextToLastBindingKey();
                } else {
                    partialBindingKeyName = this.getLastBindingKeyName();
                    lastBindingKey = this.getLastBindingKey();
                }
                IType lastType = lastBindingKey == null ? this._contextType : lastBindingKey.getNextType(this.getNextToLastBindingKey());
                if (lastType != null) {
                    bindingKeysList = BindingReflectionUtils.getBindingKeys(this._javaProject, lastType, partialBindingKeyName, false, 0, allowInheritanceDuplicates, this._cache);
                }
            }
        }
        return bindingKeysList;
    }

    public int getLength() {
        return this._bindingKeyNames == null ? 1 : this._bindingKeyNames.length;
    }
}

