/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.actions;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.bindings.api.ApiModelException;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.componenteditor.ComponenteditorPlugin;
import org.objectstyle.wolips.componenteditor.actions.InsertComponentDialogue;
import org.objectstyle.wolips.componenteditor.actions.InsertComponentSpecification;
import org.objectstyle.wolips.componenteditor.actions.InsertHtmlAndWodAction;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.templateeditor.TemplateEditor;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;

public abstract class InsertComponentAction
extends InsertHtmlAndWodAction {
    private Wo _wo;

    public Wo getWo() {
        String componentName = this.getComponentName();
        if (this._wo == null) {
            this._wo = this.getWo(componentName);
        }
        return this._wo;
    }

    protected Wo getWo(String componentName) {
        TemplateEditor te;
        Wo wo = null;
        if (componentName != null && null != (te = this.getTemplateEditor())) {
            IFileEditorInput input = (IFileEditorInput)te.getEditorInput();
            IFile file = input.getFile();
            try {
                WodParserCache cache = WodParserCache.parser((IResource)file);
                wo = cache.getWo(componentName);
            }
            catch (LocateException le) {
                ComponenteditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.objectstyle.wolips.componenteditor", 0, "unable to get the Wo for an edited component", (Throwable)le));
            }
            catch (CoreException ce) {
                ComponenteditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.objectstyle.wolips.componenteditor", 0, "unable to get the Wo for an edited component", (Throwable)ce));
            }
            catch (ApiModelException ame) {
                ComponenteditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.objectstyle.wolips.componenteditor", 0, "unable to get the Wo for an edited component", (Throwable)ame));
            }
        }
        return wo;
    }

    protected IJavaProject getJavaProject() {
        IFileEditorInput input;
        IFile file;
        IJavaProject javaProject = null;
        TemplateEditor te = this.getTemplateEditor();
        if (te != null && (file = (input = (IFileEditorInput)te.getEditorInput()).getFile()) != null) {
            javaProject = JavaCore.create((IProject)file.getProject());
        }
        return javaProject;
    }

    @Override
    protected List<Binding> getRequiredBindings(String componentName) {
        List requiredBindings = null;
        Wo wo = this.getWo(componentName);
        if (wo != null) {
            requiredBindings = wo.getRequiredBindings();
        }
        return requiredBindings;
    }

    public abstract String getComponentInstanceNameSuffix();

    public abstract String getComponentName();

    @Override
    protected InsertComponentSpecification getComponentSpecification() {
        int results;
        InsertComponentSpecification ics = this._componentSpecification;
        if (ics == null) {
            ics = new InsertComponentSpecification(this.getComponentName());
            ics.setComponentInstanceNameSuffix(this.getComponentInstanceNameSuffix());
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            InsertComponentDialogue dialog = new InsertComponentDialogue(window.getShell(), this.getJavaProject(), ics);
            results = dialog.open();
        } else {
            results = 0;
        }
        if (results == 0) {
            Wo wo;
            ics.setRequiredBindings(this.getRequiredBindings(ics.getComponentName()));
            if (!ics.isInline()) {
                ics.setTagName("webobject");
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("name", ics.getComponentInstanceName());
                ics.setAttributes(attributes);
            }
            if ((wo = this.getWo(ics.getComponentName())) != null) {
                ics.setComponentContent(wo.isComponentContent());
            }
        } else {
            ics = null;
        }
        return ics;
    }
}

