/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.objectstyle.wolips.componenteditor.inspector.IAutoscroller;

public abstract class AbstractAutoscroller<T extends Control>
implements IAutoscroller {
    private static final int scrollTopLeftMargin = 20;
    private static final int scrollBottomRightMargin = 20;
    private static final int initialScrollFrequency = 500;
    private static final int continuousScrollFrequency = 50;
    private boolean _scrollStarted;
    private long _lastScrollTime;
    private T _control;
    private IAutoscroller.Delegate _delegate;

    public AbstractAutoscroller(T control) {
        this._control = control;
        this._scrollStarted = false;
        this._lastScrollTime = -1L;
    }

    @Override
    public void setDelegate(IAutoscroller.Delegate delegate) {
        this._delegate = delegate;
    }

    @Override
    public boolean isScrollStarted() {
        return this._scrollStarted;
    }

    @Override
    public void stopScroll() {
        this._lastScrollTime = -1L;
        this._scrollStarted = false;
    }

    public T getControl() {
        return this._control;
    }

    @Override
    public void autoscroll(Point scrollPoint) {
        if (this._control == null) {
            return;
        }
        Rectangle controlBounds = this._control.getBounds();
        controlBounds.x = 0;
        controlBounds.y = 0;
        if (!controlBounds.contains(scrollPoint)) {
            this.stopScroll();
        } else {
            if (this._lastScrollTime <= 0L) {
                this._lastScrollTime = System.currentTimeMillis();
            }
            int scrollFrequency = this._scrollStarted ? 50 : 500;
            long scrollTime = System.currentTimeMillis();
            if (scrollTime - this._lastScrollTime > (long)scrollFrequency) {
                int oldVerticalPosition = this.getVerticalPosition();
                int oldHorizontalPosition = this.getHorizontalPosition();
                if (scrollPoint.y < 20) {
                    this.scrollUp(scrollPoint.y);
                } else if (controlBounds.height - scrollPoint.y < 20) {
                    this.scrollDown(controlBounds.height - scrollPoint.y);
                }
                if (scrollPoint.x < 20) {
                    this.scrollLeft(scrollPoint.x);
                } else if (controlBounds.width - scrollPoint.x < 20) {
                    this.scrollRight(controlBounds.width - scrollPoint.x);
                }
                if (this.getVerticalPosition() != oldVerticalPosition || this.getHorizontalPosition() != oldHorizontalPosition) {
                    if (this._delegate != null) {
                        this._delegate.autoscrollOccurred(this);
                    }
                    this._control.redraw();
                    this._lastScrollTime = scrollTime;
                    this._scrollStarted = true;
                } else {
                    this._scrollStarted = false;
                }
            }
        }
    }

    protected abstract void scrollUp(int var1);

    protected abstract void scrollDown(int var1);

    protected abstract void scrollLeft(int var1);

    protected abstract void scrollRight(int var1);

    protected abstract int getVerticalPosition();

    protected abstract int getHorizontalPosition();
}

