/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.editors.text.TextEditor;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.WOTextCellEditor;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.wod.BindingValueKeyPath;
import org.objectstyle.wolips.bindings.wod.ITypeOwner;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.bindings.wod.WodProblem;
import org.objectstyle.wolips.componenteditor.inspector.BindingsContentProvider;
import org.objectstyle.wolips.componenteditor.inspector.BindingsLabelProvider;
import org.objectstyle.wolips.wodclipse.core.completion.WodCompletionUtils;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.IWOEditor;
import org.objectstyle.wolips.wodclipse.core.refactoring.RefactoringWodBinding;
import org.objectstyle.wolips.wodclipse.core.refactoring.RefactoringWodElement;
import org.objectstyle.wolips.wodclipse.core.util.ICursorPositionListener;
import org.objectstyle.wolips.wodclipse.core.util.WodModelUtils;

public class BindingsInspector
extends Composite
implements ISelectionProvider,
ISelectionChangedListener,
ICursorPositionListener {
    private WodParserCache _cache;
    private TextEditor _lastEditor;
    private Point _lastPosition;
    private Combo _elementTypeField;
    private Text _elementNameField;
    private TableViewer _bindingsTableViewer;
    private Button _addBindingButton;
    private Button _removeBindingButton;
    private Button _addKeyActionButton;
    private BindingsLabelProvider _nameLabelProvider;
    private BindingsLabelProvider _valueLabelProvider;
    private BindingsContentProvider _bindingsContentProvider;
    private DataBindingContext _dataBindingContext;
    private IWodElement _wodElement;
    private RefactoringWodElement _refactoringElement;
    private List<WodProblem> _wodProblems;
    private List<ISelectionChangedListener> _listeners = new LinkedList<ISelectionChangedListener>();

    public BindingsInspector(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label elementNameLabel = new Label((Composite)this, 0);
        elementNameLabel.setText("Component Name");
        this._elementNameField = new Text((Composite)this, 2048);
        this._elementNameField.setLayoutData((Object)new GridData(768));
        Label elementTypeLabel = new Label((Composite)this, 0);
        elementTypeLabel.setText("Component Type");
        this._elementTypeField = new Combo((Composite)this, 2048);
        this._elementTypeField.setLayoutData((Object)new GridData(768));
        this._elementTypeField.setVisibleItemCount(5);
        Composite bindingsTableContainer = new Composite((Composite)this, 0);
        GridData bindingsTableContainerData = new GridData(1808);
        bindingsTableContainerData.horizontalSpan = 2;
        bindingsTableContainer.setLayoutData((Object)bindingsTableContainerData);
        this._bindingsTableViewer = new TableViewer(bindingsTableContainer, 68354);
        this._bindingsContentProvider = new BindingsContentProvider();
        this._bindingsTableViewer.setContentProvider((IContentProvider)this._bindingsContentProvider);
        TableColumnLayout bindingsTableLayout = new TableColumnLayout();
        bindingsTableContainer.setLayout((Layout)bindingsTableLayout);
        Table bindingsTable = this._bindingsTableViewer.getTable();
        bindingsTable.setHeaderVisible(true);
        bindingsTable.setLinesVisible(true);
        ColumnViewerEditorActivationStrategy columnActivationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this._bindingsTableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this._bindingsTableViewer, (ColumnViewerEditorActivationStrategy)columnActivationStrategy, (int)58);
        TableViewerColumn nameViewerColumn = new TableViewerColumn(this._bindingsTableViewer, 16384);
        TableColumn nameColumn = nameViewerColumn.getColumn();
        nameColumn.setText("Attribute");
        bindingsTableLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(50, true));
        nameViewerColumn.setEditingSupport((EditingSupport)new BindingNameEditingSupport(this._bindingsTableViewer));
        this._nameLabelProvider = new BindingsLabelProvider(0);
        nameViewerColumn.setLabelProvider((CellLabelProvider)this._nameLabelProvider);
        TableViewerColumn valueViewerColumn = new TableViewerColumn(this._bindingsTableViewer, 16384);
        TableColumn valueColumn = valueViewerColumn.getColumn();
        valueColumn.setText("Binding");
        bindingsTableLayout.setColumnData((Widget)valueColumn, (ColumnLayoutData)new ColumnWeightData(50, true));
        valueViewerColumn.setEditingSupport((EditingSupport)new BindingValueEditingSupport(this._bindingsTableViewer));
        this._valueLabelProvider = new BindingsLabelProvider(1);
        valueViewerColumn.setLabelProvider((CellLabelProvider)this._valueLabelProvider);
        this._bindingsTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite buttonContainer = new Composite((Composite)this, 0);
        GridData buttonContainerData = new GridData(768);
        buttonContainerData.horizontalSpan = 2;
        buttonContainer.setLayoutData((Object)buttonContainerData);
        RowLayout buttonLayout = new RowLayout(256);
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginBottom = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.justify = true;
        buttonLayout.fill = true;
        buttonLayout.pack = true;
        buttonContainer.setLayout((Layout)buttonLayout);
        this._addBindingButton = new Button(buttonContainer, 8);
        this._addBindingButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                BindingsInspector.this.addNewBinding();
            }
        });
        this._addBindingButton.setText("New Binding");
        this._removeBindingButton = new Button(buttonContainer, 8);
        this._removeBindingButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                BindingsInspector.this.removeBinding();
            }
        });
        this._removeBindingButton.setText("Remove Binding");
        this._addKeyActionButton = new Button(buttonContainer, 8);
        this._addKeyActionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                BindingsInspector.this.addKey();
            }
        });
        this._addKeyActionButton.setText("Add Key");
        this.setWodElement(null, null);
    }

    public void setWodElement(IWodElement wodElement, WodParserCache cache) {
        if (this._elementNameField.isDisposed() || this._elementTypeField.isDisposed() || this._bindingsTableViewer.getTable().isDisposed()) {
            return;
        }
        if (this._dataBindingContext != null) {
            this._dataBindingContext.dispose();
        }
        this._cache = cache;
        this._wodElement = wodElement;
        this._wodProblems = null;
        if (wodElement != null && cache != null) {
            try {
                this._wodProblems = WodModelUtils.getProblems((IWodElement)wodElement, (WodParserCache)cache);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this._nameLabelProvider.setContext(this._wodElement, this._wodProblems);
        this._valueLabelProvider.setContext(this._wodElement, this._wodProblems);
        if (cache != null) {
            try {
                this._bindingsContentProvider.setContext(cache.getJavaProject(), WodParserCache.getTypeCache());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this._bindingsContentProvider.setContext(null, null);
        }
        if (this._bindingsTableViewer != null && !this._bindingsTableViewer.getControl().isDisposed()) {
            this._bindingsTableViewer.setInput((Object)this._wodElement);
        } else {
            this._bindingsTableViewer.setInput((Object)new Object[0]);
        }
        IApiBinding selectedBinding = (IApiBinding)((IStructuredSelection)this._bindingsTableViewer.getSelection()).getFirstElement();
        if (this._wodElement != null && selectedBinding != null) {
            Binding newBinding;
            String selectedBindingName = selectedBinding.getName();
            Wo api = this._bindingsContentProvider.getApi();
            if (api != null && (newBinding = api.getBinding(selectedBindingName)) != null) {
                this._bindingsTableViewer.setSelection((ISelection)new StructuredSelection((Object)newBinding));
            }
        }
        String elementName = "none";
        boolean elementNameEnabled = false;
        String elementType = "";
        boolean elementTypeEnabled = false;
        if (this._wodElement != null) {
            if (this._wodElement.isInline()) {
                elementName = "inline";
            } else {
                elementName = this._wodElement.getElementName();
                elementNameEnabled = true;
            }
            elementType = this._wodElement.getElementType();
            if (elementType == null) {
                elementType = "<unknown>";
            }
            elementTypeEnabled = true;
        }
        this._elementNameField.setText(elementName);
        this._elementNameField.setEnabled(elementNameEnabled);
        this._elementTypeField.setText(elementType);
        this._elementTypeField.setEnabled(elementTypeEnabled);
        if (cache != null) {
            this._dataBindingContext = new DataBindingContext();
            this._refactoringElement = new RefactoringWodElement(this._wodElement, cache);
            if (elementNameEnabled) {
                this.bindElementName(cache);
            }
            if (elementTypeEnabled) {
                this.bindElementType();
            }
        }
        this.enableButtons();
    }

    protected void addNewBinding() {
        RefactoringWodElement element = this.getRefactoringElement();
        if (element != null) {
            try {
                String newBindingName = RefactoringWodElement.findUnusedBindingName((IWodElement)element.getWodElement(), (String)"newBinding");
                element.addBindingValueNamed("\"\"", null, newBindingName);
                this.refresh();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void removeBinding() {
        RefactoringWodElement element;
        IApiBinding binding = (IApiBinding)((IStructuredSelection)this._bindingsTableViewer.getSelection()).getFirstElement();
        if (binding != null && (element = this.getRefactoringElement()) != null) {
            try {
                element.removeBindingNamed(binding.getName());
                this.refresh();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void addKey() {
        IApiBinding binding = (IApiBinding)((IStructuredSelection)this._bindingsTableViewer.getSelection()).getFirstElement();
        if (binding != null && this._cache != null) {
            try {
                BindingValueKeyPath bindingValueKeyPath = new BindingValueKeyPath(this._wodElement.getBindingValue(binding.getName()), (ITypeOwner)this._cache);
                if (bindingValueKeyPath.canAddKey()) {
                    String name = WodCompletionUtils.addKeyOrAction((BindingValueKeyPath)bindingValueKeyPath, (IApiBinding)binding, (IType)this._cache.getComponentType());
                    this.getRefactoringElement().setValueForBinding(name, binding.getName());
                    this.refresh();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void enableButtons() {
        if (this._wodElement == null) {
            this._addBindingButton.setEnabled(false);
            this._removeBindingButton.setEnabled(false);
            this._addKeyActionButton.setEnabled(false);
        } else {
            this._addBindingButton.setEnabled(true);
            IApiBinding binding = (IApiBinding)((IStructuredSelection)this._bindingsTableViewer.getSelection()).getFirstElement();
            if (binding == null || this._cache == null) {
                this._removeBindingButton.setEnabled(false);
                this._addKeyActionButton.setEnabled(false);
            } else {
                this._removeBindingButton.setEnabled(true);
                try {
                    BindingValueKeyPath bindingValueKeyPath = new BindingValueKeyPath(this._wodElement.getBindingValue(binding.getName()), (ITypeOwner)this._cache);
                    if (bindingValueKeyPath.canAddKey()) {
                        this._addKeyActionButton.setEnabled(true);
                    } else {
                        this._addKeyActionButton.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this._addKeyActionButton.setEnabled(false);
                }
            }
        }
    }

    protected void bindElementType() {
        UpdateValueStrategy elementTypeUpdateStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        elementTypeUpdateStrategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                String newName = (String)value;
                System.out.println(".validate: " + newName);
                IStatus status = Status.OK_STATUS;
                try {
                    if (newName == null || newName.length() == 0) {
                        status = ValidationStatus.error((String)"Element types cannot be blank.");
                    } else if (newName.contains(" ")) {
                        status = ValidationStatus.error((String)"Element types do not allow spaces.");
                    }
                }
                catch (Exception e) {
                    status = ValidationStatus.error((String)"Failed to change element type.", (Throwable)e);
                }
                if (!status.isOK()) {
                    BindingsInspector.this.getElementTypeField().setText(BindingsInspector.this.getRefactoringElement().getElementType());
                }
                return status;
            }
        });
        this._elementTypeField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                try {
                    String elementTypeFieldText = BindingsInspector.this.getElementTypeField().getText();
                    String elementTypeModelText = BindingsInspector.this.getRefactoringElement().getElementType();
                    if (!ComparisonUtils.equals((String)elementTypeModelText, (String)elementTypeFieldText, (boolean)true)) {
                        BindingsInspector.this.getRefactoringElement().setElementType(elementTypeFieldText);
                        BindingsInspector.this.refresh();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    protected void bindElementName(final WodParserCache refactoringParserCache) {
        UpdateValueStrategy elementNameUpdateStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        elementNameUpdateStrategy.setBeforeSetValidator((IValidator)new IValidator<Object>(){

            public IStatus validate(Object value) {
                String newName = (String)value;
                IStatus status = Status.OK_STATUS;
                try {
                    if (newName == null || newName.length() == 0) {
                        status = ValidationStatus.error((String)"Element names cannot be blank.");
                    } else if (newName.contains(" ")) {
                        status = ValidationStatus.error((String)"Element names do not allow spaces.");
                    } else if (((IWodModel)refactoringParserCache.getWodEntry().getModel()).getElementNamed(newName) != null) {
                        status = ValidationStatus.error((String)("There is already an element named '" + newName + "'."));
                    }
                }
                catch (Exception e) {
                    status = ValidationStatus.error((String)"Failed to change element name.", (Throwable)e);
                }
                if (!status.isOK()) {
                    BindingsInspector.this.getElementNameField().setText(BindingsInspector.this.getRefactoringElement().getElementName());
                }
                return status;
            }
        });
        this._dataBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)16).observe((Widget)this._elementNameField), BeanProperties.value((String)"elementName").observe((Object)this._refactoringElement), elementNameUpdateStrategy, null);
    }

    public TableViewer getBindingsTableViewer() {
        return this._bindingsTableViewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.enableButtons();
        SelectionChangedEvent wrappedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this._listeners) {
            listener.selectionChanged(wrappedEvent);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.add(listener);
    }

    public void setSelection(ISelection selection) {
        this._bindingsTableViewer.setSelection(selection);
    }

    public ISelection getSelection() {
        return this._bindingsTableViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.remove(listener);
    }

    public RefactoringWodElement getRefactoringElement() {
        return this._refactoringElement;
    }

    public Text getElementNameField() {
        return this._elementNameField;
    }

    public Combo getElementTypeField() {
        return this._elementTypeField;
    }

    public IWodElement getWodElement() {
        return this._wodElement;
    }

    public List<WodProblem> getWodProblems() {
        return this._wodProblems;
    }

    public TextEditor getLastEditor() {
        return this._lastEditor;
    }

    public void dispose() {
        if (this._dataBindingContext != null) {
            this._dataBindingContext.dispose();
            this._dataBindingContext = null;
        }
        super.dispose();
    }

    public void refresh() {
        if (this._bindingsTableViewer == null) {
            return;
        }
        if (this._lastEditor != null && this._lastPosition != null) {
            this.cursorPositionChanged(this._lastEditor, this._lastPosition);
        }
    }

    public void cursorPositionChanged(TextEditor editor, Point selectionRange) {
        this._lastEditor = editor;
        this._lastPosition = selectionRange;
        WodParserCache cache = null;
        IWodElement wodElement = null;
        if (editor instanceof IWOEditor) {
            try {
                IWOEditor woEditor = (IWOEditor)editor;
                cache = woEditor.getParserCache();
                wodElement = woEditor.getSelectedElement(true, true);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.setWodElement(wodElement, cache);
    }

    public class BindingValueEditingSupport
    extends EditingSupport {
        private TextCellEditor _valueEditor;

        public BindingValueEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this._valueEditor = new WOTextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this._valueEditor;
        }

        protected Object getValue(Object element) {
            IWodBinding wodBinding;
            IWodElement wodElement;
            String value = null;
            IApiBinding binding = (IApiBinding)element;
            if (binding != null && (wodElement = BindingsInspector.this.getWodElement()) != null && (wodBinding = wodElement.getBindingNamed(binding.getName())) != null) {
                value = wodBinding.getValue();
            }
            if (value == null) {
                value = "";
            }
            return value;
        }

        protected void setValue(Object element, Object value) {
            IWodElement wodElement;
            IApiBinding binding = (IApiBinding)element;
            if (binding != null && (wodElement = BindingsInspector.this.getWodElement()) != null) {
                try {
                    BindingsInspector.this.getRefactoringElement().setValueForBinding((String)value, binding.getName());
                    BindingsInspector.this.refresh();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class BindingNameEditingSupport
    extends EditingSupport {
        private TextCellEditor _nameEditor;

        public BindingNameEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this._nameEditor = new WOTextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this._nameEditor;
        }

        protected Object getValue(Object element) {
            String value = null;
            IApiBinding binding = (IApiBinding)element;
            if (binding != null) {
                value = binding.getName();
            }
            if (value == null) {
                value = "<none>";
            }
            return value;
        }

        protected void setValue(Object element, Object value) {
            IWodElement wodElement;
            IApiBinding binding = (IApiBinding)element;
            if (binding != null && (wodElement = BindingsInspector.this.getWodElement()) != null) {
                try {
                    RefactoringWodBinding wodBinding = BindingsInspector.this.getRefactoringElement().getBindingNamed(binding.getName());
                    if (wodBinding != null) {
                        wodBinding.setName((String)value);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BindingsInspector.this.refresh();
            }
        }
    }
}

