/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.part;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.componenteditor.actions.ComponentInserter;
import org.objectstyle.wolips.componenteditor.actions.InsertComponentAction;
import org.objectstyle.wolips.componenteditor.actions.InsertHtmlAndWodAction;
import org.objectstyle.wolips.componenteditor.part.ComponentEditor;
import org.objectstyle.wolips.templateeditor.TemplateEditor;

public class ComponentDropTargetAdaptor
extends DropTargetAdapter {
    private ComponentEditor _componentEditor;
    private IRegion _selection;

    public ComponentDropTargetAdaptor(ComponentEditor componentEditor) {
        this._componentEditor = componentEditor;
    }

    public StyledText getStyledText() {
        return this._componentEditor.getTemplateEditor().getSourceEditor().getViewer().getTextWidget();
    }

    public TemplateEditor getTemplateEditor() {
        return this._componentEditor.getTemplateEditor();
    }

    public void dragEnter(DropTargetEvent event) {
        try {
            this.getTemplateEditor().getSourceEditor().getParserCache().getHtmlEntry().clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Point selectionRange = this.getStyledText().getSelectionRange();
        this._selection = selectionRange == null ? null : new Region(selectionRange.x, selectionRange.y);
        if (event.detail == 16) {
            event.detail = 2;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = 2;
        }
    }

    public void dragOver(DropTargetEvent event) {
        try {
            event.feedback |= 8;
            Point controlPoint = this.getTemplateEditor().getSourceEditor().getViewer().getTextWidget().toControl(event.x, event.y);
            this._selection = this.getTemplateEditor().getSourceEditor().getSelectionRegionAtPoint(controlPoint, true, true);
            if (this._selection != null) {
                this.getTemplateEditor().getSourceEditor().getViewer().setSelectedRange(this._selection.getOffset(), this._selection.getLength());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drop(DropTargetEvent event) {
        boolean inline;
        String componentName;
        Wo wo;
        IFolder folder;
        String name;
        IResource resource;
        InsertHtmlAndWodAction inserter = null;
        boolean selectRange = false;
        IStructuredSelection structuredSelection = (IStructuredSelection)event.data;
        if (structuredSelection != null && !structuredSelection.isEmpty() && (resource = (IResource)structuredSelection.getFirstElement()) instanceof IFolder && (name = (folder = (IFolder)resource).getName()).endsWith(".wo") && (wo = ((InsertComponentAction)(inserter = new ComponentInserter(this._componentEditor, componentName = name.substring(0, name.lastIndexOf(46)), inline = true))).getWo()) != null) {
            selectRange = wo.isComponentContent();
        }
        if (inserter == null) {
            event.detail = 0;
            return;
        }
        IRewriteTarget target = (IRewriteTarget)this._componentEditor.getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.beginCompoundChange();
        }
        if (!this.getTemplateEditor().getSourceEditor().validateEditorInputState()) {
            event.detail = 0;
            return;
        }
        if (selectRange) {
            this.getTemplateEditor().getSelectionProvider().setSelection((ISelection)new TextSelection(this._selection.getOffset(), this._selection.getLength()));
        } else {
            this.getTemplateEditor().getSelectionProvider().setSelection((ISelection)new TextSelection(this._selection.getOffset(), 0));
        }
        inserter.insert();
    }
}

