/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.locate.scope;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.objectstyle.wolips.locate.scope.AbstractLocateScope;
import org.objectstyle.wolips.locate.scope.DefaultIgnoredFolderLocateScope;
import org.objectstyle.wolips.locate.scope.ILocateScope;
import org.objectstyle.wolips.locate.scope.IgnoredFolderLocateScope;
import org.objectstyle.wolips.locate.scope.IncludeFileLocateScope;
import org.objectstyle.wolips.locate.scope.IncludeFolderLocateScope;
import org.objectstyle.wolips.locate.scope.ProjectLocateScope;

public class DefaultLocateScope
extends AbstractLocateScope {
    private ILocateScope _projectLocateScope;
    private IgnoredFolderLocateScope _ignoredFolderScope;
    private IncludeFileLocateScope _includeFileScope;
    private IncludeFolderLocateScope _includeFolderScope;

    public DefaultLocateScope(IProject project, String[] includedFilesNames, String[] includedFolderNames) {
        this(project, includedFilesNames, null, includedFolderNames, new DefaultIgnoredFolderLocateScope());
    }

    public DefaultLocateScope(IProject project, String[] includedFilesNames, String[] includedFileExt, String[] includedFolderNames, IgnoredFolderLocateScope ignoredFolderScope) {
        this._projectLocateScope = new ProjectLocateScope(project);
        this._ignoredFolderScope = ignoredFolderScope;
        this._includeFileScope = new IncludeFileLocateScope(includedFilesNames, includedFileExt);
        this._includeFolderScope = new IncludeFolderLocateScope(includedFolderNames, null);
    }

    public DefaultLocateScope(ILocateScope projectLocateScope, String[] includedFilesNames, String[] includedFolderNames) {
        this._projectLocateScope = projectLocateScope;
        this._ignoredFolderScope = new DefaultIgnoredFolderLocateScope();
        this._includeFileScope = new IncludeFileLocateScope(includedFilesNames, null);
        this._includeFolderScope = new IncludeFolderLocateScope(includedFolderNames, null);
    }

    @Override
    public boolean ignoreContainer(IContainer container) {
        if (this._projectLocateScope.ignoreContainer(container)) {
            return true;
        }
        if (this._ignoredFolderScope.ignoreContainer(container)) {
            return true;
        }
        if (this._includeFileScope.ignoreContainer(container)) {
            return true;
        }
        return this._includeFolderScope.ignoreContainer(container);
    }

    @Override
    public boolean addToResult(IFile file) {
        if (this._projectLocateScope.addToResult(file)) {
            return true;
        }
        if (this._ignoredFolderScope.addToResult(file)) {
            return true;
        }
        if (this._includeFileScope.addToResult(file)) {
            return true;
        }
        return this._includeFolderScope.addToResult(file);
    }

    @Override
    public boolean addToResult(IContainer container) {
        if (this._projectLocateScope.addToResult(container)) {
            return true;
        }
        if (this._ignoredFolderScope.addToResult(container)) {
            return true;
        }
        if (this._includeFileScope.addToResult(container)) {
            return true;
        }
        return this._includeFolderScope.addToResult(container);
    }
}

