/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.dtdeditor.editors;

import com.wutka.dtd.DTDParseException;
import com.wutka.dtd.DTDParser;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import tk.eclipse.plugin.dtdeditor.editors.DTDConfiguration;
import tk.eclipse.plugin.dtdeditor.editors.DTDFileDocumentProvider;
import tk.eclipse.plugin.dtdeditor.editors.DTDOutlinePage;
import tk.eclipse.plugin.dtdeditor.editors.DTDTextDocumentProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.SchemaGenerator;

public class DTDEditor
extends HTMLSourceEditor {
    public static final String ACTION_GEN_XSD = "_generate_xsd";

    public DTDEditor() {
        super(new DTDConfiguration(HTMLPlugin.getDefault().getColorProvider()));
        this.setAction(ACTION_GEN_XSD, (IAction)new GenerateXSDAction());
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getPairMatcher().setDelimiter('<');
    }

    @Override
    protected IDocumentProvider createDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return new DTDTextDocumentProvider();
        }
        if (input instanceof IStorageEditorInput) {
            return new DTDFileDocumentProvider();
        }
        return new DTDTextDocumentProvider();
    }

    @Override
    protected IHTMLOutlinePage createOutlinePage() {
        return new DTDOutlinePage(this);
    }

    @Override
    protected void addContextMenuActions(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("_html"));
        this.addAction(menu, "_html", "_comment");
        this.addAction(menu, "_html", ACTION_GEN_XSD);
    }

    @Override
    protected void doValidate() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IFileEditorInput input = (IFileEditorInput)DTDEditor.this.getEditorInput();
                    IFile file = input.getFile();
                    file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                    try {
                        HTMLProjectParams params = new HTMLProjectParams(file.getProject());
                        if (!params.getValidateDTD()) {
                            return;
                        }
                        new DTDParser((Reader)new StringReader(DTDEditor.this.getHTMLSource())).parse();
                    }
                    catch (DTDParseException ex) {
                        DTDErrorInfo error = new DTDErrorInfo(ex);
                        IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("severity", 2);
                        map.put("message", error.getError());
                        map.put("lineNumber", error.getLine());
                        marker.setAttributes(map);
                    }
                    catch (Exception ex) {
                        HTMLPlugin.logException(ex);
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private class GenerateXSDAction
    extends Action {
        public GenerateXSDAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.GenerateXSD"), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_xsd"));
        }

        public void run() {
            FileDialog dialog = new FileDialog(DTDEditor.this.getViewer().getTextWidget().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.xsd"});
            String file = dialog.open();
            if (file != null) {
                try {
                    SchemaGenerator.generateXSDFromDTD(DTDEditor.this.getFile(), new File(file));
                }
                catch (Exception ex) {
                    HTMLPlugin.openAlertDialog(ex.toString());
                }
            }
        }
    }

    private static class DTDErrorInfo {
        private Pattern pattern = Pattern.compile("At line ([0-9]+), column ([0-9]+): (.+)$");
        private int line;
        private int column;
        private String error;

        public DTDErrorInfo(DTDParseException ex) {
            Matcher matcher = this.pattern.matcher(ex.toString());
            if (matcher.find()) {
                this.line = Integer.parseInt(matcher.group(1));
                this.column = Integer.parseInt(matcher.group(2));
                this.error = matcher.group(3);
            }
        }

        public int getColumn() {
            return this.column;
        }

        public String getError() {
            return this.error;
        }

        public int getLine() {
            return this.line;
        }
    }
}

