/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.tasktag.AbstractTaskTagDetector;
import tk.eclipse.plugin.htmleditor.tasktag.HTMLTaskTagDetector;
import tk.eclipse.plugin.htmleditor.tasktag.ITaskTagDetector;
import tk.eclipse.plugin.htmleditor.tasktag.JavaScriptTaskTagDetector;
import tk.eclipse.plugin.htmleditor.tasktag.TaskTag;

public class HTMLProjectBuilder
extends IncrementalProjectBuilder {
    private List<AbstractTaskTagDetector> taskTagDetectors = new ArrayList<AbstractTaskTagDetector>();
    private TaskTag[] tags;

    public HTMLProjectBuilder() {
        this.taskTagDetectors.add(new HTMLTaskTagDetector());
        this.taskTagDetectors.add(new JavaScriptTaskTagDetector());
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta;
        List<TaskTag> list = TaskTag.loadFromPreference(false);
        this.tags = list.toArray(new TaskTag[list.size()]);
        if (this.getProject() == null) {
            return null;
        }
        if (kind == 6) {
            this.processContainer((IContainer)this.getProject());
        }
        if ((delta = this.getDelta(this.getProject())) == null) {
            return null;
        }
        this.processDelta(delta);
        this.getProject().refreshLocal(2, monitor);
        return null;
    }

    private void processContainer(IContainer project) {
        try {
            IResource[] resources = project.members();
            block2: for (int i = 0; i < resources.length; ++i) {
                if (resources[i] instanceof IContainer) {
                    this.processContainer((IContainer)resources[i]);
                    continue;
                }
                if (!(resources[i] instanceof IFile)) continue;
                for (int j = 0; j < this.taskTagDetectors.size(); ++j) {
                    ITaskTagDetector detector = this.taskTagDetectors.get(j);
                    if (!detector.isSupported((IFile)resources[i])) continue;
                    this.applyDetector(resources[i], detector);
                    continue block2;
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private void processDelta(IResourceDelta delta) {
        IResourceDelta[] children = delta.getAffectedChildren();
        for (int i = 0; i < children.length; ++i) {
            int kind = children[i].getFlags();
            if (kind == 131072) continue;
            IResource resource = children[i].getResource();
            if (resource != null && resource instanceof IFile && resource.exists()) {
                for (int j = 0; j < this.taskTagDetectors.size(); ++j) {
                    ITaskTagDetector detector = this.taskTagDetectors.get(j);
                    if (!detector.isSupported((IFile)resource)) continue;
                    this.applyDetector(resource, detector);
                    break;
                }
            }
            this.processDelta(children[i]);
        }
    }

    private void applyDetector(final IResource resource, final ITaskTagDetector detector) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            try {
                                resource.deleteMarkers("org.eclipse.core.resources.taskmarker", false, 0);
                                detector.detect((IFile)resource, HTMLProjectBuilder.this.tags);
                            }
                            catch (Exception ex) {
                                HTMLPlugin.logException(ex);
                            }
                        }
                    }, null);
                }
                catch (Exception ex) {
                    HTMLPlugin.logException(ex);
                }
            }
        });
    }

    public static void doBuild(IProject project) {
        try {
            if (project.hasNature("tk.eclipse.plugin.htmleditor.HTMLProjectNature")) {
                project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                project.build(6, "tk.eclipse.plugin.htmleditor.HTMLProjectBuilder", new HashMap(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

