/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import tk.eclipse.plugin.htmleditor.ColorProvider;
import tk.eclipse.plugin.htmleditor.HTMLHyperlinkDetector;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.InnerCSSAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.InnerJavaScriptAssistProcessor;
import tk.eclipse.plugin.htmleditor.editors.HTMLAnnotationHover;
import tk.eclipse.plugin.htmleditor.editors.HTMLAutoEditStrategy;
import tk.eclipse.plugin.htmleditor.editors.HTMLDoubleClickStrategy;
import tk.eclipse.plugin.htmleditor.editors.HTMLScanner;
import tk.eclipse.plugin.htmleditor.editors.HTMLTagScanner;
import tk.eclipse.plugin.htmleditor.editors.InnerCSSScanner;
import tk.eclipse.plugin.htmleditor.editors.InnerJavaScriptScanner;

public class HTMLConfiguration
extends SourceViewerConfiguration {
    private HTMLDoubleClickStrategy _doubleClickStrategy;
    private HTMLScanner _scanner;
    private HTMLTagScanner _tagScanner;
    private RuleBasedScanner _commentScanner;
    private RuleBasedScanner _scriptScanner;
    private RuleBasedScanner _doctypeScanner;
    private RuleBasedScanner _directiveScanner;
    private RuleBasedScanner _javaScriptScanner;
    private RuleBasedScanner _cssScanner;
    private ColorProvider _colorProvider;
    private IEditorPart _editor;
    private ContentAssistant _assistant;
    private HTMLAssistProcessor _processor;
    private InnerJavaScriptAssistProcessor _jsProcessor;
    private InnerCSSAssistProcessor _cssProcessor;
    private HTMLAutoEditStrategy _autoEditStrategy;
    private HTMLHyperlinkDetector _hyperlinkDetector;

    public HTMLConfiguration(ColorProvider colorProvider) {
        this._colorProvider = colorProvider;
    }

    public IEditorPart getEditorPart() {
        return this._editor;
    }

    public void setEditorPart(IEditorPart editor) {
        this._editor = editor;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(this._editor);
    }

    protected HTMLAutoEditStrategy createAutoEditStrategy() {
        return new HTMLAutoEditStrategy();
    }

    protected HTMLHyperlinkDetector createHyperlinkDetector() {
        return new HTMLHyperlinkDetector();
    }

    public final HTMLHyperlinkDetector getHyperlinkDetector() {
        if (this._hyperlinkDetector == null) {
            this._hyperlinkDetector = this.createHyperlinkDetector();
        }
        return this._hyperlinkDetector;
    }

    public final HTMLAutoEditStrategy getAutoEditStrategy() {
        if (this._autoEditStrategy == null) {
            this._autoEditStrategy = this.createAutoEditStrategy();
        }
        return this._autoEditStrategy;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__html_comment", "__html_tag", "__html_script", "__html_doctype", "__html_directive", "__html_javascript", "__html_css"};
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        IHyperlinkDetector[] detectors = super.getHyperlinkDetectors(sourceViewer);
        IHyperlinkDetector[] result = new IHyperlinkDetector[detectors.length + 1];
        System.arraycopy(detectors, 0, result, 0, detectors.length);
        result[result.length - 1] = this.getHyperlinkDetector();
        return result;
    }

    public final IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{this.createAutoEditStrategy()};
    }

    public HTMLAssistProcessor getAssistProcessor() {
        if (this._processor == null) {
            this._processor = this.createAssistProcessor();
        }
        return this._processor;
    }

    protected HTMLAssistProcessor createAssistProcessor() {
        HTMLAssistProcessor processor = new HTMLAssistProcessor();
        return processor;
    }

    public InnerJavaScriptAssistProcessor getJavaScriptAssistProcessor() {
        if (this._jsProcessor == null) {
            this._jsProcessor = new InnerJavaScriptAssistProcessor(this.getAssistProcessor());
        }
        return this._jsProcessor;
    }

    public InnerCSSAssistProcessor getCSSAssistProcessor() {
        if (this._cssProcessor == null) {
            this._cssProcessor = new InnerCSSAssistProcessor(this.getAssistProcessor());
        }
        return this._cssProcessor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this._assistant == null) {
            this._assistant = new ContentAssistant();
            this._assistant.setInformationControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent);
                }
            });
            this._assistant.setContextInformationPopupOrientation(20);
            this._assistant.enableAutoInsert(true);
            HTMLAssistProcessor processor = this.getAssistProcessor();
            this._assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
            this._assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__html_tag");
            InnerJavaScriptAssistProcessor jsProcessor = this.getJavaScriptAssistProcessor();
            this._assistant.setContentAssistProcessor((IContentAssistProcessor)jsProcessor, "__html_javascript");
            InnerCSSAssistProcessor cssProcessor = this.getCSSAssistProcessor();
            this._assistant.setContentAssistProcessor((IContentAssistProcessor)cssProcessor, "__html_css");
            this._assistant.enableColoredLabels(true);
            this._assistant.install((ITextViewer)sourceViewer);
            IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
            this._assistant.enableAutoActivation(store.getBoolean("_pref_assist_auto"));
            this._assistant.setAutoActivationDelay(store.getInt("_pref_assist_times"));
            processor.setAutoAssistChars(store.getString("_pref_assist_chars").toCharArray());
            processor.setAssistCloseTag(store.getBoolean("_pref_assist_close"));
        }
        return this._assistant;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this._doubleClickStrategy == null) {
            this._doubleClickStrategy = new HTMLDoubleClickStrategy();
        }
        return this._doubleClickStrategy;
    }

    protected HTMLScanner getHTMLScanner() {
        if (this._scanner == null) {
            this._scanner = new HTMLScanner(this._colorProvider);
            this._scanner.setDefaultReturnToken(this._colorProvider.getToken("__pref_color_foreground"));
        }
        return this._scanner;
    }

    protected HTMLTagScanner getTagScanner() {
        if (this._tagScanner == null) {
            this._tagScanner = new HTMLTagScanner(this._colorProvider);
            this._tagScanner.setDefaultReturnToken(this._colorProvider.getToken("_pref_color_tag"));
        }
        return this._tagScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        if (this._commentScanner == null) {
            this._commentScanner = new RuleBasedScanner();
            this._commentScanner.setDefaultReturnToken(this._colorProvider.getToken("_pref_color_comment"));
        }
        return this._commentScanner;
    }

    protected RuleBasedScanner getScriptScanner() {
        if (this._scriptScanner == null) {
            this._scriptScanner = new RuleBasedScanner();
            this._scriptScanner.setDefaultReturnToken(this._colorProvider.getToken("_pref_color_scriptlet"));
        }
        return this._scriptScanner;
    }

    protected RuleBasedScanner getDirectiveScanner() {
        if (this._directiveScanner == null) {
            this._directiveScanner = new RuleBasedScanner();
            this._directiveScanner.setDefaultReturnToken(this._colorProvider.getToken("_pref_color_scriptlet"));
        }
        return this._directiveScanner;
    }

    protected RuleBasedScanner getDoctypeScanner() {
        if (this._doctypeScanner == null) {
            this._doctypeScanner = new RuleBasedScanner();
            this._doctypeScanner.setDefaultReturnToken(this._colorProvider.getToken("_pref_color_doctype"));
        }
        return this._doctypeScanner;
    }

    protected RuleBasedScanner getJavaScriptScanner() {
        if (this._javaScriptScanner == null) {
            this._javaScriptScanner = new InnerJavaScriptScanner(this._colorProvider);
            this._javaScriptScanner.setDefaultReturnToken(this._colorProvider.getToken("__pref_color_foreground"));
        }
        return this._javaScriptScanner;
    }

    protected RuleBasedScanner getCSSScanner() {
        if (this._cssScanner == null) {
            this._cssScanner = new InnerCSSScanner(this._colorProvider);
            this._cssScanner.setDefaultReturnToken(this._colorProvider.getToken("__pref_color_foreground"));
        }
        return this._cssScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = null;
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_tag");
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getHTMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getScriptScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_script");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_script");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getDoctypeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_doctype");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_doctype");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getDirectiveScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_directive");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_directive");
        dr = new JavaScriptDamagerRepairer((ITokenScanner)this.getJavaScriptScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_javascript");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_javascript");
        dr = new JavaScriptDamagerRepairer((ITokenScanner)this.getCSSScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_css");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_css");
        return reconciler;
    }

    protected ColorProvider getColorProvider() {
        return this._colorProvider;
    }

    private class JavaScriptDamagerRepairer
    extends DefaultDamagerRepairer {
        public JavaScriptDamagerRepairer(ITokenScanner scanner) {
            super(scanner);
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
            if (!documentPartitioningChanged) {
                String source = this.fDocument.get();
                int start = source.substring(0, e.getOffset()).lastIndexOf("/*");
                if (start == -1) {
                    start = 0;
                }
                int end = source.indexOf("*/", e.getOffset());
                int end2 = e.getOffset() + (e.getText() == null ? e.getLength() : e.getText().length());
                end = end == -1 ? source.length() : (end2 > end ? end2 : ++end);
                return new Region(start, end - start);
            }
            return partition;
        }
    }

    private class HTMLTagDamagerRepairer
    extends DefaultDamagerRepairer {
        public HTMLTagDamagerRepairer(ITokenScanner scanner) {
            super(scanner);
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
            if (!documentPartitioningChanged) {
                int end;
                int nextEnd;
                String source = this.fDocument.get();
                int start = source.substring(0, e.getOffset()).lastIndexOf(60);
                if (start == -1) {
                    start = 0;
                }
                if ((nextEnd = source.indexOf(62, (end = source.indexOf(62, e.getOffset())) + 1)) >= 0 && nextEnd > end) {
                    end = nextEnd;
                }
                int end2 = e.getOffset() + (e.getText() == null ? e.getLength() : e.getText().length());
                end = end == -1 ? source.length() : (end2 > end ? end2 : ++end);
                return new Region(start, end - start);
            }
            return partition;
        }
    }
}

