/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.template.HTMLTemplateAssistProcessor;
import tk.eclipse.plugin.htmleditor.template.HTMLTemplateManager;
import tk.eclipse.plugin.htmleditor.template.JavaScriptContextType;
import tk.eclipse.plugin.jseditor.editors.JavaScriptContext;
import tk.eclipse.plugin.jseditor.editors.JavaScriptElement;
import tk.eclipse.plugin.jseditor.editors.JavaScriptFunction;
import tk.eclipse.plugin.jseditor.editors.JavaScriptModel;
import tk.eclipse.plugin.jseditor.editors.JavaScriptVariable;

public class JavaScriptAssistProcessor
extends HTMLTemplateAssistProcessor {
    private static List<AssistInfo> staticAssistInfo;
    private static final int VARIABLE = 0;
    private static final int FUNCTION = 1;
    private static final int KEYWORD = 2;
    private static final int OBJECT = 3;
    private static final int UNDEF = 99;
    private static final String[] GLOBAL_PROPERTIES;
    private static final String[] GLOBAL_FUNCTIONS;
    private static final String[] CLASSES;
    private static Map<String, AssistInfo[]> STATIC_MEMBERS;
    private List<AssistInfo> functions = new ArrayList<AssistInfo>();

    protected String getSource(ITextViewer viewer) {
        return viewer.getDocument().get();
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        Object info;
        ArrayList<ICompletionProposal> proposal = new ArrayList<ICompletionProposal>();
        String source = this.getSource(viewer);
        String[] words = this.getLastWord(viewer, offset);
        String last = words[0];
        String word = words[1];
        ArrayList<Object> addedStrings = new ArrayList<Object>();
        if (last.endsWith(".")) {
            String objName = last.substring(0, last.length() - 1);
            info = STATIC_MEMBERS.get(objName);
            if (info == null && !this.isNumeric(objName)) {
                info = STATIC_MEMBERS.get("Object");
            }
            if (info != null) {
                for (int i = 0; i < ((AssistInfo[])info).length; ++i) {
                    if (!info[i].replaceString.startsWith(word)) continue;
                    proposal.add((ICompletionProposal)info[i].createCompletionProposal(offset, word));
                }
            }
        } else {
            for (int i = 0; i < staticAssistInfo.size(); ++i) {
                info = staticAssistInfo.get(i);
                if (!((AssistInfo)info).replaceString.startsWith(word)) continue;
                proposal.add((ICompletionProposal)((AssistInfo)info).createCompletionProposal(offset, word));
            }
            JavaScriptModel model = new JavaScriptModel(source);
            JavaScriptContext context = model.getContextFromOffset(offset);
            if (context != null) {
                JavaScriptElement[] children = context.getVisibleElements();
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].getName().startsWith(word)) continue;
                    int type = 99;
                    int position = 0;
                    Object replace = null;
                    if (children[i] instanceof JavaScriptFunction) {
                        type = 1;
                        replace = children[i].getName() + "()";
                        position = ((JavaScriptFunction)children[i]).getArguments().length() == 0 ? ((String)replace).length() : ((String)replace).length() - 1;
                    } else if (children[i] instanceof JavaScriptVariable) {
                        type = 0;
                        replace = children[i].getName();
                        position = ((String)replace).length();
                    }
                    if (addedStrings.contains(replace)) continue;
                    proposal.add((ICompletionProposal)new CompletionProposal((String)replace, offset - word.length(), word.length(), position, JavaScriptAssistProcessor.getImageFromType(type), children[i].toString(), null, null));
                    addedStrings.add(replace);
                }
            }
        }
        for (int i = 0; i < this.functions.size(); ++i) {
            info = this.functions.get(i);
            if (!((AssistInfo)info).replaceString.startsWith(word) || addedStrings.contains(((AssistInfo)info).replaceString)) continue;
            proposal.add((ICompletionProposal)((AssistInfo)info).createCompletionProposal(offset, word));
            addedStrings.add(((AssistInfo)info).replaceString);
        }
        ICompletionProposal[] templates = super.computeCompletionProposals(viewer, offset);
        for (int i = 0; i < templates.length; ++i) {
            proposal.add(templates[i]);
        }
        HTMLUtil.sortCompilationProposal(proposal);
        ICompletionProposal[] prop = proposal.toArray(new ICompletionProposal[proposal.size()]);
        return prop;
    }

    private static Image getImageFromType(int type) {
        switch (type) {
            case 2: {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_value");
            }
            case 0: {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_variable");
            }
            case 1: {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_function");
            }
            case 3: {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_class");
            }
        }
        return null;
    }

    private boolean isNumeric(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    protected String[] getLastWord(ITextViewer viewer, int offset) {
        String source = viewer.getDocument().get();
        source = source.substring(0, offset);
        String last = "";
        int start = source.lastIndexOf(10);
        if (start == -1) {
            start = source.lastIndexOf(13);
        }
        if (start == -1) {
            start = 0;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = start; i < offset; ++i) {
            char c = source.charAt(i);
            if (Character.isWhitespace(c) || !Character.isJavaIdentifierPart(c)) {
                if (sb.length() == 0) continue;
                if (c == '.') {
                    sb.append(c);
                }
                last = sb.toString();
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        return new String[]{last, sb.toString()};
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new ContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public String getErrorMessage() {
        return "error";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    @Override
    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        HTMLTemplateManager manager = HTMLTemplateManager.getInstance();
        return manager.getContextTypeRegistry().getContextType(JavaScriptContextType.CONTEXT_TYPE);
    }

    public void update(IFile file) {
        try {
            HTMLProjectParams params = new HTMLProjectParams(file.getProject());
            String[] javaScripts = params.getJavaScripts();
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            this.functions.clear();
            for (int i = 0; i < javaScripts.length; ++i) {
                InputStream in = null;
                if (javaScripts[i].startsWith("entry:")) {
                    IResource resource = wsroot.findMember(javaScripts[i].substring("entry:".length()));
                    if (resource != null && resource instanceof IFile && resource.exists()) {
                        in = ((IFile)resource).getContents();
                    }
                } else {
                    in = new FileInputStream(javaScripts[i]);
                }
                String source = new String(HTMLUtil.readStream(in));
                JavaScriptModel model = new JavaScriptModel(source);
                JavaScriptElement[] elements = model.getChildren();
                for (int j = 0; j < elements.length; ++j) {
                    if (!(elements[j] instanceof JavaScriptFunction)) continue;
                    String replace = elements[j].getName() + "()";
                    int position = 0;
                    position = ((JavaScriptFunction)elements[j]).getArguments().length() == 0 ? replace.length() : replace.length() - 1;
                    this.functions.add(new AssistInfo(1, elements[j].toString(), replace, position));
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    static {
        int i;
        staticAssistInfo = new ArrayList<AssistInfo>();
        GLOBAL_PROPERTIES = new String[]{"Infinity", "NaN", "undefined"};
        GLOBAL_FUNCTIONS = new String[]{"decodeURI()", "decodeURIComponent()", "encodeURI()", "encodeURIComponent()", "escape()", "unescape()", "eval()", "isNaN()", "parseFloat()", "parseInt()", "taint()", "untaint()"};
        CLASSES = new String[]{"Arguments", "Array", "Boolean", "Date", "Error", "Function", "Math", "NativeError", "Number", "Object", "RegExp", "String"};
        STATIC_MEMBERS = new HashMap<String, AssistInfo[]>();
        for (i = 0; i < GLOBAL_PROPERTIES.length; ++i) {
            staticAssistInfo.add(new AssistInfo(0, GLOBAL_PROPERTIES[i], GLOBAL_PROPERTIES[i].length()));
        }
        for (i = 0; i < GLOBAL_FUNCTIONS.length; ++i) {
            staticAssistInfo.add(new AssistInfo(1, GLOBAL_FUNCTIONS[i], GLOBAL_FUNCTIONS[i].length() - 1));
        }
        for (i = 0; i < CLASSES.length; ++i) {
            staticAssistInfo.add(new AssistInfo(3, CLASSES[i], CLASSES[i], CLASSES[i].length()));
        }
        AssistInfo[] math = new AssistInfo[]{new AssistInfo(0, "E - Math", "E"), new AssistInfo(0, "LN10 - Math", "LN10"), new AssistInfo(0, "LN2 - Math", "LN2"), new AssistInfo(0, "LOG10E - Math", "LOG10E"), new AssistInfo(0, "LOG2E - Math", "LOG2E"), new AssistInfo(0, "PI - Math", "PI"), new AssistInfo(0, "SQRT1_2 - Math", "SQRT1_2"), new AssistInfo(0, "SQRT2 - Math", "SQRT2"), new AssistInfo(1, "abs() - Math", "abs()"), new AssistInfo(1, "acos() - Math", "acos()"), new AssistInfo(1, "asin() - Math", "asin()"), new AssistInfo(1, "atan() - Math", "atan()"), new AssistInfo(1, "atan2() - Math", "atan2()"), new AssistInfo(1, "ceil() - Math", "ceil()"), new AssistInfo(1, "cos() - Math", "cos()"), new AssistInfo(1, "exp() - Math", "exp()"), new AssistInfo(1, "floor() - Math", "floor()"), new AssistInfo(1, "log() - Math", "log()"), new AssistInfo(1, "max() - Math", "max()"), new AssistInfo(1, "min() - Math", "min()"), new AssistInfo(1, "pow() - Math", "pow()"), new AssistInfo(1, "random() - Math", "random()"), new AssistInfo(1, "round() - Math", "round()"), new AssistInfo(1, "sin() - Math", "sin()"), new AssistInfo(1, "sqrt() - Math", "sqrt()"), new AssistInfo(1, "tan() - Math", "tan()")};
        STATIC_MEMBERS.put("Math", math);
        AssistInfo[] object = new AssistInfo[]{new AssistInfo(0, "constructor - Object", "constructor"), new AssistInfo(0, "prototype - Object", "prototype"), new AssistInfo(1, "hasOwnProperty() - Object", "hasOwnProperty()"), new AssistInfo(1, "hasOwnProperty() - Object", "hasOwnProperty()"), new AssistInfo(1, "isPrototyprOf() - Object", "isPrototyprOf()"), new AssistInfo(1, "propertyIsEnumerable() - Object", "propertyIsEnumerable()"), new AssistInfo(1, "toLocaleString() - Object", "toLocaleString()"), new AssistInfo(1, "toSource() - Object", "toSource()"), new AssistInfo(1, "toString() - Object", "toString()"), new AssistInfo(1, "unwatch() - Object", "unwatch()"), new AssistInfo(1, "valueOf() - Object", "valueOf()"), new AssistInfo(1, "watch() - Object", "watch()")};
        STATIC_MEMBERS.put("Object", object);
    }

    private static class AssistInfo {
        private int type;
        private int position;
        private String displayString;
        private String replaceString;

        public AssistInfo(int type, String string) {
            this(type, string, string);
        }

        public AssistInfo(int type, String string, int position) {
            this(type, string, string, position);
        }

        public AssistInfo(int type, String displayString, String replaceString) {
            this(type, displayString, replaceString, replaceString.endsWith("()") ? replaceString.length() - 1 : replaceString.length());
        }

        public AssistInfo(int type, String displayString, String replaceString, int position) {
            this.type = type;
            this.displayString = displayString;
            this.replaceString = replaceString;
            this.position = position;
        }

        public CompletionProposal createCompletionProposal(int offset, String word) {
            return new CompletionProposal(this.replaceString, offset - word.length(), word.length(), this.position, JavaScriptAssistProcessor.getImageFromType(this.type), this.displayString, null, null);
        }
    }
}

