/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jseditor.editors.JavaScriptContext;
import tk.eclipse.plugin.jseditor.editors.JavaScriptElement;
import tk.eclipse.plugin.jseditor.editors.JavaScriptFunction;
import tk.eclipse.plugin.jseditor.editors.JavaScriptModel;

public class JavaScriptHyperlinkDetector
implements IHyperlinkDetector {
    private List<FunctionInfo> functions = new ArrayList<FunctionInfo>();

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        JavaScriptModel model;
        JavaScriptContext context;
        char c;
        int index;
        String source = textViewer.getDocument().get();
        int offset = region.getOffset();
        Object word = String.valueOf(source.charAt(offset));
        for (index = offset - 1; index >= 0 && Character.isJavaIdentifierPart(c = source.charAt(index)); --index) {
            word = c + (String)word;
        }
        index = offset + 1;
        offset = offset - ((String)word).length() + 1;
        while (source.length() > index) {
            c = source.charAt(index);
            if (Character.isJavaIdentifierPart(c)) {
                word = (String)word + c;
                ++index;
                continue;
            }
            if (c == '(') break;
            return null;
        }
        if ((context = (model = new JavaScriptModel(source)).getContextFromOffset(offset)) != null) {
            JavaScriptElement[] children = context.getVisibleElements();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof JavaScriptFunction)) continue;
                JavaScriptFunction function = (JavaScriptFunction)children[i];
                if (!children[i].getName().equals(word)) continue;
                Region hyperlinkRegion = new Region(offset, ((String)word).length());
                return new IHyperlink[]{new JavaScriptHyperlink((IRegion)hyperlinkRegion, textViewer, function.getOffset())};
            }
        }
        for (int i = 0; i < this.functions.size(); ++i) {
            FunctionInfo info = this.functions.get(i);
            if (!info.function.getName().equals(word)) continue;
            Region hyperlinkRegion = new Region(offset, ((String)word).length());
            return new IHyperlink[]{new JavaScriptHyperlink((IRegion)hyperlinkRegion, info.resource, info.function.getOffset())};
        }
        return null;
    }

    public void update(IFile file) {
        try {
            this.functions.clear();
            HTMLProjectParams params = new HTMLProjectParams(file.getProject());
            String[] javaScripts = params.getJavaScripts();
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            for (int i = 0; i < javaScripts.length; ++i) {
                InputStream in = null;
                File obj = null;
                if (javaScripts[i].startsWith("entry:")) {
                    IResource resource = wsroot.findMember(javaScripts[i].substring("entry:".length()));
                    if (resource != null && resource instanceof IFile && resource.exists()) {
                        in = ((IFile)resource).getContents();
                        obj = resource;
                    }
                } else {
                    obj = new File(javaScripts[i]);
                    in = new FileInputStream(javaScripts[i]);
                }
                String source = new String(HTMLUtil.readStream(in));
                JavaScriptModel model = new JavaScriptModel(source);
                JavaScriptElement[] elements = model.getChildren();
                for (int j = 0; j < elements.length; ++j) {
                    if (!(elements[j] instanceof JavaScriptFunction)) continue;
                    FunctionInfo info = new FunctionInfo();
                    info.resource = obj;
                    info.function = (JavaScriptFunction)elements[j];
                    this.functions.add(info);
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private class JavaScriptHyperlink
    implements IHyperlink {
        private IRegion region;
        private Object resource;
        private int beginOffset;

        public JavaScriptHyperlink(IRegion region, Object resource, int beginOffset) {
            this.region = region;
            this.resource = resource;
            this.beginOffset = beginOffset;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }

        public void open() {
            if (this.resource instanceof IFile) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)this.resource), (boolean)true);
                    IGotoMarker gotoMarker = (IGotoMarker)editor.getAdapter(IGotoMarker.class);
                    if (gotoMarker != null) {
                        IMarker marker = ((IFile)this.resource).createMarker("org.eclipse.core.resources.textmarker");
                        marker.setAttribute("charStart", this.beginOffset);
                        marker.setAttribute("charEnd", this.beginOffset);
                        gotoMarker.gotoMarker(marker);
                    }
                }
                catch (Exception ex) {
                    HTMLPlugin.logException(ex);
                }
            }
            if (this.resource instanceof ITextViewer) {
                ((ITextViewer)this.resource).setSelectedRange(this.beginOffset, 0);
            }
            if (this.resource instanceof File) {
                // empty if block
            }
        }
    }

    private class FunctionInfo {
        private Object resource;
        private JavaScriptFunction function;

        private FunctionInfo() {
        }
    }
}

