/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.IEOModelGroupFactory;
import org.objectstyle.wolips.eomodeler.core.model.ManifestSearchFolder;

public abstract class AbstractManifestEOModelGroupFactory
implements IEOModelGroupFactory {
    @Override
    public boolean loadModelGroup(Object modelGroupResource, EOModelGroup modelGroup, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, IProgressMonitor progressMonitor) throws EOModelException {
        int previousModelCount = modelGroup.getModels().size();
        try {
            File modelGroupFile = null;
            if (modelGroupResource == null) {
                modelGroupFile = null;
            } else if (modelGroupResource instanceof IResource) {
                modelGroupFile = ((IResource)modelGroupResource).getLocation().toFile();
            } else if (modelGroupResource instanceof File) {
                modelGroupFile = (File)modelGroupResource;
            } else if (modelGroupResource instanceof URL) {
                modelGroupFile = URLUtils.cheatAndTurnIntoFile((URL)((URL)modelGroupResource));
            } else if (modelGroupResource instanceof URI) {
                modelGroupFile = URLUtils.cheatAndTurnIntoFile((URI)((URI)modelGroupResource));
            } else {
                throw new EOModelException("Unknown model resource: " + modelGroupResource);
            }
            List<ManifestSearchFolder> searchFolders = this.getSearchFolders(modelGroupFile);
            if (searchFolders != null) {
                LinkedHashSet<ManifestSearchFolder> uniqueSearchFolders = new LinkedHashSet<ManifestSearchFolder>(searchFolders);
                boolean printedHeader = false;
                for (ManifestSearchFolder searchFolder : uniqueSearchFolders) {
                    if (!printedHeader) {
                        System.out.println(this.getClass().getSimpleName() + ", Searching: ");
                        printedHeader = true;
                    }
                    System.out.println("  " + searchFolder);
                    modelGroup.loadModelsFromURL(searchFolder.getFolder().toURL(), searchFolder.getDepth(), failures, skipOnDuplicates, progressMonitor);
                }
            }
            if (modelGroupFile != null && modelGroupFile.getName().endsWith(".eomodeld")) {
                modelGroup.loadModelsFromURL(modelGroupFile.toURL(), 1, failures, skipOnDuplicates, progressMonitor);
            }
        }
        catch (IOException e) {
            throw new EOModelException("Failed to load model groups.", e);
        }
        boolean allModelsLoaded = modelGroup.getModels().size() - previousModelCount > 1;
        return allModelsLoaded;
    }

    public abstract List<ManifestSearchFolder> getSearchFolders(File var1) throws IOException, EOModelException;
}

