/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateDatabaseConfigFailure;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateDatabaseConfigNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateEntityFailure;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateEntityNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateStoredProcedureFailure;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateStoredProcedureNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOLastModified;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelParserDataStructureFactory;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;
import org.objectstyle.wolips.eomodeler.core.model.ISortableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListMap;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListSet;
import org.objectstyle.wolips.eomodeler.core.model.UserInfoableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.VerificationContext;
import org.objectstyle.wolips.eomodeler.core.model.history.EOEntityAddedEvent;
import org.objectstyle.wolips.eomodeler.core.model.history.EOEntityDeletedEvent;
import org.objectstyle.wolips.eomodeler.core.model.history.ModelEvents;
import org.objectstyle.wolips.eomodeler.core.utils.NamingConvention;

public class EOModel
extends UserInfoableEOModelObject<EOModelGroup>
implements ISortableEOModelObject {
    public static final String CURRENT_VERSION = "1.0.1";
    public static final String DIRTY = "dirty";
    public static final String ENTITY = "entity";
    public static final String ADAPTOR_NAME = "adaptorName";
    public static final String VERSION = "version";
    public static final String NAME = "name";
    public static final String ENTITIES = "entities";
    public static final String STORED_PROCEDURE = "storedProcedure";
    public static final String STORED_PROCEDURES = "storedProcedures";
    public static final String ACTIVE_DATABASE_CONFIG = "activeDatabaseConfig";
    public static final String DATABASE_CONFIG = "databaseConfig";
    public static final String DATABASE_CONFIGS = "databaseConfigs";
    public static final String ATTRIBUTE_NAMING_CONVENTION = "attributeNamingConvention";
    public static final String ENTITY_NAMING_CONVENTION = "entityNamingConvention";
    public static final String MODEL_SAVING = "modelSaving";
    public static final String REVERSE_ENGINEERED = "reverseEngineered";
    private EOModelGroup myModelGroup;
    private String myName;
    private String myVersion;
    private Set<EOEntity> myEntities;
    private Set<EODatabaseConfig> myDatabaseConfigs;
    private EODatabaseConfig myActiveDatabaseConfig;
    private Set<EOStoredProcedure> myStoredProcedures;
    private Set<String> myDeletedEntityNamesInObjectStore;
    private Set<String> myDeletedEntityNames;
    private Set<String> myDeletedStoredProcedureNames;
    private EOModelMap myModelMap;
    private boolean myDirty;
    private URL myModelURL;
    private Set<EOAttribute> myPrototypeAttributeCache;
    private ModelEvents _modelEvents;
    private NamingConvention _entityNamingConvention;
    private NamingConvention _attributeNamingConvention;
    private boolean _reverseEngineered;
    private EOLastModified _lastModified;
    private Map<String, EOEntity> _entitiesCache = new HashMap<String, EOEntity>();

    public EOModel(String _name) {
        this.myName = _name;
        this.myEntities = new HashSet<EOEntity>();
        this.myStoredProcedures = new HashSet<EOStoredProcedure>();
        this.myDatabaseConfigs = new HashSet<EODatabaseConfig>();
        this.myDeletedEntityNamesInObjectStore = new PropertyListSet<String>();
        this.myDeletedEntityNames = new PropertyListSet<String>();
        this.myDeletedStoredProcedureNames = new PropertyListSet<String>();
        this.myVersion = "2.1";
        this.myModelMap = new EOModelMap();
        this._modelEvents = new ModelEvents();
        this._entityNamingConvention = NamingConvention.DEFAULT;
        this._attributeNamingConvention = NamingConvention.DEFAULT;
    }

    public EOModel(URL modelURL) throws EOModelException, IOException {
        this(EOModelGroup.getModelNameForURL(modelURL));
        HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
        this.loadFromURL(modelURL, failures);
        if (failures.size() > 0) {
            throw new EOModelException("Failed to load model from URL '" + modelURL + "': " + failures);
        }
    }

    public EOModel(URL modelURL, Set<EOModelVerificationFailure> failures) throws EOModelException, IOException {
        this(EOModelGroup.getModelNameForURL(modelURL));
        this.loadFromURL(modelURL, failures);
    }

    protected void _storedProcedureChanged(EOStoredProcedure _storedProcedure, String _propertyName, Object _oldValue, Object _newValue) {
        this.firePropertyChange("storedProcedure." + _propertyName, _oldValue, _newValue);
        this.firePropertyChange(STORED_PROCEDURE, null, _storedProcedure);
    }

    public void _setModelGroup(EOModelGroup _modelGroup) {
        this.myModelGroup = _modelGroup;
    }

    public void setEntityNamingConvention(NamingConvention entityNamingConvention) {
        NamingConvention oldEntityNamingConvention = this._entityNamingConvention;
        this._entityNamingConvention = entityNamingConvention;
        this.firePropertyChange(ENTITY_NAMING_CONVENTION, oldEntityNamingConvention, this._entityNamingConvention);
    }

    public NamingConvention getEntityNamingConvention() {
        return this._entityNamingConvention;
    }

    public void setAttributeNamingConvention(NamingConvention attributeNamingConvention) {
        NamingConvention oldAttributeNamingConvention = this._attributeNamingConvention;
        this._attributeNamingConvention = attributeNamingConvention;
        this.firePropertyChange(ATTRIBUTE_NAMING_CONVENTION, oldAttributeNamingConvention, this._attributeNamingConvention);
    }

    public NamingConvention getAttributeNamingConvention() {
        return this._attributeNamingConvention;
    }

    @Override
    public Set<EOModelReferenceFailure> getReferenceFailures() {
        return new HashSet<EOModelReferenceFailure>();
    }

    public String guessPackageName() {
        return this.guessPackageName(this.getEntities());
    }

    public String guessPackageName(Set<EOEntity> _entities) {
        String guessPackageName = null;
        for (EOEntity entity : _entities) {
            int packageNameEnd;
            String packageName;
            String className = entity.getClassName();
            if (className == null || "".equals(packageName = (packageNameEnd = className.lastIndexOf(46)) != -1 ? className.substring(0, packageNameEnd) : "")) continue;
            if (guessPackageName == null) {
                guessPackageName = packageName;
                continue;
            }
            if ("".equals(guessPackageName) || guessPackageName.equals(packageName)) continue;
            guessPackageName = "";
        }
        return guessPackageName;
    }

    public EOEntity addBlankEntity(String name) throws DuplicateNameException {
        String newEntityName = this.findUnusedEntityName(name);
        EOEntity entity = new EOEntity(newEntityName);
        entity.guessExternalNameInModel(this);
        entity.guessClassNameInModel(this);
        this.addEntity(entity);
        if (this.myModelGroup != null && this.myModelGroup.hasProjectWonder()) {
            EOAttribute pk = new EOAttribute("id");
            pk.setPrototype(this.getPrototypeAttributeNamed("id"));
            pk.setColumnName("id");
            pk.setPrimaryKey(Boolean.TRUE);
            pk.setClassProperty(Boolean.FALSE);
            pk.setUsedForLocking(Boolean.TRUE);
            entity.addAttribute(pk);
        }
        return entity;
    }

    public boolean isEditing() {
        EOModelGroup modelGroup = this.getModelGroup();
        boolean editing = modelGroup == null || this.getName().equals(modelGroup.getEditingModelName());
        return editing;
    }

    public boolean isReverseEngineered() {
        return this._reverseEngineered;
    }

    public void setReverseEngineered(boolean reverseEngineered) {
        Boolean oldReverseEngineered = this._reverseEngineered;
        this._reverseEngineered = reverseEngineered;
        this.firePropertyChange(REVERSE_ENGINEERED, oldReverseEngineered, this._reverseEngineered);
    }

    public boolean isDirty() {
        return this.myDirty;
    }

    public void setDirty(boolean _dirty) {
        Boolean oldDirty = this.myDirty;
        this.myDirty = _dirty;
        this.firePropertyChange(DIRTY, oldDirty, this.myDirty);
    }

    @Override
    protected void firePropertyChange(String _propertyName, Object _oldValue, Object _newValue) {
        super.firePropertyChange(_propertyName, _oldValue, _newValue);
    }

    @Override
    protected void _propertyChanged(String _propertyName, Object _oldValue, Object _newValue) {
        if (!(this.myDirty || DIRTY.equals(_propertyName) || MODEL_SAVING.equals(_propertyName))) {
            this.setDirty(true);
        }
        if (this.myModelGroup != null) {
            this.myModelGroup._modelChanged(this, _propertyName, _oldValue, _newValue);
        }
    }

    protected void _entityChanged(EOEntity _entity, String _propertyName, Object _oldValue, Object _newValue) {
        this.firePropertyChange("entity." + _propertyName, _oldValue, _newValue);
        this.firePropertyChange(ENTITY, null, _entity);
    }

    protected void _databaseConfigChanged(EODatabaseConfig _databaseConfig, String _propertyName, Object _oldValue, Object _newValue) {
        this.firePropertyChange("databaseConfig." + _propertyName, _oldValue, _newValue);
        this.firePropertyChange(DATABASE_CONFIG, null, _databaseConfig);
        if (_databaseConfig == this.myActiveDatabaseConfig) {
            this.clearCachedPrototypes(null, false);
        }
    }

    public EODatabaseConfig getDatabaseConfigNamed(String _name) {
        EODatabaseConfig matchingDatabaseConfig = null;
        Iterator<EODatabaseConfig> databaseConfigsIter = this.myDatabaseConfigs.iterator();
        while (matchingDatabaseConfig == null && databaseConfigsIter.hasNext()) {
            EODatabaseConfig entity = databaseConfigsIter.next();
            if (!ComparisonUtils.equals((Object)entity.getName(), (Object)_name)) continue;
            matchingDatabaseConfig = entity;
        }
        return matchingDatabaseConfig;
    }

    public String findUnusedDatabaseConfigName(String _newName) {
        return this._findUnusedName(_newName, "getDatabaseConfigNamed");
    }

    public void _checkForDuplicateDatabaseConfigName(EODatabaseConfig _databaseConfig, String _newName, Set<EOModelVerificationFailure> _failures) throws DuplicateDatabaseConfigNameException {
        EODatabaseConfig existingDatabaseConfig = this.getDatabaseConfigNamed(_newName);
        if (existingDatabaseConfig != null && existingDatabaseConfig != _databaseConfig) {
            if (_failures == null) {
                throw new DuplicateDatabaseConfigNameException(_newName, this);
            }
            String unusedName = this.findUnusedDatabaseConfigName(_newName);
            existingDatabaseConfig.setName(unusedName, true);
            _failures.add(new DuplicateDatabaseConfigFailure(this, _newName, unusedName));
        }
    }

    public EODatabaseConfig addBlankDatabaseConfig(String _name) throws DuplicateNameException {
        String newDatabaseConfigNameBase = _name;
        String newDatabaseConfigName = this.findUnusedDatabaseConfigName(newDatabaseConfigNameBase);
        EODatabaseConfig databaseConfig = new EODatabaseConfig(newDatabaseConfigName);
        this.addDatabaseConfig(databaseConfig);
        return databaseConfig;
    }

    public boolean canConvertDatabaseConfigsToSingleConnectionDictionary() {
        boolean canConvertDatabaseConfigsToSingleConnectionDictionary;
        if (this.myDatabaseConfigs == null || this.myDatabaseConfigs.size() == 0) {
            canConvertDatabaseConfigsToSingleConnectionDictionary = true;
        } else if (this.myDatabaseConfigs.size() == 1) {
            EODatabaseConfig databaseConfig = this.getDatabaseConfigs().iterator().next();
            canConvertDatabaseConfigsToSingleConnectionDictionary = databaseConfig.canConvertToConnectionDictionary();
        } else {
            canConvertDatabaseConfigsToSingleConnectionDictionary = false;
        }
        return canConvertDatabaseConfigsToSingleConnectionDictionary;
    }

    public void addDatabaseConfig(EODatabaseConfig _databaseConfig) throws DuplicateNameException {
        this.addDatabaseConfig(_databaseConfig, true, null);
    }

    public void addDatabaseConfig(EODatabaseConfig _databaseConfig, boolean _fireEvents, Set<EOModelVerificationFailure> _failures) throws DuplicateNameException {
        _databaseConfig._setModel(this);
        this._checkForDuplicateDatabaseConfigName(_databaseConfig, _databaseConfig.getName(), _failures);
        _databaseConfig.pasted();
        if (_fireEvents) {
            Set<EODatabaseConfig> oldDatabaseConfigs = null;
            oldDatabaseConfigs = this.myDatabaseConfigs;
            HashSet<EODatabaseConfig> newEntities = new HashSet<EODatabaseConfig>();
            newEntities.addAll(this.myDatabaseConfigs);
            newEntities.add(_databaseConfig);
            this.myDatabaseConfigs = newEntities;
            this.firePropertyChange(DATABASE_CONFIGS, oldDatabaseConfigs, this.myDatabaseConfigs);
            if (this.myActiveDatabaseConfig == null) {
                this.setActiveDatabaseConfig(_databaseConfig);
            }
        } else {
            this.myDatabaseConfigs.add(_databaseConfig);
        }
    }

    public void removeDatabaseConfig(EODatabaseConfig _databaseConfig) {
        if (ComparisonUtils.equals((Object)this.myActiveDatabaseConfig, (Object)_databaseConfig)) {
            EODatabaseConfig newActiveDatabaseConfig = null;
            if (!this.myDatabaseConfigs.isEmpty()) {
                Iterator<EODatabaseConfig> databaseConfigsIter = this.myDatabaseConfigs.iterator();
                while (newActiveDatabaseConfig == null && databaseConfigsIter.hasNext()) {
                    EODatabaseConfig otherDatabaseConfig = databaseConfigsIter.next();
                    if (otherDatabaseConfig == _databaseConfig) continue;
                    newActiveDatabaseConfig = otherDatabaseConfig;
                }
            }
            this.setActiveDatabaseConfig(newActiveDatabaseConfig);
        }
        Set<EODatabaseConfig> oldDatabaseConfigs = this.myDatabaseConfigs;
        HashSet<EODatabaseConfig> newDatabaseConfigs = new HashSet<EODatabaseConfig>();
        newDatabaseConfigs.addAll(this.myDatabaseConfigs);
        newDatabaseConfigs.remove(_databaseConfig);
        this.myDatabaseConfigs = newDatabaseConfigs;
        this.firePropertyChange(DATABASE_CONFIGS, oldDatabaseConfigs, this.myDatabaseConfigs);
        _databaseConfig._setModel(null);
    }

    public void setActiveDatabaseConfig(EODatabaseConfig activeDatabaseConfig) {
        this.setActiveDatabaseConfig(activeDatabaseConfig, true);
    }

    public void setActiveDatabaseConfig(EODatabaseConfig activeDatabaseConfig, boolean fireEvents) {
        EODatabaseConfig oldActiveDatabaseConfig = this.myActiveDatabaseConfig;
        this.myActiveDatabaseConfig = activeDatabaseConfig;
        this.clearCachedPrototypes(null, false);
        if (fireEvents) {
            this.firePropertyChange(ACTIVE_DATABASE_CONFIG, oldActiveDatabaseConfig, this.myActiveDatabaseConfig);
        }
    }

    public EODatabaseConfig getActiveDatabaseConfig() {
        return this.myActiveDatabaseConfig;
    }

    public EODatabaseConfig _createDatabaseConfig(String adaptorName, Map<Object, Object> connectionDictionary) {
        EODatabaseConfig defaultDatabaseConfig = new EODatabaseConfig(this.findUnusedDatabaseConfigName("Default"));
        defaultDatabaseConfig.setAdaptorName(adaptorName);
        if (connectionDictionary != null) {
            defaultDatabaseConfig.setConnectionDictionary(new HashMap<Object, Object>(connectionDictionary));
        }
        defaultDatabaseConfig.setPrototype(this._getPreferredPrototypeEntity(adaptorName, connectionDictionary));
        defaultDatabaseConfig._setModel(this);
        return defaultDatabaseConfig;
    }

    public Map<EOAttribute, Set<EORelationship>> _createReferencingRelationshipsCache() {
        HashMap<EOAttribute, Set<EORelationship>> cache = new HashMap<EOAttribute, Set<EORelationship>>();
        this._createReferencingRelationshipsCache(cache);
        return cache;
    }

    public void _createReferencingRelationshipsCache(Map<EOAttribute, Set<EORelationship>> cache) {
        for (EOEntity entity : this.getEntities()) {
            for (EORelationship relationship : entity.getRelationships()) {
                Set<EOAttribute> relatedAttributes = relationship.getRelatedAttributes();
                for (EOAttribute attribute : relatedAttributes) {
                    Set<EORelationship> relatedRelationships = cache.get(attribute);
                    if (relatedRelationships == null) {
                        relatedRelationships = new HashSet<EORelationship>();
                        cache.put(attribute, relatedRelationships);
                    }
                    relatedRelationships.add(relationship);
                }
            }
        }
    }

    public Map<EOEntity, Set<EOEntity>> _createInheritanceCache() {
        HashMap<EOEntity, Set<EOEntity>> cache = new HashMap<EOEntity, Set<EOEntity>>();
        this._createInheritanceCache(cache);
        return cache;
    }

    public void _createInheritanceCache(Map<EOEntity, Set<EOEntity>> cache) {
        for (EOEntity entity : this.getEntities()) {
            EOEntity parentEntity = entity.getParent();
            if (parentEntity == null) continue;
            Set<EOEntity> childrenEntities = cache.get(parentEntity);
            if (childrenEntities == null) {
                childrenEntities = new HashSet<EOEntity>();
                cache.put(parentEntity, childrenEntities);
            }
            childrenEntities.add(entity);
        }
    }

    public Set<EODatabaseConfig> getDatabaseConfigs() {
        return this.myDatabaseConfigs;
    }

    public Set<EODatabaseConfig> getSortedDatabaseConfigs() {
        return new PropertyListSet<EODatabaseConfig>((Collection<EODatabaseConfig>)this.myDatabaseConfigs);
    }

    public URL getModelURL() {
        return this.myModelURL;
    }

    public void setModelURL(URL _modelURL) {
        this.myModelURL = _modelURL;
    }

    public EOModelGroup getModelGroup() {
        return this.myModelGroup;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String _version) {
        String oldVersion = this.myVersion;
        this.myVersion = _version;
        this.firePropertyChange(VERSION, _version, oldVersion);
    }

    @Override
    public void setName(String _name) {
        String oldName = this.myName;
        this.myName = _name;
        this.firePropertyChange(NAME, _name, oldName);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public Set<EOEntity> getNonPrototypeEntities() {
        HashSet<EOEntity> entities = new HashSet<EOEntity>();
        for (EOEntity entity : this.getEntities()) {
            if (entity.isPrototype()) continue;
            entities.add(entity);
        }
        return entities;
    }

    public Set<EOEntity> getEntities() {
        return this.myEntities;
    }

    public Set<EOEntity> getSortedEntities() {
        return new PropertyListSet<EOEntity>((Collection<EOEntity>)this.myEntities);
    }

    public EOEntity _getEntityNamedAndCheckModelGroup(String newName) {
        EOEntity entity = this.myModelGroup.getEntityNamed(newName);
        if (entity == null) {
            entity = this.getEntityNamed(newName);
        }
        return entity;
    }

    public String findUnusedEntityName(String _newName) {
        return this._findUnusedName(_newName, "_getEntityNamedAndCheckModelGroup");
    }

    public void _checkForDuplicateEntityName(EOEntity _entity, String _newName, Set<EOModelVerificationFailure> _failures) throws DuplicateEntityNameException {
        EOEntity existingEntity = null;
        if (this.myModelGroup != null) {
            existingEntity = this.myModelGroup.getEntityNamed(_newName);
        }
        if (existingEntity == null) {
            existingEntity = this.getEntityNamed(_newName);
        }
        if (existingEntity != null && existingEntity != _entity) {
            if (_failures == null || _entity.getModel() != existingEntity.getModel()) {
                throw new DuplicateEntityNameException(_newName, this, existingEntity);
            }
            String unusedName = this.findUnusedEntityName(_newName);
            existingEntity.setName(unusedName, true);
            _failures.add(new DuplicateEntityFailure(this, _newName, unusedName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _entityNameChanged(String _originalName, String _oldName, String _newName) {
        if (this.myDeletedEntityNamesInObjectStore == null) {
            this.myDeletedEntityNamesInObjectStore = new PropertyListSet<String>();
        }
        if (_originalName != null && _originalName.length() > 0) {
            this.myDeletedEntityNamesInObjectStore.add(_originalName);
            this.myDeletedEntityNames.add(_originalName);
            Map<String, EOEntity> map = this._entitiesCache;
            synchronized (map) {
                EOEntity entity = this._entitiesCache.remove(_oldName);
                if (entity != null) {
                    this._entitiesCache.put(_newName, entity);
                }
            }
        }
    }

    public boolean containsEntityNamed(String _entityName) {
        return this.getEntityNamed(_entityName) != null;
    }

    public Set importEntitiesFromModel(URL sourceModelURL, Set<EOModelVerificationFailure> failures) throws EOModelException, IOException {
        EOModelGroup sourceModelGroup = new EOModelGroup();
        EOModel sourceModel = new EOModel("Temp");
        sourceModelGroup.addModel(sourceModel);
        sourceModel.loadFromURL(sourceModelURL, failures);
        sourceModel.resolve(failures);
        sourceModel.resolveFlattened(failures);
        return this.importEntitiesFromModel(sourceModel, failures);
    }

    public Set<EOEntity> importEntitiesFromModel(EOModel sourceModel, Set<EOModelVerificationFailure> failures) throws DuplicateNameException {
        HashSet<EOEntity> clonedEntities = new HashSet<EOEntity>();
        for (EOEntity entity : sourceModel.getEntities()) {
            clonedEntities.add(entity._cloneModelObject());
        }
        this.addEntities(clonedEntities, failures);
        this.guessPrototypes(clonedEntities);
        return clonedEntities;
    }

    public void guessPrototypes() {
        this.guessPrototypes(this.getEntities());
    }

    public void guessPrototypes(Set<EOEntity> entities) {
        for (EOEntity entity : entities) {
            for (EOAttribute attribute : entity.getAttributes()) {
                attribute.guessPrototype(true);
            }
        }
    }

    public void addEntities(Set<EOEntity> entities, Set<EOModelVerificationFailure> failures) throws DuplicateNameException {
        HashSet<EOEntity> oldEntities = new HashSet<EOEntity>();
        oldEntities.addAll(this.myEntities);
        for (EOEntity entity : entities) {
            this.addEntity(entity, false, false, failures);
        }
        for (EOEntity entity : entities) {
            entity.pasted();
        }
        this.firePropertyChange(ENTITIES, oldEntities, this.myEntities);
    }

    public void addEntity(EOEntity _entity) throws DuplicateNameException {
        this.addEntity(_entity, true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntity(EOEntity entity, boolean pasteImmediately, boolean fireEvents, Set<EOModelVerificationFailure> failures) throws DuplicateNameException {
        entity._setModel(this);
        this._checkForDuplicateEntityName(entity, entity.getName(), failures);
        if (pasteImmediately) {
            entity.pasted();
        }
        Map<String, EOEntity> map = this._entitiesCache;
        synchronized (map) {
            this._entitiesCache.put(entity.getName(), entity);
        }
        this.myDeletedEntityNames.remove(entity.getName());
        if (fireEvents) {
            Set<EOEntity> oldEntities = null;
            oldEntities = this.myEntities;
            HashSet<EOEntity> newEntities = new HashSet<EOEntity>();
            newEntities.addAll(this.myEntities);
            newEntities.add(entity);
            this.myEntities = newEntities;
            this._modelEvents.addEvent(new EOEntityAddedEvent(entity));
            this.firePropertyChange(ENTITIES, oldEntities, this.myEntities);
        } else {
            this.myEntities.add(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(EOEntity _entity) {
        this.myDeletedEntityNames.add(_entity.getName());
        Map<String, EOEntity> map = this._entitiesCache;
        synchronized (map) {
            this._entitiesCache.remove(_entity.getName());
        }
        Set<EOEntity> oldEntities = this.myEntities;
        HashSet<EOEntity> newEntities = new HashSet<EOEntity>();
        newEntities.addAll(this.myEntities);
        newEntities.remove(_entity);
        this.myEntities = newEntities;
        this._modelEvents.addEvent(new EOEntityDeletedEvent(_entity));
        this.firePropertyChange(ENTITIES, oldEntities, this.myEntities);
        _entity._setModel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOEntity getEntityNamed(String name) {
        Map<String, EOEntity> map = this._entitiesCache;
        synchronized (map) {
            return this._entitiesCache.get(name);
        }
    }

    public void _storedProcedureNameChanged(String _oldName, String _newName) {
        this.myDeletedStoredProcedureNames.add(_oldName);
        this.myDeletedStoredProcedureNames.remove(_newName);
    }

    public EOStoredProcedure addBlankStoredProcedure(String _name) throws DuplicateStoredProcedureNameException {
        String newStoredProcedureNameBase = _name;
        String newStoredProcedureName = this.findUnusedStoredProcedureName(newStoredProcedureNameBase);
        EOStoredProcedure storedProcedure = new EOStoredProcedure(newStoredProcedureName);
        this.addStoredProcedure(storedProcedure);
        return storedProcedure;
    }

    public void addStoredProcedure(EOStoredProcedure _storedProcedure) throws DuplicateStoredProcedureNameException {
        this.addStoredProcedure(_storedProcedure, true, null);
    }

    public void addStoredProcedure(EOStoredProcedure _storedProcedure, boolean _fireEvents, Set<EOModelVerificationFailure> _failures) throws DuplicateStoredProcedureNameException {
        _storedProcedure._setModel(this);
        this._checkForDuplicateStoredProcedureName(_storedProcedure, _storedProcedure.getName(), _failures);
        _storedProcedure.pasted();
        this.myDeletedStoredProcedureNames.remove(_storedProcedure.getName());
        if (_fireEvents) {
            Set<EOStoredProcedure> oldStoredProcedures = this.myStoredProcedures;
            HashSet<EOStoredProcedure> newStoredProcedures = new HashSet<EOStoredProcedure>();
            newStoredProcedures.addAll(this.myStoredProcedures);
            newStoredProcedures.add(_storedProcedure);
            this.myStoredProcedures = newStoredProcedures;
            this.firePropertyChange(STORED_PROCEDURES, oldStoredProcedures, this.myStoredProcedures);
        } else {
            this.myStoredProcedures.add(_storedProcedure);
        }
    }

    public void removeStoredProcedure(EOStoredProcedure _storedProcedure) {
        this.myDeletedStoredProcedureNames.add(_storedProcedure.getName());
        Set<EOStoredProcedure> oldStoredProcedures = this.myStoredProcedures;
        HashSet<EOStoredProcedure> newStoredProcedures = new HashSet<EOStoredProcedure>();
        newStoredProcedures.addAll(this.myStoredProcedures);
        newStoredProcedures.remove(_storedProcedure);
        this.myStoredProcedures = newStoredProcedures;
        this.firePropertyChange(STORED_PROCEDURES, oldStoredProcedures, this.myStoredProcedures);
        _storedProcedure._setModel(null);
    }

    public String findUnusedStoredProcedureName(String _newName) {
        return this._findUnusedName(_newName, "getStoredProcedureNamed");
    }

    public Set<EOStoredProcedure> getStoredProcedures() {
        return this.myStoredProcedures;
    }

    public Set<EOStoredProcedure> getSortedStoredProcedures() {
        return new PropertyListSet<EOStoredProcedure>((Collection<EOStoredProcedure>)this.myStoredProcedures);
    }

    public EOStoredProcedure getStoredProcedureNamed(String _name) {
        EOStoredProcedure matchingStoredProcedure = null;
        Iterator<EOStoredProcedure> storedProceduresIter = this.myStoredProcedures.iterator();
        while (matchingStoredProcedure == null && storedProceduresIter.hasNext()) {
            EOStoredProcedure attribute = storedProceduresIter.next();
            if (!ComparisonUtils.equals((Object)attribute.getName(), (Object)_name)) continue;
            matchingStoredProcedure = attribute;
        }
        return matchingStoredProcedure;
    }

    public void _checkForDuplicateStoredProcedureName(EOStoredProcedure _storedProcedure, String _newName, Set<EOModelVerificationFailure> _failures) throws DuplicateStoredProcedureNameException {
        EOStoredProcedure existingStoredProcedure = this.getStoredProcedureNamed(_newName);
        if (existingStoredProcedure != null && existingStoredProcedure != _storedProcedure) {
            if (_failures == null) {
                throw new DuplicateStoredProcedureNameException(_newName, this);
            }
            String unusedName = this.findUnusedStoredProcedureName(_newName);
            existingStoredProcedure.setName(unusedName, true);
            _failures.add(new DuplicateStoredProcedureFailure(this, _newName, unusedName));
        }
    }

    public URL getIndexURL() throws MalformedURLException {
        URL indexURL = null;
        if (this.myModelURL != null) {
            indexURL = new URL(this.myModelURL, "index.eomodeld");
        }
        return indexURL;
    }

    public void checkLastModified(Set<EOLastModified> lastModified) {
        if (this._lastModified != null && this._lastModified.hasBeenModified()) {
            lastModified.add(this._lastModified);
        }
        for (EOEntity entity : this.getEntities()) {
            entity.checkLastModified(lastModified);
        }
        for (EOStoredProcedure storedProc : this.getStoredProcedures()) {
            storedProc.checkLastModified(lastModified);
        }
    }

    public void loadFromURL(URL _modelFolder, Set<EOModelVerificationFailure> _failures) throws EOModelException, MalformedURLException {
        Set deletedEntityNamesInObjectStore;
        Map internalInfoMap;
        Set storedProcedureNames;
        EOModelMap modelMap;
        Map rawModelMap;
        URL indexURL = new URL(_modelFolder, "index.eomodeld");
        this.myModelURL = _modelFolder;
        try {
            rawModelMap = (Map)WOLPropertyListSerialization.propertyListFromURL((URL)indexURL, (ParserDataStructureFactory)new EOModelParserDataStructureFactory());
        }
        catch (Exception e) {
            throw new EOModelException("index.eomodeld is corrupted.", e);
        }
        if (rawModelMap == null) {
            throw new EOModelException("index.eomodeld is corrupted.");
        }
        this.myModelMap = modelMap = new EOModelMap(rawModelMap);
        Object version = modelMap.get("EOModelVersion");
        if (version instanceof String) {
            this.myVersion = (String)version;
        } else if (version instanceof Number) {
            this.myVersion = String.valueOf(((Number)version).floatValue());
        } else {
            throw new IllegalArgumentException("Unknown version format:" + version);
        }
        this.loadUserInfo(modelMap);
        Set entities = modelMap.getSet(ENTITIES);
        if (entities != null) {
            for (Object entitiesMap : entities) {
                EOModelMap entityMap = new EOModelMap((Map)entitiesMap);
                String entityName = entityMap.getString(NAME, true);
                EOEntity entity = new EOEntity();
                URL uRL = new URL(_modelFolder, entityName + ".plist");
                if (URLUtils.exists((URL)uRL)) {
                    entity.loadFromURL(uRL, _failures);
                    URL fspecURL = new URL(_modelFolder, entityName + ".fspec");
                    if (URLUtils.exists((URL)fspecURL)) {
                        entity.loadFetchSpecsFromURL(fspecURL, _failures);
                    }
                    if (entity.getName() == null) {
                        _failures.add(new EOModelVerificationFailure(this, this, "The entity file " + uRL + " defines an entity with no name.", false));
                    }
                    this.addEntity(entity, true, false, _failures);
                    continue;
                }
                _failures.add(new EOModelVerificationFailure(this, this, "The entity file " + uRL + " was missing.", false));
            }
        }
        if ((storedProcedureNames = modelMap.getSet(STORED_PROCEDURES)) != null) {
            for (String storedProcedureName : storedProcedureNames) {
                EOStoredProcedure storedProcedure = new EOStoredProcedure();
                URL storedProcedureURL = new URL(_modelFolder, storedProcedureName + ".storedProcedure");
                if (URLUtils.exists((URL)storedProcedureURL)) {
                    storedProcedure.loadFromURL(storedProcedureURL, _failures);
                    this.addStoredProcedure(storedProcedure, false, _failures);
                    continue;
                }
                _failures.add(new EOModelVerificationFailure(this, this, "The stored procedure file " + (URL)storedProcedureURL + " was missing.", false));
            }
        }
        if ((internalInfoMap = modelMap.getMap("internalInfo")) != null && (deletedEntityNamesInObjectStore = modelMap.getSet("_deletedEntityNamesInObjectStore", true)) != null) {
            this.myDeletedEntityNamesInObjectStore = deletedEntityNamesInObjectStore;
        }
        EOModelMap entityModelerMap = this.getEntityModelerMap(false);
        this._entityNamingConvention = NamingConvention.loadFromMap(ENTITY_NAMING_CONVENTION, entityModelerMap);
        this._attributeNamingConvention = NamingConvention.loadFromMap(ATTRIBUTE_NAMING_CONVENTION, entityModelerMap);
        this._reverseEngineered = entityModelerMap.getBoolean(REVERSE_ENGINEERED, false);
        Map databaseConfigs = entityModelerMap.getMap(DATABASE_CONFIGS);
        if (databaseConfigs != null) {
            for (Map.Entry entry : databaseConfigs.entrySet()) {
                String name = (String)entry.getKey();
                EODatabaseConfig databaseConfig = new EODatabaseConfig(name);
                databaseConfig.loadFromMap(new EOModelMap((Map)entry.getValue()), _failures);
                this.addDatabaseConfig(databaseConfig, false, _failures);
            }
        }
        EODatabaseConfig activeDatabaseConfig = null;
        String string = entityModelerMap.getString("activeDatabaseConfigName", false);
        if (string != null) {
            activeDatabaseConfig = this.getDatabaseConfigNamed(string);
        }
        String adaptorName = modelMap.getString(ADAPTOR_NAME, true);
        Map connectionDictionary = modelMap.getMap("connectionDictionary", true);
        if (connectionDictionary != null && !connectionDictionary.isEmpty()) {
            EODatabaseConfig tempConnectionDictionaryDatabaseConfig = this._createDatabaseConfig(adaptorName, connectionDictionary);
            EODatabaseConfig connectionDictionaryDatabaseConfig = null;
            Iterator<EODatabaseConfig> databaseConfigsIter = this.myDatabaseConfigs.iterator();
            while (connectionDictionaryDatabaseConfig == null && databaseConfigsIter.hasNext()) {
                EODatabaseConfig databaseConfig = databaseConfigsIter.next();
                if (!tempConnectionDictionaryDatabaseConfig.isEquivalent(databaseConfig, false)) continue;
                connectionDictionaryDatabaseConfig = databaseConfig;
            }
            if (connectionDictionaryDatabaseConfig == null && this.canSave()) {
                connectionDictionaryDatabaseConfig = tempConnectionDictionaryDatabaseConfig;
                this.addDatabaseConfig(connectionDictionaryDatabaseConfig, false, _failures);
            }
            if (activeDatabaseConfig != connectionDictionaryDatabaseConfig) {
                activeDatabaseConfig = connectionDictionaryDatabaseConfig;
            }
        }
        if (this.myDatabaseConfigs.isEmpty() && this.canSave() && connectionDictionary != null) {
            if (adaptorName == null) {
                adaptorName = "JDBC";
            }
            this.addDatabaseConfig(this._createDatabaseConfig(adaptorName, null), false, _failures);
        }
        if (activeDatabaseConfig == null && !this.myDatabaseConfigs.isEmpty()) {
            activeDatabaseConfig = this.myDatabaseConfigs.iterator().next();
        }
        if (activeDatabaseConfig != null) {
            if (ComparisonUtils.equals((Object)activeDatabaseConfig.getName(), (Object)string)) {
                this.myActiveDatabaseConfig = activeDatabaseConfig;
            } else {
                this.setActiveDatabaseConfig(activeDatabaseConfig, false);
            }
        }
        this._lastModified = new EOLastModified(indexURL);
    }

    public EOModelMap toMap() {
        EOModelMap modelMap = this.myModelMap.cloneModelMap();
        modelMap.setString("EOModelVersion", this.myVersion, true);
        String adaptorName = "JDBC";
        Map<Object, Object> connectionDictionary = null;
        if (this.myActiveDatabaseConfig != null) {
            connectionDictionary = this.myActiveDatabaseConfig.getConnectionDictionary();
            adaptorName = this.myActiveDatabaseConfig.getAdaptorName();
        }
        modelMap.put("connectionDictionary", connectionDictionary);
        modelMap.setString(ADAPTOR_NAME, adaptorName, true);
        PropertyListSet entities = new PropertyListSet(EOModelMap.asArray(this.myModelMap.get(ENTITIES)));
        PropertyListSet entitiesWithSharedObjects = new PropertyListSet(EOModelMap.asArray(this.myModelMap.get("entitiesWithSharedObjects")));
        for (EOEntity entity : this.myEntities) {
            EOModelMap entityMap = new EOModelMap();
            entityMap.setString("className", entity.getClassName(), true);
            EOEntity parent = entity.getParent();
            String parentName = parent == null ? null : parent.getName();
            entityMap.setString("parent", parentName, true);
            entityMap.setString(NAME, entity.getName(), true);
            entities.add(entityMap);
            if (!entity.hasSharedObjects()) continue;
            entitiesWithSharedObjects.add(entity.getName());
        }
        modelMap.setSet(ENTITIES, entities, true);
        modelMap.setSet("entitiesWithSharedObjects", entitiesWithSharedObjects, true);
        HashMap<String, Set<String>> internalInfoMap = modelMap.getMap("internalInfo");
        if (internalInfoMap == null) {
            internalInfoMap = new HashMap<String, Set<String>>();
        }
        if (this.myDeletedEntityNamesInObjectStore != null && !this.myDeletedEntityNamesInObjectStore.isEmpty()) {
            internalInfoMap.put("_deletedEntityNamesInObjectStore", this.myDeletedEntityNamesInObjectStore);
        } else {
            internalInfoMap.remove("_deletedEntityNamesInObjectStore");
        }
        modelMap.setMap("internalInfo", internalInfoMap, true);
        PropertyListSet storedProcedures = new PropertyListSet(EOModelMap.asArray(this.myModelMap.get(STORED_PROCEDURES)));
        for (EOStoredProcedure storedProcedure : this.myStoredProcedures) {
            storedProcedures.add(storedProcedure.getName());
        }
        modelMap.setSet(STORED_PROCEDURES, storedProcedures, true);
        EOModelMap entityModelerMap = this.getEntityModelerMap(true);
        boolean canConvertDatabaseConfigsToSingleConnectionDictionary = this.canConvertDatabaseConfigsToSingleConnectionDictionary();
        if (canConvertDatabaseConfigsToSingleConnectionDictionary) {
            entityModelerMap.remove(DATABASE_CONFIGS);
            entityModelerMap.remove("activeDatabaseConfigName");
        } else {
            PropertyListMap databaseConfigs = new PropertyListMap();
            for (EODatabaseConfig databaseConfig : this.myDatabaseConfigs) {
                databaseConfigs.put(databaseConfig.getName(), databaseConfig.toMap());
            }
            entityModelerMap.setMap(DATABASE_CONFIGS, databaseConfigs, true);
            if (this.myActiveDatabaseConfig == null || databaseConfigs.get(this.myActiveDatabaseConfig.getName()) == null) {
                entityModelerMap.remove("activeDatabaseConfigName");
            } else {
                entityModelerMap.put("activeDatabaseConfigName", this.myActiveDatabaseConfig.getName());
            }
        }
        NamingConvention.toMap(this._entityNamingConvention, ENTITY_NAMING_CONVENTION, entityModelerMap);
        NamingConvention.toMap(this._attributeNamingConvention, ATTRIBUTE_NAMING_CONVENTION, entityModelerMap);
        entityModelerMap.setBoolean(REVERSE_ENGINEERED, this._reverseEngineered, 3);
        this.writeUserInfo(modelMap);
        return modelMap;
    }

    public File _eomodeldFolderForFolder(File folder) {
        File modelFolder = folder.getName().endsWith(".eomodeld") ? folder : new File(folder, this.myName + ".eomodeld");
        return modelFolder;
    }

    public boolean canSave() throws MalformedURLException {
        boolean canSave;
        URL indexURL = this.getIndexURL();
        if (indexURL == null || indexURL.toExternalForm().startsWith("jar:")) {
            canSave = false;
        } else {
            File indexFile = URLUtils.cheatAndTurnIntoFile((URL)indexURL);
            File modelFolder = indexFile.getParentFile();
            canSave = this.canSaveToFolder(modelFolder);
        }
        return canSave;
    }

    public boolean canSaveToFolder(File parentFolder) {
        File modelFolder = this._eomodeldFolderForFolder(parentFolder);
        boolean canSave = modelFolder.exists() ? (modelFolder.isFile() ? false : modelFolder.canWrite()) : modelFolder.getParentFile().canWrite();
        return canSave;
    }

    public File save() throws IOException, PropertyListParserException {
        URL indexURL = this.getIndexURL();
        if (indexURL == null) {
            throw new IOException("This model has no index file URL.");
        }
        File indexFile = URLUtils.cheatAndTurnIntoFile((URL)indexURL);
        File modelFolder = indexFile.getParentFile();
        return this.saveToFolder(modelFolder.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveToFolder(File parentFolder) throws IOException, PropertyListParserException {
        this.firePropertyChange(MODEL_SAVING, Boolean.FALSE, Boolean.TRUE);
        try {
            File modelFolder = this._eomodeldFolderForFolder(parentFolder);
            if (!modelFolder.exists() && !modelFolder.mkdirs()) {
                throw new IOException("Failed to create folder '" + modelFolder + "'.");
            }
            this.myModelURL = modelFolder.toURL();
            File indexFile = new File(modelFolder, "index.eomodeld");
            EOModelMap modelMap = this.toMap();
            WOLPropertyListSerialization.propertyListToFile((String)"Entity Modeler v1.0.1", (File)indexFile, (Object)modelMap);
            if (this.myDeletedEntityNames != null) {
                for (String entityName : this.myDeletedEntityNames) {
                    File fspecFile;
                    if (this.getEntityNamed(entityName) != null) continue;
                    File entityFile = new File(modelFolder, entityName + ".plist");
                    if (entityFile.exists()) {
                        entityFile.delete();
                    }
                    if (!(fspecFile = new File(modelFolder, entityName + ".fspec")).exists()) continue;
                    fspecFile.delete();
                }
            }
            for (EOEntity entity : this.myEntities) {
                if (!entity.isEntityDirty()) continue;
                String entityName = entity.getName();
                File entityFile = new File(modelFolder, entityName + ".plist");
                File fspecFile = new File(modelFolder, entityName + ".fspec");
                entity.saveToFile(entityFile, fspecFile);
            }
            if (this.myDeletedStoredProcedureNames != null) {
                for (String storedProcedureName : this.myDeletedStoredProcedureNames) {
                    File storedProcedureFile;
                    if (this.getStoredProcedureNamed(storedProcedureName) != null || !(storedProcedureFile = new File(modelFolder, storedProcedureName + ".storedProcedure")).exists()) continue;
                    storedProcedureFile.delete();
                }
            }
            for (EOStoredProcedure storedProcedure : this.myStoredProcedures) {
                if (!storedProcedure.isStoredProcedureDirty()) continue;
                String storedProcedureName = storedProcedure.getName();
                File storedProcedureFile = new File(modelFolder, storedProcedureName + ".storedProcedure");
                storedProcedure.saveToFile(storedProcedureFile);
            }
            this.setDirty(false);
            this._lastModified = new EOLastModified(indexFile);
            File file = modelFolder;
            return file;
        }
        finally {
            this.firePropertyChange(MODEL_SAVING, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
        for (EOEntity entity : this.myEntities) {
            entity.resolve(_failures);
        }
    }

    public void resolveFlattened(Set<EOModelVerificationFailure> _failures) {
        for (EOEntity entity : this.myEntities) {
            entity.resolveFlattened(_failures);
        }
    }

    public void verify(Set<EOModelVerificationFailure> _failures) {
        EOModelGroup modelGroup = this.getModelGroup();
        VerificationContext verificationContext = modelGroup == null ? new VerificationContext(this) : new VerificationContext(modelGroup);
        this.verify(_failures, verificationContext);
    }

    public void verify(Set<EOModelVerificationFailure> _failures, VerificationContext verificationContext) {
        for (EOEntity entity : this.myEntities) {
            entity.verify(_failures, verificationContext);
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return this.myName == null ? "Unknown Model '" + this.getModelURL() + "'" : this.myName;
    }

    public EOModel _cloneModelObject() {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Class<EOModelGroup> _getModelParentType() {
        return EOModelGroup.class;
    }

    @Override
    public EOModelGroup _getModelParent() {
        return this.getModelGroup();
    }

    @Override
    public void _addToModelParent(EOModelGroup modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) throws EOModelException {
        if (findUniqueName) {
            throw new IllegalArgumentException("Unable to unique model names.");
        }
        modelParent.addModel(this, failures);
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
        this.getModelGroup().removeModel(this, failures);
    }

    public ModelEvents getModelEvents() {
        return this._modelEvents;
    }

    public String toString() {
        return "[EOModel: name = " + this.myName + "; entities = " + this.myEntities + "]";
    }

    public synchronized void clearCachedPrototypes(Set<EOModelVerificationFailure> _failures, boolean _reload) {
        this.myPrototypeAttributeCache = null;
        for (EOEntity entity : this.myEntities) {
            entity.clearCachedPrototypes(_failures, _reload);
        }
    }

    public synchronized Set<String> getPrototypeAttributeNames() {
        PropertyListSet<String> prototypeAttributeNames = new PropertyListSet<String>();
        for (EOAttribute attribute : this.getPrototypeAttributes()) {
            prototypeAttributeNames.add(attribute.getName());
        }
        return prototypeAttributeNames;
    }

    public String _getDefaultPrototypeEntityName(String prefix, String name) {
        return "EO" + (prefix != null ? prefix : "") + (name != null ? name : "") + "Prototypes";
    }

    public String getAdaptorName() {
        String adaptorName = "JDBC";
        if (this.myActiveDatabaseConfig != null) {
            adaptorName = this.myActiveDatabaseConfig.getAdaptorName();
        }
        return adaptorName;
    }

    public String _getAdaptorPrototypeEntityName(String prefix, String adaptorName, String name) {
        String adaptorPrototypeEntityName = null;
        if (adaptorName != null) {
            adaptorPrototypeEntityName = "EO" + adaptorName + (prefix != null ? prefix : "") + (name != null ? name : "") + "Prototypes";
        }
        return adaptorPrototypeEntityName;
    }

    public String _getDriverPrototypeEntityName(String prefix, Map _connectionDictionary, String name) {
        String driverPrototypeEntityName = null;
        String adaptorName = this.getAdaptorName();
        if ("JDBC".equals(adaptorName) && _connectionDictionary != null) {
            String jdbcUrl;
            String pluginName = (String)_connectionDictionary.get("plugin");
            if ((pluginName == null || pluginName.length() == 0) && (jdbcUrl = (String)_connectionDictionary.get("URL")) != null && jdbcUrl.length() > 0) {
                int firstColon = jdbcUrl.indexOf(58);
                int secondColon = jdbcUrl.indexOf(58, firstColon + 1);
                if (firstColon != -1 && secondColon != -1) {
                    pluginName = jdbcUrl.substring(firstColon + 1, secondColon);
                }
            }
            if (pluginName != null) {
                driverPrototypeEntityName = "EOJDBC" + pluginName + (prefix != null ? prefix : "") + (name != null ? name : "") + "Prototypes";
            }
        }
        return driverPrototypeEntityName;
    }

    public EOEntity _getPreferredPrototypeEntity(String adaptorName, Map connectionDictionary) {
        EOEntity preferredPrototypEntity = this._getPreferredPrototypeEntity("Custom", adaptorName, null, connectionDictionary);
        if (preferredPrototypEntity == null && (preferredPrototypEntity = this._getPreferredPrototypeEntity(null, adaptorName, this.getName(), connectionDictionary)) == null) {
            preferredPrototypEntity = this._getPreferredPrototypeEntity(null, adaptorName, null, connectionDictionary);
        }
        return preferredPrototypEntity;
    }

    public EOEntity _getPreferredPrototypeEntity(String prefix, String adaptorName, String modelName, Map connectionDictionary) {
        String adaptorPrototypeEntityName;
        EOEntity prototypeEntity = null;
        String driverPrototypeEntityName = this._getDriverPrototypeEntityName(prefix, connectionDictionary, modelName);
        if (driverPrototypeEntityName != null && this.myModelGroup != null) {
            prototypeEntity = this.myModelGroup.getEntityNamed(driverPrototypeEntityName);
        }
        if (prototypeEntity == null && (adaptorPrototypeEntityName = this._getAdaptorPrototypeEntityName(prefix, adaptorName, modelName)) != null && this.myModelGroup != null) {
            prototypeEntity = this.myModelGroup.getEntityNamed(adaptorPrototypeEntityName);
        }
        if (prototypeEntity == null && this.myModelGroup != null) {
            String defaultPrototypeEntityName = this._getDefaultPrototypeEntityName(prefix, modelName);
            prototypeEntity = this.myModelGroup.getEntityNamed(defaultPrototypeEntityName);
        }
        return prototypeEntity;
    }

    public synchronized Set<EOAttribute> getPrototypeAttributes() {
        if (this.myPrototypeAttributeCache == null) {
            EOEntity prototypeEntity;
            HashMap<String, EOAttribute> prototypeAttributeCache = new HashMap<String, EOAttribute>();
            Map<Object, Object> connectionDictionary = null;
            EODatabaseConfig activeDatabaseConfig = this.getActiveDatabaseConfig();
            if (activeDatabaseConfig != null) {
                connectionDictionary = activeDatabaseConfig.getConnectionDictionary();
            }
            this.addPrototypeAttributes(this._getDefaultPrototypeEntityName(null, null), prototypeAttributeCache);
            this.addPrototypeAttributes(this._getAdaptorPrototypeEntityName(null, this.getAdaptorName(), null), prototypeAttributeCache);
            this.addPrototypeAttributes(this._getDriverPrototypeEntityName(null, connectionDictionary, null), prototypeAttributeCache);
            this.addPrototypeAttributes(this._getDefaultPrototypeEntityName("Custom", null), prototypeAttributeCache);
            this.addPrototypeAttributes(this._getAdaptorPrototypeEntityName("Custom", this.getAdaptorName(), null), prototypeAttributeCache);
            this.addPrototypeAttributes(this._getDriverPrototypeEntityName("Custom", connectionDictionary, null), prototypeAttributeCache);
            this.addPrototypeAttributes(this._getDefaultPrototypeEntityName(null, this.getName()), prototypeAttributeCache);
            this.addPrototypeAttributes(this._getAdaptorPrototypeEntityName(null, this.getAdaptorName(), this.getName()), prototypeAttributeCache);
            this.addPrototypeAttributes(this._getDriverPrototypeEntityName(null, connectionDictionary, this.getName()), prototypeAttributeCache);
            if (activeDatabaseConfig != null && (prototypeEntity = activeDatabaseConfig.getPrototype()) != null) {
                this.addPrototypeAttributes(prototypeEntity.getName(), prototypeAttributeCache);
            }
            this.myPrototypeAttributeCache = new HashSet<EOAttribute>();
            this.myPrototypeAttributeCache.addAll(prototypeAttributeCache.values());
        }
        return this.myPrototypeAttributeCache;
    }

    protected void addPrototypeAttributes(String _prototypeEntityName, Map<String, EOAttribute> _prototypeAttributeCache) {
        EOEntity prototypeEntity;
        if (_prototypeEntityName != null && (prototypeEntity = this.myModelGroup.getEntityNamed(_prototypeEntityName)) != null) {
            for (EOAttribute prototypeAttribute : prototypeEntity.getAttributes()) {
                _prototypeAttributeCache.put(prototypeAttribute.getName(), prototypeAttribute);
            }
        }
    }

    public EOAttribute getPrototypeAttributeNamed(String _name) {
        EOAttribute matchingAttribute = null;
        Set<EOAttribute> prototypeAttributes = this.getPrototypeAttributes();
        Iterator<EOAttribute> attributesIter = prototypeAttributes.iterator();
        while (matchingAttribute == null && attributesIter.hasNext()) {
            EOAttribute attribute = attributesIter.next();
            if (!attribute.getName().equals(_name)) continue;
            matchingAttribute = attribute;
        }
        return matchingAttribute;
    }
}

