/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.doc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.log.NullLogSystem;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;

public class EOModelDocGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(EOModelGroup modelGroup, File outputFolder, File templatePath, String entityURLTemplate) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(modelGroup.getClass().getClassLoader());
        try {
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.setProperty("runtime.log.logsystem.class", (Object)NullLogSystem.class.getName());
            StringBuffer templatePaths = new StringBuffer();
            templatePaths.append(".");
            if (templatePath != null) {
                templatePaths.append(",");
                templatePaths.append(templatePath.getAbsolutePath());
            }
            velocityEngine.setProperty("resource.loader", (Object)"file,class");
            velocityEngine.setProperty("file.resource.loader.class", (Object)FileResourceLoader.class.getName());
            velocityEngine.setProperty("file.resource.loader.path", (Object)templatePaths.toString());
            velocityEngine.setProperty("class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            velocityEngine.init();
            VelocityContext context = new VelocityContext();
            context.put("modelGroup", (Object)modelGroup);
            EOModelDocGenerator.writeTemplate(velocityEngine, context, "eomodeldoc.css.vm", new File(outputFolder, "eomodeldoc.css"));
            EOModelDocGenerator.writeTemplate(velocityEngine, context, "eomodeldoc.js.vm", new File(outputFolder, "eomodeldoc.js"));
            EOModelDocGenerator.writeTemplate(velocityEngine, context, "prototype.js.vm", new File(outputFolder, "prototype.js"));
            EOModelDocGenerator.writeTemplate(velocityEngine, context, "index.html.vm", new File(outputFolder, "index.html"));
            EOModelDocGenerator.writeTemplate(velocityEngine, context, "indexContent.html.vm", new File(outputFolder, "content.html"));
            EOModelDocGenerator.writeTemplate(velocityEngine, context, "indexOverview.html.vm", new File(outputFolder, "overview.html"));
            EOModelDocGenerator.writeTemplate(velocityEngine, context, "indexModels.html.vm", new File(outputFolder, "models.html"));
            for (EOModel model : modelGroup.getModels()) {
                System.out.println("Generating " + model.getName() + " ...");
                context.put("model", (Object)model);
                EOModelDocGenerator.writeTemplate(velocityEngine, context, "modelOverview.html.vm", new File(outputFolder, model.getName() + "/overview.html"));
                EOModelDocGenerator.writeTemplate(velocityEngine, context, "modelContent.html.vm", new File(outputFolder, model.getName() + "/content.html"));
                for (EOEntity entity : model.getEntities()) {
                    String className;
                    System.out.println("Generating " + model.getName() + "." + entity.getName() + " ...");
                    context.put("entity", (Object)entity);
                    if (entityURLTemplate != null && (className = entity.getClassName()) != null && className.length() > 0) {
                        StringWriter entityURLWriter = new StringWriter();
                        VelocityContext entityURLContext = new VelocityContext();
                        entityURLContext.put("entity", (Object)entity);
                        entityURLContext.put("model", (Object)model);
                        Velocity.evaluate((Context)entityURLContext, (Writer)entityURLWriter, (String)"entityURL", (String)entityURLTemplate);
                        context.put("entityURL", (Object)entityURLWriter.toString());
                    }
                    EOModelDocGenerator.writeTemplate(velocityEngine, context, "entityContent.html.vm", new File(outputFolder, model.getName() + "/entities/" + entity.getName() + ".html"));
                }
                for (EOStoredProcedure storedProcedure : model.getStoredProcedures()) {
                    System.out.println("Generating " + model.getName() + "." + storedProcedure.getName() + " ...");
                    context.put("storedProcedure", (Object)storedProcedure);
                    EOModelDocGenerator.writeTemplate(velocityEngine, context, "storedProcedureContent.html.vm", new File(outputFolder, model.getName() + "/storedProcedures/" + storedProcedure.getName() + ".html"));
                }
            }
        }
        finally {
            thread.setContextClassLoader(loader);
        }
        System.out.println("Done: " + new File(outputFolder, "index.html"));
    }

    public static void main(String[] args) throws Exception {
        EOModelGroup modelGroup = new EOModelGroup();
        modelGroup.loadModelFromURL(new File("/Users/mschrag/Documents/workspace/ERPrototypes/Resources/erprototypes.eomodeld").toURL());
        modelGroup.loadModelFromURL(new File("/Users/mschrag/Documents/workspace/MDTAccounting/MDTAccounting.eomodeld").toURL());
        modelGroup.loadModelFromURL(new File("/Users/mschrag/Documents/workspace/MDTask/MDTask.eomodeld").toURL());
        modelGroup.resolve(new HashSet<EOModelVerificationFailure>());
        File outputFolder = new File("/tmp/eomodeldoc");
        EOModelDocGenerator.generate(modelGroup, outputFolder, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTemplate(VelocityEngine engine, VelocityContext context, String templateName, File outputFile) throws Exception {
        try {
            Template template = engine.getTemplate(templateName, "UTF-8");
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                throw new IOException("Unable to create the folder " + outputFile.getParentFile() + ".");
            }
            try (BufferedWriter outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));){
                template.merge((Context)context, (Writer)outputWriter);
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to generate '" + outputFile + "' with template '" + templateName + "'.", e);
        }
    }

    public static class ConsoleLogger
    implements LogSystem {
        public void init(RuntimeServices runtimeservices) throws Exception {
        }

        public void logVelocityMessage(int i, String s) {
            System.out.println("ConsoleLogger.logVelocityMessage: " + i + ", " + s);
        }
    }
}

