/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.apieditor.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.apieditor.ApieditorPlugin;
import org.objectstyle.wolips.apieditor.editor.ApiFormPage;
import org.objectstyle.wolips.apieditor.editor.BindingsPage;
import org.objectstyle.wolips.apieditor.editor.CreatePage;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.ApiModelException;

public class ApiEditor
extends FormEditor {
    private ApiModel model;

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(ApieditorPlugin.getDefault().getFormColors(display));
    }

    protected void addPages() {
        block6: {
            try {
                try {
                    if (this.getModel() == null) {
                        this.addPage((IFormPage)new CreatePage(this, "Create"));
                        break block6;
                    }
                    this.addPage((IFormPage)new BindingsPage(this, "Bindings"));
                }
                catch (ApiModelException e) {
                    ApieditorPlugin.getDefault().debug(e);
                    this.addPage((IFormPage)new CreatePage(this, "Create"));
                }
            }
            catch (PartInitException e) {
                ApieditorPlugin.getDefault().debug(e);
            }
        }
        CTabFolder ctf = (CTabFolder)this.getContainer();
        ctf.setTabPosition(128);
        ctf.setBorderVisible(false);
        if (this.getPageCount() <= 1) {
            ctf.setTabHeight(0);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.getModel().saveChanges();
            this.editorDirtyStateChanged();
            IFile file = this.getModel().getEclipseFile();
            if (file != null && file.exists()) {
                file.refreshLocal(2, null);
            } else {
                String location = this.getModel().getLocation();
                if (location != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(location))) != null) {
                    file.refreshLocal(2, null);
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to save .api file.", t);
        }
        for (Object formPage : this.pages) {
            if (formPage == null || !(formPage instanceof ApiFormPage)) continue;
            ((ApiFormPage)((Object)formPage)).reloadModel();
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("doSaveAs");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.getSite().getSelectionProvider().setSelection(new ISelection(){

            public boolean isEmpty() {
                return true;
            }
        });
    }

    public ApiModel getModel() throws ApiModelException {
        IFile apiFile;
        FileEditorInput editorInput;
        if (this.model == null && (editorInput = (FileEditorInput)this.getEditorInput()) != null && (apiFile = editorInput.getFile()) != null && apiFile.exists()) {
            this.model = new ApiModel(((FileEditorInput)this.getEditorInput()).getFile().getLocation().toFile());
        }
        return this.model;
    }

    public void dropModel() {
        this.model = null;
    }

    public void activateFirstPage() {
        this.setActivePage(0);
    }
}

