/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.apieditor.editor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.objectstyle.wolips.apieditor.editor.ApiEditor;
import org.objectstyle.wolips.apieditor.editor.BindingDetailsPage;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.bindings.api.ApiModelException;
import org.objectstyle.wolips.bindings.api.Binding;

public class BindingsPageBlock
extends MasterDetailsBlock
implements Binding.BindingChangedListener {
    FormPage page;
    TableViewer viewer;

    public BindingsPageBlock(FormPage page) {
        this.page = page;
    }

    public void reload() {
        this.viewer.setInput((Object)this.page.getEditor().getEditorInput());
    }

    public void createContent(final IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Section apiSection = toolkit.createSection(form.getBody(), 256);
        apiSection.setText("Component API");
        apiSection.marginWidth = 10;
        apiSection.marginHeight = 10;
        Composite apiClient = toolkit.createComposite((Composite)apiSection, 64);
        GridLayout apiClientLayout = new GridLayout();
        apiClientLayout.numColumns = 1;
        apiClientLayout.marginWidth = 2;
        apiClientLayout.marginHeight = 0;
        apiClientLayout.marginBottom = 10;
        apiClient.setLayout((Layout)apiClientLayout);
        Button componentContentButton = toolkit.createButton(apiClient, "Component Content", 32);
        ApiEditor apiEditor = (ApiEditor)this.page.getEditor();
        try {
            componentContentButton.setSelection(apiEditor.getModel().getWo().isComponentContent());
        }
        catch (ApiModelException e) {
            throw new RuntimeException("Failed to open .api file.", e);
        }
        componentContentButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                try {
                    ApiEditor apiEditor = (ApiEditor)BindingsPageBlock.this.page.getEditor();
                    apiEditor.getModel().getWo().setComponentContent(button.getSelection());
                    managedForm.dirtyStateChanged();
                }
                catch (ApiModelException e) {
                    throw new RuntimeException("Failed to open .api file.", e);
                }
            }
        });
        toolkit.paintBordersFor(apiClient);
        apiSection.setClient((Control)apiClient);
        super.createContent(managedForm);
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section bindingsSection = toolkit.createSection(parent, 256);
        bindingsSection.setText("Bindings");
        bindingsSection.setDescription("The list contains bindings from the component whose details are editable on the right");
        bindingsSection.marginWidth = 10;
        bindingsSection.marginHeight = 5;
        Composite bindingsClient = toolkit.createComposite((Composite)bindingsSection, 64);
        GridLayout bindingsClientLayout = new GridLayout();
        bindingsClientLayout.numColumns = 2;
        bindingsClientLayout.marginWidth = 2;
        bindingsClientLayout.marginHeight = 2;
        bindingsClient.setLayout((Layout)bindingsClientLayout);
        Table bindingsTable = toolkit.createTable(bindingsClient, 65536);
        GridData bindingTableData = new GridData(1808);
        bindingTableData.heightHint = 20;
        bindingTableData.widthHint = 100;
        bindingsTable.setLayoutData((Object)bindingTableData);
        toolkit.paintBordersFor(bindingsClient);
        Composite buttonsGroup = new Composite(bindingsClient, 0);
        GridData buttonsLayoutData = new GridData(2);
        buttonsGroup.setLayoutData((Object)buttonsLayoutData);
        buttonsGroup.setBackground(bindingsClient.getBackground());
        RowLayout buttonsLayout = new RowLayout(512);
        buttonsLayout.fill = true;
        buttonsLayout.justify = true;
        buttonsLayout.marginTop = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsGroup.setLayout((Layout)buttonsLayout);
        Button addButton = toolkit.createButton(buttonsGroup, "Add", 8);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ApiEditor apiEditor = (ApiEditor)BindingsPageBlock.this.page.getEditor();
                    String newBindingName = StringUtils.findUnusedName((String)"newBinding", (Object)apiEditor.getModel().getWo(), (String)"getBinding");
                    Binding newBinding = apiEditor.getModel().getWo().createBinding(newBindingName);
                    BindingsPageBlock.this.viewer.refresh();
                    BindingsPageBlock.this.viewer.editElement((Object)newBinding, 0);
                    managedForm.dirtyStateChanged();
                }
                catch (Throwable tx) {
                    throw new RuntimeException("Failed to open .api file.", tx);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = toolkit.createButton(buttonsGroup, "Remove", 8);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)BindingsPageBlock.this.viewer.getSelection();
                    if (!selection.isEmpty()) {
                        Iterator iterator = selection.iterator();
                        ApiEditor apiEditor = (ApiEditor)BindingsPageBlock.this.page.getEditor();
                        while (iterator.hasNext()) {
                            Binding binding = (Binding)iterator.next();
                            apiEditor.getModel().getWo().removeBinding(binding);
                            BindingsPageBlock.this.viewer.remove((Object)binding);
                        }
                        managedForm.dirtyStateChanged();
                    }
                }
                catch (Throwable tx) {
                    throw new RuntimeException("Failed to open .api file.", tx);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        bindingsSection.setClient((Control)bindingsClient);
        final SectionPart spart = new SectionPart(bindingsSection){

            public boolean isDirty() {
                try {
                    return ((ApiEditor)BindingsPageBlock.this.page.getEditor()).getModel().isDirty();
                }
                catch (ApiModelException e) {
                    return false;
                }
            }
        };
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TableViewer(bindingsTable);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new MasterContentProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MasterLabelProvider(){

            @Override
            public String getColumnText(Object obj, int index) {
                if (obj instanceof Binding) {
                    Binding binding = (Binding)obj;
                    return binding.getName();
                }
                return super.getColumnText(obj, index);
            }
        });
        this.viewer.setInput((Object)this.page.getEditor().getEditorInput());
    }

    public SashForm getParentSashForm() {
        return this.sashForm;
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    protected void registerPages(DetailsPart details) {
        details.registerPage(Binding.class, (IDetailsPage)new BindingDetailsPage());
    }

    public void bindingChanged(Binding binding) {
        this.viewer.update((Object)binding, null);
    }

    class MasterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        MasterLabelProvider() {
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public void dispose() {
            super.dispose();
        }

        public Font getFont(Object element, int columnIndex) {
            Binding binding;
            Font font = null;
            if (element instanceof Binding && (binding = (Binding)element).isRequired()) {
                font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return font;
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class MasterContentProvider
    implements IStructuredContentProvider {
        MasterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (inputElement instanceof IEditorInput) {
                    ApiEditor apiEditor = (ApiEditor)BindingsPageBlock.this.page.getEditor();
                    List bindings = apiEditor.getModel().getWODefinitions().getWo().getBindings();
                    for (Binding binding : bindings) {
                        binding.setBindingChangedListener((Binding.BindingChangedListener)BindingsPageBlock.this);
                    }
                    return bindings.toArray();
                }
                return new Object[0];
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to open .api file.", t);
            }
        }

        public void dispose() {
            try {
                ApiEditor apiEditor = (ApiEditor)BindingsPageBlock.this.page.getEditor();
                List bindings = apiEditor.getModel().getWODefinitions().getWo().getBindings();
                for (Binding binding : bindings) {
                    binding.setBindingChangedListener(null);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to dispose api file.", t);
            }
        }

        public void inputChanged(Viewer inViewer, Object oldInput, Object newInput) {
        }
    }
}

