/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.document;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.objectstyle.wolips.baseforuiplugins.utils.WorkbenchUtilities;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;

public class WodElementTypeHyperlink
implements IHyperlink {
    private IJavaProject _javaProject;
    private TypeCache _cache;
    private IRegion _region;
    private String _elementType;

    public WodElementTypeHyperlink(IRegion region, String elementType, IJavaProject javaProject, TypeCache cache) {
        this._region = region;
        this._elementType = elementType;
        this._javaProject = javaProject;
        this._cache = cache;
    }

    public IRegion getHyperlinkRegion() {
        return this._region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }

    public void open() {
        try {
            IJavaElement element;
            IType type = BindingReflectionUtils.findElementType((IJavaProject)this._javaProject, (String)this._elementType, (boolean)false, (TypeCache)this._cache);
            if (type != null && (element = type.getPrimaryElement()) != null) {
                IFile wodFile;
                JavaUI.revealInEditor((IEditorPart)JavaUI.openInEditor((IJavaElement)element), (IJavaElement)element);
                LocalizedComponentsLocateResult componentsLocateResults = LocatePlugin.getDefault().getLocalizedComponentsLocateResult(element.getResource());
                if (componentsLocateResults != null && (wodFile = componentsLocateResults.getFirstWodFile()) != null) {
                    WorkbenchUtilities.open((IFile)wodFile, (String)"org.objectstyle.wolips.componenteditor.ComponentEditor");
                }
            }
        }
        catch (Exception ex) {
            Activator.getDefault().log(ex);
        }
    }

    public static WodElementTypeHyperlink toElementTypeHyperlink(IWodElement wodElement, WodParserCache cache) {
        WodElementTypeHyperlink hyperlink = null;
        Position typePosition = wodElement.getElementTypePosition();
        if (typePosition != null) {
            Region elementRegion = new Region(typePosition.getOffset(), typePosition.getLength());
            hyperlink = new WodElementTypeHyperlink((IRegion)elementRegion, wodElement.getElementType(), cache.getJavaProject(), WodParserCache.getTypeCache());
        }
        return hyperlink;
    }
}

