/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.parser;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.OperatorRule;

public class RulePosition {
    private IDocument myDocument;
    private IRule myRule;
    private int myTokenOffset;
    private int myTokenLength;

    public RulePosition(IDocument _document, IRule _rule, int _tokenOffset, int _tokenLength) {
        this.myDocument = _document;
        this.myRule = _rule;
        this.myTokenOffset = _tokenOffset;
        this.myTokenLength = _tokenLength;
    }

    public IDocument getDocument() {
        return this.myDocument;
    }

    public void setRule(IRule rule) {
        this.myRule = rule;
    }

    public IRule getRule() {
        return this.myRule;
    }

    public int getTokenLength() {
        return this.myTokenLength;
    }

    public int getTokenOffset() {
        return this.myTokenOffset;
    }

    public int getTokenEndOffset() {
        return this.myTokenOffset + this.myTokenLength;
    }

    public Position getPosition() {
        return new Position(this.myTokenOffset, this.myTokenLength);
    }

    public String getText() throws BadLocationException {
        String text = this.myDocument.get(this.myTokenOffset, this.myTokenLength);
        return text;
    }

    public String _getTextWithoutException() {
        String text;
        try {
            text = this.getText();
        }
        catch (Throwable e) {
            e.printStackTrace();
            text = "<<failed>>";
        }
        return text;
    }

    public boolean isRuleOfType(Class<? extends IRule> _ruleType) {
        return this.myRule != null && _ruleType.isAssignableFrom(this.myRule.getClass());
    }

    public boolean containsIndex(int _index) {
        return this.myTokenOffset <= _index && this.myTokenOffset + this.myTokenLength >= _index;
    }

    public String toString() {
        return "[RulePosition: rule = " + this.myRule + "; tokenOffset = " + this.myTokenOffset + "; tokenLength = " + this.myTokenLength + "; text = " + this._getTextWithoutException() + "]";
    }

    public static boolean isRulePositionOfType(RulePosition _rulePosition, Class<? extends IRule> _ruleType) {
        return _rulePosition != null && _rulePosition.isRuleOfType(_ruleType);
    }

    public static boolean isOperatorOfType(RulePosition _rulePosition, Class<? extends IWordDetector> _wordDetectorType) {
        return _rulePosition != null && _rulePosition.getRule() instanceof OperatorRule && ((OperatorRule)_rulePosition.getRule()).isWordDetectorOfType(_wordDetectorType);
    }
}

