/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.SimpleWodBinding;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.ChangeBindingNameRefactoring;
import org.objectstyle.wolips.wodclipse.core.refactoring.ChangeBindingValueRefactoring;
import org.objectstyle.wolips.wodclipse.core.refactoring.RefactoringWodElement;

public class RefactoringWodBinding {
    public static final String BINDING_NAME = "bindingName";
    public static final String BINDING_VALUE = "bindingValue";
    private PropertyChangeSupport _propertyChange;
    private IWodElement _wodElement;
    private SimpleWodBinding _wodBinding;
    private WodParserCache _cache;

    public RefactoringWodBinding(IWodElement element, IWodBinding binding, WodParserCache cache) {
        this._cache = cache;
        this._wodElement = element;
        this._wodBinding = new SimpleWodBinding(binding);
        this._propertyChange = new PropertyChangeSupport(this);
    }

    public SimpleWodBinding getWodBinding() {
        return this._wodBinding;
    }

    public void setValue(String value) throws CoreException, InvocationTargetException, InterruptedException {
        String oldValue = this._wodBinding.getValue();
        String newValue = this._changeValue(oldValue, value);
        this._propertyChange.firePropertyChange(BINDING_VALUE, oldValue, newValue);
    }

    public String _setValue(String value) throws CoreException, InvocationTargetException, InterruptedException {
        return this._changeValue(null, value);
    }

    public static String toBindingValue(boolean inline, String inlineBindingPrefix, String inlineBindingSuffix, String value) {
        Object newValue = value;
        if (((String)(newValue = ((String)newValue).trim())).startsWith("\"") && !((String)newValue).endsWith("\"")) {
            newValue = (String)newValue + "\"";
        }
        if (!((String)newValue).startsWith("\"") && ((String)newValue).indexOf(124) == -1 && ((String)newValue).matches(".*[ %].*")) {
            newValue = "\"" + (String)newValue + "\"";
        }
        if (inline) {
            if (((String)newValue).startsWith("\"")) {
                newValue = ((String)newValue).substring(1, ((String)newValue).length() - 1);
            } else if (!((String)newValue).startsWith(inlineBindingPrefix)) {
                newValue = inlineBindingPrefix + value + inlineBindingSuffix;
            }
        }
        return newValue;
    }

    public String _changeValue(String oldValue, String value) throws CoreException, InvocationTargetException, InterruptedException {
        String newValue = value;
        if (!ComparisonUtils.equals((String)oldValue, (String)newValue, (boolean)true)) {
            BuildProperties buildProperties = (BuildProperties)this._cache.getProject().getAdapter(BuildProperties.class);
            newValue = RefactoringWodBinding.toBindingValue(this._wodElement.isInline(), buildProperties.getInlineBindingPrefix(), buildProperties.getInlineBindingSuffix(), newValue);
            ChangeBindingValueRefactoring.run(newValue, this._wodElement, (IWodBinding)this._wodBinding, this._cache, (IProgressMonitor)new NullProgressMonitor());
            this._wodBinding.setValue(newValue);
        }
        return newValue;
    }

    public String getValue() {
        return this._wodBinding.getValue();
    }

    public String getName() {
        return this._wodBinding.getName();
    }

    public void setName(String name) throws CoreException, InvocationTargetException, InterruptedException {
        String oldName = this._wodBinding.getName();
        if (name == null || name.length() == 0) {
            name = RefactoringWodElement.findUnusedBindingName(this._wodElement, name);
        }
        if (!ComparisonUtils.equals((Object)name, (Object)oldName)) {
            ChangeBindingNameRefactoring.run(name, this._wodElement, (IWodBinding)this._wodBinding, this._cache, (IProgressMonitor)new NullProgressMonitor());
            this._wodBinding.setName(name);
            this._propertyChange.firePropertyChange(BINDING_NAME, oldName, name);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChange.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this._propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChange.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this._propertyChange.removePropertyChangeListener(propertyName, listener);
    }
}

