/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.validation;

import java.util.LinkedList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.objectstyle.wolips.bindings.wod.WodBindingDeprecationProblem;
import org.objectstyle.wolips.bindings.wod.WodBindingNameProblem;
import org.objectstyle.wolips.bindings.wod.WodBindingValueProblem;
import org.objectstyle.wolips.bindings.wod.WodProblem;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;
import org.objectstyle.wolips.wodclipse.core.util.WodModelUtils;

public class InlineWodProblem {
    private WodParserCache _cache;
    private List<WodProblem> _wodProblems;
    private FuzzyXMLElement _element;

    public InlineWodProblem(FuzzyXMLElement element, String message, boolean warning, WodParserCache cache) {
        this._cache = cache;
        this._element = element;
        int offset = element.getOffset() + 1;
        int length = element.getName().length();
        int lineNumber = WodHtmlUtils.getLineAtOffset(this._cache.getHtmlEntry().getContents(), offset);
        WodProblem problem = new WodProblem(message, new Position(offset, length), lineNumber, warning);
        this._wodProblems = new LinkedList<WodProblem>();
        this._wodProblems.add(problem);
    }

    public InlineWodProblem(FuzzyXMLElement element, WodProblem wodProblem, WodParserCache cache) {
        this._cache = cache;
        this._element = element;
        this._wodProblems = new LinkedList<WodProblem>();
        this._wodProblems.add(wodProblem);
    }

    public InlineWodProblem(FuzzyXMLElement element, List<WodProblem> problems, WodParserCache cache) {
        this._cache = cache;
        this._element = element;
        this._wodProblems = problems;
    }

    public FuzzyXMLElement getElement() {
        return this._element;
    }

    public void createProblemMarkers() {
        for (WodProblem wodProblem : this._wodProblems) {
            IMarker marker = WodModelUtils.createMarker(this._cache.getHtmlEntry().getFile(), wodProblem);
            try {
                String name;
                int offset;
                FuzzyXMLAttribute attribute;
                if (marker == null) continue;
                boolean elementError = true;
                if (wodProblem instanceof WodBindingNameProblem) {
                    String name2 = ((WodBindingNameProblem)wodProblem).getBindingName();
                    attribute = this._element.getAttributeNode(name2);
                    if (attribute != null) {
                        elementError = false;
                        offset = attribute.getOffset() + 1;
                        marker.setAttribute("lineNumber", WodHtmlUtils.getLineAtOffset(this._cache.getHtmlEntry().getContents(), offset));
                        marker.setAttribute("charStart", offset);
                        marker.setAttribute("charEnd", offset + attribute.getName().length());
                    }
                } else if (wodProblem instanceof WodBindingValueProblem) {
                    String name3 = ((WodBindingValueProblem)wodProblem).getBindingName();
                    attribute = this._element.getAttributeNode(name3);
                    if (attribute != null) {
                        elementError = false;
                        offset = attribute.getOffset() + 1;
                        marker.setAttribute("lineNumber", WodHtmlUtils.getLineAtOffset(this._cache.getHtmlEntry().getContents(), offset));
                        marker.setAttribute("charStart", this._element.getOffset() + attribute.getValueDataOffset() + 1);
                        marker.setAttribute("charEnd", this._element.getOffset() + attribute.getValueDataOffset() + 1 + attribute.getValueDataLength());
                    }
                } else if (wodProblem instanceof WodBindingDeprecationProblem && (attribute = this._element.getAttributeNode(name = ((WodBindingDeprecationProblem)wodProblem).getBindingName())) != null) {
                    elementError = false;
                    offset = this._element.getOffset() + attribute.getValueDataOffset() + 1;
                    marker.setAttribute("lineNumber", WodHtmlUtils.getLineAtOffset(this._cache.getHtmlEntry().getContents(), offset));
                    marker.setAttribute("charStart", offset);
                    marker.setAttribute("charEnd", offset + attribute.getValueDataLength());
                }
                if (!elementError) continue;
                int offset2 = this._element.getOffset() + 1;
                marker.setAttribute("lineNumber", WodHtmlUtils.getLineAtOffset(this._cache.getHtmlEntry().getContents(), offset2));
                marker.setAttribute("charStart", offset2);
                marker.setAttribute("charEnd", offset2 + this._element.getName().length());
            }
            catch (CoreException e) {
                e.printStackTrace();
                Activator.getDefault().log(e);
            }
        }
    }
}

