/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;

public class WodAnnotationHover
implements IAnnotationHover,
ITextHover {
    private IAnnotationModel myAnnotationModel;

    public WodAnnotationHover(IAnnotationModel _annotationModel) {
        this.myAnnotationModel = _annotationModel;
    }

    public String getHoverInfo(ISourceViewer _sourceViewer, int _lineNumber) {
        String hoverInfo = null;
        List<Annotation> annotationsList = this.getAnnotationsForLine(_sourceViewer, _lineNumber);
        if (annotationsList != null) {
            ArrayList<String> messagesList = new ArrayList<String>();
            for (Annotation annotation : annotationsList) {
                String message = annotation.getText();
                if (message == null || (message = message.trim()).length() <= 0) continue;
                messagesList.add(message);
            }
            if (messagesList.size() == 1) {
                hoverInfo = (String)messagesList.get(0);
            } else if (messagesList.size() > 1) {
                hoverInfo = this.formatMessages(messagesList);
            }
        }
        return hoverInfo;
    }

    public String getHoverInfo(ITextViewer _textViewer, IRegion _hoverRegion) {
        Iterator annotationsIter = this.myAnnotationModel.getAnnotationIterator();
        while (annotationsIter.hasNext()) {
            String text;
            Annotation annotation = (Annotation)annotationsIter.next();
            Position position = this.myAnnotationModel.getPosition(annotation);
            if (!position.overlapsWith(_hoverRegion.getOffset(), _hoverRegion.getLength()) || (text = annotation.getText()) == null || text.trim().length() <= 0) continue;
            return text;
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer _textViewer, int _offset) {
        Iterator annotationsIter = this.myAnnotationModel.getAnnotationIterator();
        while (annotationsIter.hasNext()) {
            String text;
            Annotation annotation = (Annotation)annotationsIter.next();
            Position position = this.myAnnotationModel.getPosition(annotation);
            if (!position.overlapsWith(_offset, 0) || (text = annotation.getText()) == null || text.trim().length() <= 0) continue;
            return new Region(position.offset, position.length);
        }
        return null;
    }

    private String formatMessages(List _messages) {
        StringBuffer buffer = new StringBuffer();
        Iterator e = _messages.iterator();
        while (e.hasNext()) {
            buffer.append("- ");
            buffer.append(e.next());
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private List<Annotation> getAnnotationsForLine(ISourceViewer _viewer, int _line) {
        ArrayList<Annotation> annotationsList = new ArrayList<Annotation>();
        IDocument document = _viewer.getDocument();
        IAnnotationModel model = _viewer.getAnnotationModel();
        if (model != null) {
            Iterator annotationsIter = model.getAnnotationIterator();
            while (annotationsIter.hasNext()) {
                Annotation annotation = (Annotation)annotationsIter.next();
                Position position = model.getPosition(annotation);
                if (position == null) continue;
                try {
                    int annotationLine = document.getLineOfOffset(position.getOffset());
                    if (annotationLine != _line) continue;
                    annotationsList.add(annotation);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return annotationsList;
    }
}

