/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.SuperInterfaceSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.objectstyle.wolips.baseforplugins.util.CharSetUtils;

public class NewComponentCreationPage
extends NewTypeWizardPage {
    private static final String API_CHECKBOX_KEY = "NewComponentCreationPage.apiCheckbox";
    private static final String BODY_CHECKBOX_KEY = "NewComponentCreationPage.bodyCheckbox";
    private static final String CHARSET_ENCODING_KEY = "NewComponentCreationPage.encoding";
    protected static final String COMPONENT_CONTAINER = "NewComponentCreationPage.componentContainer";
    private static final String DEFAULT_SUPERCLASS_NAME = "com.webobjects.appserver.WOComponent";
    private static final String HTML_DOCTYPE_KEY = "NewComponentCreationPage.htmlDocType";
    private static final int LABEL_IMG_SIZE = 12;
    private static final String PAGE_NAME = "NewComponentCreationPage";
    private static final List<String> PREFERRED_COMPONENT_CONTAINER_PATHS = Arrays.asList("Components", "src/main/components");
    private static final List<String> PREFERRED_SOURCE_CONTAINER_PATHS = Arrays.asList("Sources", "src/main/java");
    private static final String SETTINGS_CREATECONSTR = "create_constructor";
    private static final String SETTINGS_CREATEUNIMPLEMENTED = "create_unimplemented";
    private static final String SUPERCLASS_KEY = "NewComponentCreationPage.superclass";
    private static final String WOD_CHECKBOX_KEY = "NewComponentCreationPage.wodCheckbox";
    private static final String WOO_CHECKBOX_KEY = "NewComponentCreationPage.wooCheckbox";
    private ImageDescriptor componentImageDescriptor;
    private Group componentViewTitle;
    private Label componentViewTitleLabel;
    private Button fComponentAPICheckbox;
    private IStatus fComponentAPIStatus;
    private StringButtonDialogField fComponentContainerDialogField;
    private IStatus fComponentContainerStatus;
    private Button fComponentHTMLBodyCheckbox;
    private Combo fComponentHTMLCombo;
    private IStatus fComponentHTMLStatus;
    private Button fComponentWODCheckbox;
    private IStatus fComponentWODStatus;
    private Button fComponentWOOCheckbox;
    private Combo fComponentWOOEncodingCombo;
    private IStatus fComponentWOOStatus;
    private SelectionButtonDialogFieldGroup fMethodStubsButtons;
    private boolean vComponentAPIEnabled;
    private IFolder vComponentContainerRoot;
    private boolean vComponentHTMLBodyEnabled;
    private String vComponentHTMLKey;
    private boolean vComponentWODEnabled;
    private boolean vComponentWOOEnabled;
    private String vComponentWOOEncodingKey;
    private IType wocomponentType;

    private static IJavaElement findClassWithName(IJavaElement el, String name) {
        if (el != null && el.getElementName().equals(name + ".java")) {
            return el;
        }
        if (el instanceof IPackageFragment || el instanceof IPackageFragmentRoot) {
            try {
                for (IJavaElement child : ((IParent)el).getChildren()) {
                    IJavaElement result = NewComponentCreationPage.findClassWithName(child, name);
                    if (result == null) continue;
                    return result;
                }
            }
            catch (JavaModelException e) {
                System.err.println(NewComponentCreationPage.class.getName() + ".findClassWithName(IJavaElement,String)");
                e.printStackTrace(System.err);
            }
        }
        return null;
    }

    private static IJavaElement findMainClass(IJavaElement el) {
        return NewComponentCreationPage.findClassWithName(el, "Main");
    }

    private static boolean isReservedResourcesPath(IPath path) {
        return new FluffyLayout().isReservedResourcesPath(path) || new MavenLayout().isReservedResourcesPath(path);
    }

    private static boolean isReservedSourcesPath(IPath path) {
        return new FluffyLayout().isReservedJavaSourcesPath(path) || new MavenLayout().isReservedJavaSourcesPath(path);
    }

    private static GridLayout newGridLayout(int nColumns, int marginHeight, int verticalSpacing) {
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = marginHeight;
        layout.verticalSpacing = verticalSpacing;
        return layout;
    }

    private static Font scaledFont(Font font, int height) {
        FontData[] labellingFontData;
        for (FontData fd : labellingFontData = font.getFontData()) {
            fd.setHeight(height);
        }
        return new Font(font.getDevice(), labellingFontData);
    }

    private static Image scaledImage(Display display, ImageDescriptor imageDescriptor, int width, int height) {
        ImageData imageData = imageDescriptor.getImageData().scaledTo(width, height);
        return new Image((Device)display, imageData);
    }

    private static String wooContentsWithEncoding(String lineDelimiter, String selectedEncoding) {
        StringBuilder buff = new StringBuilder();
        buff.append("{").append(lineDelimiter);
        buff.append("\t\"WebObjects Release\" = \"WebObjects 5.0\";").append(lineDelimiter);
        buff.append("\tencoding = \"" + selectedEncoding + "\";").append(lineDelimiter);
        buff.append("}").append(lineDelimiter);
        return buff.toString();
    }

    public NewComponentCreationPage() {
        this(true, PAGE_NAME);
    }

    public NewComponentCreationPage(boolean isClass, String pageName) {
        super(isClass, pageName);
        this.setTitle("WebObjects Component");
        this.setDescription("Create a new component view with controller class");
        String[] buttonNames2 = new String[]{NewWizardMessages.NewClassWizardPage_methods_constructors, NewWizardMessages.NewClassWizardPage_methods_inherited};
        this.fMethodStubsButtons = new SelectionButtonDialogFieldGroup(32, buttonNames2, 1);
        this.fMethodStubsButtons.setLabelText(NewWizardMessages.NewClassWizardPage_methods_label);
        ComponentContainerFieldAdapter componentContainerAdaptor = new ComponentContainerFieldAdapter();
        this.fComponentContainerDialogField = new StringButtonDialogField((IStringButtonAdapter)componentContainerAdaptor);
        this.fComponentContainerDialogField.setDialogFieldListener((IDialogFieldListener)componentContainerAdaptor);
        this.fComponentContainerDialogField.setLabelText(this.getComponentContainerLabel());
        this.fComponentContainerDialogField.setButtonLabel(NewWizardMessages.NewContainerWizardPage_container_button);
        this.fComponentContainerStatus = new StatusInfo();
        this.fComponentHTMLStatus = new StatusInfo();
        this.fComponentWODStatus = new StatusInfo();
        this.fComponentWOOStatus = new StatusInfo();
        this.fComponentAPIStatus = new StatusInfo();
        this.componentImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.objectstyle.wolips.wizards", (String)"icons/wobuilder/WOComponentBundle.png");
        this.vComponentAPIEnabled = true;
        this.vComponentContainerRoot = null;
        this.vComponentHTMLBodyEnabled = false;
        this.vComponentHTMLKey = HTML.BLANK_CONTENT.getDisplayString();
        this.vComponentWODEnabled = true;
        this.vComponentWOOEnabled = true;
        this.vComponentWOOEncodingKey = "UTF-8";
    }

    private IFolder chooseComponentContainer(String title, String message, IPath initialPath) {
        Class[] acceptedClasses = new Class[]{IProject.class, IPackageFragmentRoot.class, IFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            protected boolean isSelectedValid(Object elem) {
                if (super.isSelectedValid(elem)) {
                    IPackageFragmentRoot fr;
                    return !(elem instanceof IPackageFragmentRoot) || !NewComponentCreationPage.isReservedSourcesPath((fr = (IPackageFragmentRoot)elem).getPath());
                }
                return false;
            }
        };
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){
            List<String> rejectPathExtensions;
            List<String> rejectRelativePaths;
            {
                this.rejectPathExtensions = Arrays.asList("wo");
                this.rejectRelativePaths = Arrays.asList("Libraries", "WebServerResources", "bin", "build", "dist", "lib", "target", "woproject");
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IFolder folder;
                if (super.select(viewer, parentElement, element) && !(folder = (IFolder)element).getName().startsWith(".") && !this.rejectRelativePaths.contains(folder.getProjectRelativePath().toString())) {
                    for (String pathExtension : this.rejectPathExtensions) {
                        if (!folder.getName().endsWith(pathExtension)) continue;
                        return false;
                    }
                    try {
                        IPackageFragmentRoot fragmentRoot = NewComponentCreationPage.this.getJavaProject().getPackageFragmentRoot((IResource)folder);
                        for (IJavaElement el : fragmentRoot.getChildren()) {
                            if (!(el instanceof IPackageFragment) && !(el instanceof ICompilationUnit)) continue;
                            return false;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                return false;
            }
        };
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IProject currProject = this.getJavaProject().getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)currProject);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        IResource res = currProject.findMember(initialPath);
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    protected IStatus componentAPIChanged() {
        return this.fComponentAPIStatus;
    }

    protected void componentContainerChangeControlPressed(DialogField field) {
        Path initialPath;
        String message;
        String title;
        IFolder folder;
        if (field == this.fComponentContainerDialogField && (folder = this.chooseComponentContainer(title = "Existing Component Folder", message = "Choose folder as component source folder:", (IPath)(initialPath = new Path(this.fComponentContainerDialogField.getText())))) != null) {
            this.setComponentContainerRoot(folder, true);
        }
    }

    protected IStatus componentContainerChanged() {
        StatusInfo status = new StatusInfo();
        String str = this.getComponentContainerRootText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.NewContainerWizardPage_error_EnterContainerName);
            return status;
        }
        if (str.endsWith(".wo")) {
            status.setError("A component cannot be created within another component");
            return status;
        }
        Path path = new Path(str);
        IResource res = this.getWorkspaceRoot().findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(Messages.format((String)NewWizardMessages.NewContainerWizardPage_error_ProjectClosed, (Object)proj.getName()));
                    return status;
                }
                IJavaProject jproject = JavaCore.create((IProject)proj);
                IPackageFragmentRoot fragmentRoot = jproject.getPackageFragmentRoot(res);
                if (res.exists()) {
                    try {
                        if (!proj.hasNature("org.eclipse.jdt.core.javanature")) {
                            if (resType == 4) {
                                status.setError(NewWizardMessages.NewContainerWizardPage_warning_NotAJavaProject);
                            } else {
                                status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotInAJavaProject);
                            }
                            return status;
                        }
                        if (fragmentRoot.isArchive()) {
                            status.setError(Messages.format((String)NewWizardMessages.NewContainerWizardPage_error_ContainerIsBinary, (Object)str));
                            return status;
                        }
                        if (fragmentRoot.getKind() == 2) {
                            status.setWarning(Messages.format((String)NewWizardMessages.NewContainerWizardPage_warning_inside_classfolder, (Object)str));
                        } else if (!jproject.isOnClasspath((IJavaElement)fragmentRoot)) {
                            status.setWarning(Messages.format((String)NewWizardMessages.NewContainerWizardPage_warning_NotOnClassPath, (Object)str));
                        }
                    }
                    catch (JavaModelException javaModelException) {
                    }
                    catch (CoreException e) {
                        System.err.println(((Object)((Object)this)).getClass().getName() + ".componentContainerChanged threw an exception.");
                        e.printStackTrace(System.err);
                        status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotAJavaProject);
                    }
                }
                return status;
            }
            status.setError(Messages.format((String)NewWizardMessages.NewContainerWizardPage_error_NotAFolder, (Object)str));
            return status;
        }
        status.setError(Messages.format((String)NewWizardMessages.NewContainerWizardPage_error_ContainerDoesNotExist, (Object)str));
        return status;
    }

    protected void componentContainerDialogFieldChanged(DialogField field) {
        this.handleFieldChanged(COMPONENT_CONTAINER);
    }

    protected IStatus componentHTMLChanged() {
        return this.fComponentHTMLStatus;
    }

    protected IStatus componentWODChanged() {
        return this.fComponentWODStatus;
    }

    protected IStatus componentWOOChanged() {
        return this.fComponentWOOStatus;
    }

    protected void createCommentControls(Composite parent, int nColumns) {
        super.createCommentControls(parent, nColumns);
        this.enableCommentControl(true);
        this.setAddComments(true, true);
    }

    private void createComponentAPIControls(Composite parent, int nColumns) {
        this.fComponentAPICheckbox = new Button(parent, 32);
        this.fComponentAPICheckbox.setText("API file");
        this.fComponentAPICheckbox.setSelection(this.getDialogSettings().getBoolean(API_CHECKBOX_KEY));
        this.fComponentAPICheckbox.addSelectionListener((SelectionListener)new ButtonSelectionAdaptor());
    }

    private void createComponentContainerControls(Composite parent, int nColumns) {
        this.fComponentContainerDialogField.doFillIntoGrid(parent, nColumns);
        LayoutUtil.setWidthHint((Control)this.fComponentContainerDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    private void createComponentHeader(Composite parent, int nColumns) {
        Font labellingFont = NewComponentCreationPage.scaledFont(parent.getFont(), 9);
        this.componentViewTitle = new Group(parent, 0);
        this.componentViewTitle.setBackground(this.componentViewTitle.getDisplay().getSystemColor(32));
        this.componentViewTitle.setLayout((Layout)NewComponentCreationPage.newGridLayout(nColumns, 0, 1));
        this.componentViewTitle.setLayoutData((Object)new GridData(768));
        this.componentViewTitle.setFont(labellingFont);
        Label componentViewTitleIcon = new Label((Composite)this.componentViewTitle, 0);
        componentViewTitleIcon.setFont(labellingFont);
        componentViewTitleIcon.setImage(NewComponentCreationPage.scaledImage(componentViewTitleIcon.getDisplay(), this.componentImageDescriptor, 14, 14));
        this.componentViewTitleLabel = new Label((Composite)this.componentViewTitle, 0);
        this.componentViewTitleLabel.setFont(labellingFont);
        this.componentViewTitleLabel.setText("Component View");
        LayoutUtil.setHorizontalSpan((Control)this.componentViewTitle, (int)nColumns);
    }

    private void createComponentHTMLControls(Composite parent, int nColumns) {
        Composite componentHTMLControls = parent;
        Label htmlLabel = new Label(componentHTMLControls, 16384);
        htmlLabel.setText("HTML template:");
        htmlLabel.setLayoutData((Object)new GridData(768));
        Composite controlsComposite = new Composite(componentHTMLControls, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        controlsComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        controlsComposite.setLayoutData((Object)data);
        this.fComponentHTMLCombo = new Combo(controlsComposite, 4);
        this.fComponentHTMLCombo.setLayoutData((Object)new GridData(768));
        this.fComponentHTMLCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyevent) {
                NewComponentCreationPage.this.setComponentHTMLKey(NewComponentCreationPage.this.fComponentHTMLCombo.getText());
            }
        });
        this.populateHTMLCombo(this.fComponentHTMLCombo);
        LayoutUtil.setHorizontalSpan((Control)this.fComponentHTMLCombo, (int)1);
        LayoutUtil.setWidthHint((Control)this.fComponentHTMLCombo, (int)this.getMaxFieldWidth());
        Link link = new Link(controlsComposite, 0);
        link.setText(" <a>configure templates</a>");
        link.setFont(NewComponentCreationPage.scaledFont(link.getFont(), 10));
        LayoutUtil.setHorizontalSpan((Control)controlsComposite, (int)2);
        new Label(componentHTMLControls, 0);
    }

    private void createComponentWODControls(Composite parent, int nColumns) {
        this.fComponentWODCheckbox = new Button(parent, 32);
        this.fComponentWODCheckbox.setText("WOD file");
        this.fComponentWODCheckbox.setSelection(this.getDialogSettings().getBoolean(WOD_CHECKBOX_KEY));
        this.fComponentWODCheckbox.addSelectionListener((SelectionListener)new ButtonSelectionAdaptor());
    }

    private void createComponentWOOControls(Composite parent, int nColumns) {
        Composite componentWOOComposite = parent;
        Label label = new Label(componentWOOComposite, 16384);
        label.setText("Charset encoding:");
        Composite controlsComposite = new Composite(componentWOOComposite, 16384);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        controlsComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        controlsComposite.setLayoutData((Object)data);
        this.fComponentWOOEncodingCombo = new Combo(controlsComposite, 16384);
        this.fComponentWOOEncodingCombo.setLayoutData((Object)new GridData(768));
        this.fComponentWOOEncodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyevent) {
                NewComponentCreationPage.this.setComponentWOOEncodingKey(NewComponentCreationPage.this.fComponentWOOEncodingCombo.getText());
            }
        });
        this.populateComponentWOOEncodingCombo(this.fComponentWOOEncodingCombo);
        LayoutUtil.setHorizontalSpan((Control)this.fComponentWOOEncodingCombo, (int)2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fComponentWOOEncodingCombo);
        label = new Label(controlsComposite, 16384);
        label.setText("UTF-8 recommended");
        label.setFont(NewComponentCreationPage.scaledFont(label.getFont(), 10));
        label.setLayoutData((Object)new GridData());
        LayoutUtil.setHorizontalSpan((Control)controlsComposite, (int)2);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        composite.setLayout((Layout)NewComponentCreationPage.newGridLayout(nColumns, 5, 5));
        this.createTypeNameControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createComponentHeader(composite, nColumns);
        this.createComponentContainerControls(composite, nColumns);
        this.createComponentHTMLControls(composite, nColumns);
        this.createComponentWOOControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createControllerHeader(composite, nColumns);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        if (this.isSuperInterfacesEnabled()) {
            this.createSuperInterfacesControls(composite, nColumns);
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
    }

    private void createControllerHeader(Composite parent, int nColumns) {
        Font labellingFont = NewComponentCreationPage.scaledFont(parent.getFont(), 9);
        Label label = null;
        Group controllerComposite = new Group(parent, 0);
        Color color = new Color((Device)controllerComposite.getDisplay(), 187, 226, 174);
        controllerComposite.setBackground(color);
        controllerComposite.setLayout((Layout)NewComponentCreationPage.newGridLayout(nColumns, 0, 1));
        controllerComposite.setLayoutData((Object)new GridData(768));
        controllerComposite.setFont(labellingFont);
        label = new Label((Composite)controllerComposite, 0);
        label.setFont(labellingFont);
        label.setImage(NewComponentCreationPage.scaledImage(label.getDisplay(), JavaPluginImages.DESC_TOOL_NEWCLASS, 14, 14));
        label = new Label((Composite)controllerComposite, 0);
        label.setFont(labellingFont);
        label.setText("Component Controller");
        LayoutUtil.setHorizontalSpan((Control)controllerComposite, (int)nColumns);
    }

    private void createMethodStubSelectionControls(Composite composite, int nColumns) {
        Label labelControl = this.fMethodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, (int)nColumns);
        DialogField.createEmptySpace((Composite)composite);
        Composite buttonGroup = this.fMethodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)(nColumns - 1));
        this.setMethodStubSelection(false, true, false, true);
    }

    protected void createPackageControls(Composite composite, int nColumns) {
        super.createPackageControls(composite, nColumns);
    }

    protected void createSuperClassControls(Composite composite, int columns) {
        super.createSuperClassControls(composite, columns);
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IProgressMonitor progressMonitor = monitor;
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        IPath componentContainerPath = this.getComponentContainer().getProjectRelativePath();
        IProject project = this.getComponentContainer().getProject();
        progressMonitor.beginTask("Creating component....", 8 + componentContainerPath.segmentCount() + 4);
        super.createType((IProgressMonitor)new SubProgressMonitor(progressMonitor, 8));
        String componentName = this.getTypeName();
        IPath componentBundlePath = componentContainerPath.addTrailingSeparator().append(componentName + ".wo");
        IFolder componentBundleFolder = project.getFolder(componentBundlePath);
        if (!componentBundleFolder.exists()) {
            this.prepareFolder(componentBundleFolder, (IProgressMonitor)new SubProgressMonitor(progressMonitor, componentBundlePath.segmentCount()));
        } else {
            progressMonitor.worked(componentBundlePath.segmentCount());
        }
        String lineDelimiter = NewComponentCreationPage.getLineDelimiterUsed(this.getJavaProject());
        HashMap<String, String> filesContents = new HashMap<String, String>();
        filesContents.put("wod", "");
        filesContents.put("woo", NewComponentCreationPage.wooContentsWithEncoding(lineDelimiter, this.getComponentWOOEncodingKey()));
        progressMonitor.worked(1);
        filesContents.put("html", this.getSelectedHTML().getHTML(lineDelimiter));
        progressMonitor.worked(1);
        for (Map.Entry entry : filesContents.entrySet()) {
            FileCreationWorker fileCreator = new FileCreationWorker(componentBundleFolder, componentName, (String)entry.getKey(), (String)entry.getValue());
            try {
                fileCreator.run(progressMonitor);
            }
            catch (InvocationTargetException e) {
                CoreException exception = new CoreException(Status.CANCEL_STATUS);
                exception.setStackTrace(e.getStackTrace());
                throw exception;
            }
        }
        progressMonitor.done();
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        boolean doMain = this.isCreateMain();
        boolean doConstr = this.isCreateConstructors();
        boolean doInherited = this.isCreateInherited();
        IMethod[] methods = this.createInheritedMethods(type, doConstr, doInherited, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IMethod mainMethod = null;
        if (doMain) {
            StringBuffer buf = new StringBuffer();
            String comment = CodeGeneration.getMethodComment((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)"main", (String[])new String[]{"args"}, (String[])new String[0], (String)Signature.createTypeSignature((String)"void", (boolean)true), null, (String)"\n");
            if (comment != null) {
                buf.append(comment);
                buf.append("\n");
            }
            buf.append("public static void main(");
            buf.append(imports.addImport("java.lang.String"));
            buf.append("[] args) {");
            buf.append("\n");
            String content = CodeGeneration.getMethodBodyContent((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)"main", (boolean)false, (String)"", (String)"\n");
            if (content != null && content.length() != 0) {
                buf.append(content);
            }
            buf.append("\n");
            buf.append("}");
            mainMethod = type.createMethod(buf.toString(), null, false, null);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void doStatusUpdate() {
        IStatus[] statuses = new IStatus[]{this.fComponentContainerStatus, this.fComponentHTMLStatus, this.fComponentWODStatus, this.fComponentWOOStatus, this.fComponentAPIStatus, this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(statuses);
    }

    private IFolder getComponentContainer() {
        return this.vComponentContainerRoot;
    }

    private String getComponentContainerLabel() {
        return "Component folder:";
    }

    public String getComponentContainerRootText() {
        return this.fComponentContainerDialogField.getText();
    }

    private String getComponentHTMLKey() {
        return this.vComponentHTMLKey;
    }

    private String getComponentWOOEncodingKey() {
        return this.vComponentWOOEncodingKey;
    }

    private IType getDefaultWOComponentType() {
        if (this.wocomponentType == null && this.getJavaProject() != null) {
            try {
                this.wocomponentType = this.getJavaProject().findType(DEFAULT_SUPERCLASS_NAME);
            }
            catch (JavaModelException e) {
                System.err.println(((Object)((Object)this)).getClass().getName() + ".getWOComponentType()");
                e.printStackTrace(System.err);
            }
        }
        return this.wocomponentType;
    }

    private HTML getSelectedHTML() {
        return HTML.getValueForKey(this.getComponentHTMLKey());
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (COMPONENT_CONTAINER.equals(fieldName)) {
            this.fComponentAPIStatus = this.componentAPIChanged();
            this.fComponentContainerStatus = this.componentContainerChanged();
            this.fComponentHTMLStatus = this.componentHTMLChanged();
            this.fComponentWODStatus = this.componentWODChanged();
            this.fComponentWOOStatus = this.componentWOOChanged();
        }
        if ("NewContainerWizardPage.container".equals(fieldName)) {
            this.fPackageStatus = this.packageChanged();
            this.fEnclosingTypeStatus = this.enclosingTypeChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            this.fSuperInterfacesStatus = this.superInterfacesChanged();
        }
        if ("NewTypeWizardPage.modifiers".equals(fieldName)) {
            int modifiers = this.getModifiers();
            this.setComponentViewEnabled(Flags.isPublic((int)modifiers) && !Flags.isAbstract((int)modifiers));
        }
        this.doStatusUpdate();
    }

    protected void handleSelectionEvent(SelectionEvent event) {
        Widget w = event.widget;
        if (w instanceof Button) {
            this.refreshButtonSettings((Button)w);
        }
    }

    public void init(IStructuredSelection selection) {
        IDialogSettings section;
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initComponentContainerPage(selection, jelem);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
        boolean createMain = false;
        boolean createConstructors = true;
        boolean createUnimplemented = true;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (section = dialogSettings.getSection("NewClassWizardPage")) != null) {
            createConstructors = section.getBoolean(SETTINGS_CREATECONSTR);
            createUnimplemented = section.getBoolean(SETTINGS_CREATEUNIMPLEMENTED);
        }
        this.setMethodStubSelection(createMain, createConstructors, createUnimplemented, true);
    }

    protected void initComponentContainerPage(IStructuredSelection selection, IJavaElement jelem) {
        IPath componentFolderPath;
        IProject project = null;
        IResource resource = null;
        if (jelem != null) {
            Object el;
            project = jelem.getJavaProject().getProject();
            if (jelem.getElementType() != 2) {
                if (this.isFragmentRootAndResourcesCompatible(jelem)) {
                    try {
                        resource = jelem.getCorrespondingResource();
                    }
                    catch (JavaModelException e) {
                        System.err.println(((Object)((Object)this)).getClass().getName() + ".initComponentContainerPage(IStructuredSelection,IJavaElement)");
                        e.printStackTrace(System.err);
                    }
                }
            } else if (selection != null && !selection.isEmpty() && (el = selection.getFirstElement()) instanceof IResource) {
                resource = (IResource)el;
                project = resource.getProject();
                if (resource instanceof IFile) {
                    resource = ((IFile)resource).getParent();
                } else if (resource.getType() != 2) {
                    resource = null;
                }
            }
        }
        IFolder componentFolder = null;
        if (resource instanceof IFolder && NewComponentCreationPage.isReservedSourcesPath(componentFolderPath = (componentFolder = (IFolder)resource).getFullPath())) {
            componentFolder = null;
        }
        if (componentFolder == null) {
            if (this.getComponentContainer() != null) {
                componentFolder = this.getComponentContainer();
            } else if (selection != null) {
                for (String container : PREFERRED_COMPONENT_CONTAINER_PATHS) {
                    IResource el = project.findMember(container);
                    if (!(el instanceof IFolder)) continue;
                    componentFolder = (IFolder)el;
                    break;
                }
            }
        }
        this.setComponentContainerRoot(componentFolder, true);
    }

    protected void initContainerPage(IJavaElement elem) {
        IPackageFragmentRoot initRoot;
        block6: {
            initRoot = null;
            if (elem != null) {
                try {
                    IJavaProject jproject;
                    IPath initRootPath;
                    initRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)elem);
                    IPath iPath = initRootPath = initRoot == null ? null : initRoot.getPath();
                    if (NewComponentCreationPage.isReservedResourcesPath(initRootPath)) {
                        initRoot = null;
                        initRootPath = null;
                    }
                    if (initRoot != null || (jproject = elem.getJavaProject()) == null || !jproject.exists()) break block6;
                    IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                    for (String root : PREFERRED_SOURCE_CONTAINER_PATHS) {
                        for (int i = 0; i < roots.length; ++i) {
                            IPath rootPath;
                            if (roots[i].getKind() != 1 && !root.equals((rootPath = roots[i].getPath().makeRelative().removeFirstSegments(1)).toString())) continue;
                            initRoot = roots[i];
                            break block6;
                        }
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((Throwable)e);
                }
            }
        }
        this.setPackageFragmentRoot(initRoot, true);
    }

    protected void initSuperInterfaces(IJavaElement elem) {
        if (this.isSuperInterfacesEnabled() && (this.getSuperInterfaces() == null || this.getSuperInterfaces().size() == 0)) {
            ArrayList<String> interfaces = new ArrayList<String>();
            if (elem instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)elem;
                try {
                    String interfaceName;
                    IType primaryType;
                    if (elem.getElementType() == 5 && (primaryType = unit.findPrimaryType()).exists() && primaryType.isInterface() && (interfaceName = SuperInterfaceSelectionDialog.getNameWithTypeParameters((IType)primaryType)) != null) {
                        interfaces.add(interfaceName);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            if (interfaces.size() > 0) {
                this.setSuperInterfaces(interfaces, true);
            }
        }
    }

    protected void initTypePage(IJavaElement elem) {
        boolean requiresSuperclass;
        ITypeHierarchy supertypeHierarchy;
        super.initTypePage(elem);
        if (this.getJavaProject() != null) {
            IType type;
            IJavaElement compilationUnit;
            IPackageFragmentRoot froot;
            if (elem instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)elem;
                try {
                    IType primaryType = unit.findPrimaryType();
                    if (primaryType != null && (supertypeHierarchy = primaryType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor())).contains(this.getDefaultWOComponentType())) {
                        this.setSuperClass(primaryType.getFullyQualifiedName(), true);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            this.initSuperInterfaces(elem);
            if ((this.getPackageFragment() == null || this.getPackageFragment().isDefaultPackage()) && (froot = this.getPackageFragmentRoot()) != null && (compilationUnit = NewComponentCreationPage.findMainClass((IJavaElement)froot)) instanceof ICompilationUnit && (type = ((ICompilationUnit)compilationUnit).findPrimaryType()) != null) {
                this.setPackageFragment(type.getPackageFragment(), true);
            }
        }
        boolean bl = requiresSuperclass = this.getSuperClass() == null || this.getSuperClass().matches("\\s*");
        if (!requiresSuperclass) {
            requiresSuperclass = true;
            try {
                IType supertype = this.getJavaProject().findType(this.getSuperClass());
                supertypeHierarchy = supertype.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                if (supertypeHierarchy.contains(this.getDefaultWOComponentType())) {
                    requiresSuperclass = false;
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (requiresSuperclass) {
            this.setSuperClass(DEFAULT_SUPERCLASS_NAME, true);
        }
    }

    public boolean isCreateConstructors() {
        return this.fMethodStubsButtons.isSelected(1);
    }

    public boolean isCreateInherited() {
        return this.fMethodStubsButtons.isSelected(2);
    }

    public boolean isCreateMain() {
        return false;
    }

    private boolean isFragmentRootAndResourcesCompatible(IJavaElement el) {
        IPackageFragmentRoot froot;
        IPath frootPath;
        boolean result = false;
        if (el instanceof IPackageFragmentRoot && !NewComponentCreationPage.isReservedResourcesPath(frootPath = (froot = (IPackageFragmentRoot)el).getPath())) {
            result = true;
            try {
                for (IJavaElement child : froot.getChildren()) {
                    if (!(child instanceof IPackageFragment) && !(child instanceof ICompilationUnit)) continue;
                    result = false;
                    break;
                }
            }
            catch (JavaModelException e) {
                System.err.println(((Object)((Object)this)).getClass().getName() + ".isFragmentRootAndResourcesCompatible(IJavaElement)");
                e.printStackTrace(System.err);
                result = false;
            }
        }
        return result;
    }

    protected boolean isSuperInterfacesEnabled() {
        return false;
    }

    private void populateComponentWOOEncodingCombo(Combo componentAPIEncodingCombo) {
        for (String charset : CharSetUtils.defaultCharsetEncodingNames()) {
            componentAPIEncodingCombo.add(charset);
        }
        this.selectCharsetEncodingPreference(componentAPIEncodingCombo);
    }

    private void populateHTMLCombo(Combo c) {
        for (HTML entry : HTML.values()) {
            c.add(entry.getDisplayString());
        }
        this.selectHTMLDocTypePreference(c);
    }

    private void prepareFolder(IFolder folder, IProgressMonitor progressMonitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                this.prepareFolder((IFolder)parent, progressMonitor);
            }
            folder.create(false, true, progressMonitor);
        } else {
            progressMonitor.worked(1);
        }
    }

    protected void refreshButtonSettings(Button button) {
        if (button != null) {
            if (button.equals(this.fComponentHTMLBodyCheckbox)) {
                this.fComponentHTMLCombo.setEnabled(this.fComponentHTMLBodyCheckbox.getSelection());
            } else if (button.equals(this.fComponentWOOCheckbox)) {
                this.fComponentWOOEncodingCombo.setEnabled(this.fComponentWOOCheckbox.getSelection());
            }
        }
    }

    private void selectCharsetEncodingPreference(Combo combo) {
        String previousEncoding = this.getDialogSettings().get(CHARSET_ENCODING_KEY);
        if (previousEncoding != null && previousEncoding.length() > 0) {
            int i = 0;
            for (String encoding : Charset.availableCharsets().keySet()) {
                if (previousEncoding.equals(encoding)) {
                    combo.select(i);
                    return;
                }
                ++i;
            }
        }
        combo.setText("UTF-8");
    }

    private void selectHTMLDocTypePreference(Combo c) {
        String previousDocType = this.getDialogSettings().get(HTML_DOCTYPE_KEY);
        if (previousDocType != null && previousDocType.length() > 0) {
            int i = 0;
            for (HTML entry : HTML.values()) {
                if (previousDocType.equals(entry.getDisplayString())) {
                    c.select(i);
                    return;
                }
                ++i;
            }
        }
        c.select(0);
    }

    private void setComponentContainerRoot(IFolder folder, boolean canBeModified) {
        this.vComponentContainerRoot = folder;
        StringBuilder path = new StringBuilder();
        if (folder != null) {
            path.append(folder.getProject().getName());
            path.append(folder.getProject().getProjectRelativePath().addTrailingSeparator());
            path.append(folder.getProjectRelativePath());
        }
        this.fComponentContainerDialogField.setText(path.toString());
        this.fComponentContainerDialogField.setEnabled(canBeModified);
    }

    private void setComponentHTMLKey(String key) {
        this.vComponentHTMLKey = key;
        HTML html = HTML.getValueForKey(this.getComponentHTMLKey());
        this.vComponentHTMLBodyEnabled = !HTML.BLANK_CONTENT.equals((Object)html);
    }

    protected void setComponentViewEnabled(boolean enabled) {
        if (enabled) {
            this.componentViewTitle.setBackground(this.componentViewTitle.getDisplay().getSystemColor(32));
            this.componentViewTitleLabel.setForeground(this.componentViewTitle.getDisplay().getSystemColor(30));
        } else {
            this.componentViewTitle.setBackground(this.componentViewTitle.getDisplay().getSystemColor(34));
            this.componentViewTitleLabel.setForeground(this.componentViewTitle.getDisplay().getSystemColor(33));
        }
        this.fComponentAPICheckbox.setEnabled(enabled);
        this.fComponentContainerDialogField.setEnabled(enabled);
        this.fComponentHTMLBodyCheckbox.setEnabled(enabled);
        if (enabled) {
            this.refreshButtonSettings(this.fComponentHTMLBodyCheckbox);
        } else {
            this.fComponentHTMLCombo.setEnabled(enabled);
        }
        this.fComponentWODCheckbox.setEnabled(enabled);
        this.fComponentWOOCheckbox.setEnabled(enabled);
        if (enabled) {
            this.refreshButtonSettings(this.fComponentWOOCheckbox);
        } else {
            this.fComponentWOOEncodingCombo.setEnabled(enabled);
        }
    }

    private void setComponentWOOEncodingKey(String encodingKey) {
        this.vComponentWOOEncodingKey = encodingKey;
        this.vComponentWOOEnabled = encodingKey != null && !encodingKey.matches("^\\s*$");
    }

    public void setMethodStubSelection(boolean createMain, boolean createConstructors, boolean createInherited, boolean canBeModified) {
        this.fMethodStubsButtons.setSelection(0, createConstructors);
        this.fMethodStubsButtons.setSelection(1, createInherited);
        this.fMethodStubsButtons.setEnabled(canBeModified);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        } else {
            IDialogSettings dialogSettings = this.getDialogSettings();
            if (dialogSettings != null) {
                IDialogSettings section = dialogSettings.getSection("NewClassWizardPage");
                if (section == null) {
                    section = dialogSettings.addNewSection("NewClassWizardPage");
                }
                section.put(SETTINGS_CREATECONSTR, this.isCreateConstructors());
                section.put(SETTINGS_CREATEUNIMPLEMENTED, this.isCreateInherited());
            }
        }
    }

    protected IStatus superClassChanged() {
        StatusInfo superclassStatus = new StatusInfo();
        if (!DEFAULT_SUPERCLASS_NAME.equals(this.getSuperClass())) {
            if (this.getSuperClass() == null || this.getSuperClass().matches("\\s*")) {
                superclassStatus.setError("The super type must be assignable to com.webobjects.appserver.WOComponent");
            } else if (this.getDefaultWOComponentType() == null) {
                superclassStatus.setError("com.webobjects.appserver.WOComponent is not on the classpath");
            } else {
                try {
                    IType type = this.getJavaProject().findType(this.getSuperClass());
                    ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    if (!JavaModelUtil.isSuperType((ITypeHierarchy)typeHierarchy, (IType)this.getDefaultWOComponentType(), (IType)type)) {
                        superclassStatus.setError("The super type must be assignable to com.webobjects.appserver.WOComponent");
                    }
                }
                catch (JavaModelException e) {
                    System.err.println(((Object)((Object)this)).getClass().getName() + ".superClassChanged() Failed to determine superclass hierarchy.");
                    e.printStackTrace(System.err);
                    superclassStatus.setWarning("Unable to determine superclass hierarchy");
                }
            }
        }
        if (!superclassStatus.isError()) {
            IStatus status = super.superClassChanged();
            if (!superclassStatus.isWarning() && status.getSeverity() == 6) {
                return status;
            }
        }
        return superclassStatus;
    }

    protected IStatus typeNameChanged() {
        IStatus typeNameStatus = super.typeNameChanged();
        if (typeNameStatus.getSeverity() != 4 && this.getTypeName() != null && !this.getTypeName().matches("\\s*")) {
            if (this.getComponentContainer() == null) {
                if (typeNameStatus.getSeverity() != 2) {
                    typeNameStatus = new StatusInfo(2, "The component source folder is required");
                }
            } else {
                String componentName = this.getTypeName() + ".wo";
                try {
                    for (IResource member : this.getComponentContainer().members()) {
                        if (!member.getName().equalsIgnoreCase(componentName)) continue;
                        String typeName = "component";
                        if (member.getType() == 1) {
                            typeName = "file";
                        }
                        typeNameStatus = new StatusInfo(4, "The component name matches an existing " + typeName);
                    }
                }
                catch (CoreException e) {
                    System.err.println(((Object)((Object)this)).getClass().getName() + ".typeNameChanged() failed to iterate members");
                    e.printStackTrace(System.err);
                }
            }
        }
        return typeNameStatus;
    }

    private static String getLineDelimiterUsed(IJavaProject project) {
        return NewComponentCreationPage.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(IJavaProject javaProject) {
        String lineDelimiter;
        IProject project = null;
        if (javaProject != null) {
            project = javaProject.getProject();
        }
        if ((lineDelimiter = NewComponentCreationPage.getLineDelimiterPreference(project)) != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    private static String getLineDelimiterPreference(IProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    private static class MavenLayout
    extends AbstractLayout {
        private static final List<String> RESERVED_MAVEN2_PREFIX_PATHS = Arrays.asList("src/main/", "src/test/", "src/itest/");
        private static final List<String> RESERVED_MAVEN2_RESOURCE_PATHS = Arrays.asList("components", "resources", "webserver-resources");
        private static final List<String> RESERVED_MAVEN2_SOURCE_PATHS = Arrays.asList("java");
        private static final List<String> RESERVED_ROOT_PATHS = Arrays.asList("target");

        private MavenLayout() {
        }

        @Override
        protected List<String> reservedJavaSourcePaths() {
            return RESERVED_MAVEN2_SOURCE_PATHS;
        }

        @Override
        protected List<String> reservedPathPrefixes() {
            return RESERVED_MAVEN2_PREFIX_PATHS;
        }

        @Override
        protected List<String> reservedPathRejects() {
            return RESERVED_ROOT_PATHS;
        }

        @Override
        protected List<String> reservedResourceSourcePaths() {
            return RESERVED_MAVEN2_RESOURCE_PATHS;
        }
    }

    static enum HTML {
        BLANK_CONTENT("Blank HTML Content", 0),
        HTML_UNSPECIFIED("HTML", 1),
        HTML401_STRICT("HTML 4.0.1 Strict", 2),
        HTML401_TRANSITIONAL("HTML 4.0.1 Transitional", 3),
        XHTML10_FRAMESET("XHTML 1.0 Frameset", 4),
        XHTML10_STRICT("XHTML 1.0 Strict", 5),
        XHTML10_TRANSITIONAL("XHTML 1.0 Transitional", 6),
        XHTML11("XHTML 1.1", 7);

        private final String _displayString;
        private String _html;
        private final int _templateIndex;

        static HTML getDefaultHTML() {
            return XHTML10_TRANSITIONAL;
        }

        static HTML getValueForKey(String key) {
            for (HTML value : HTML.values()) {
                if (!value.getDisplayString().equals(key)) continue;
                return value;
            }
            return HTML.getDefaultHTML();
        }

        private HTML(String display, int templateIndex) {
            this(display, templateIndex, null);
        }

        private HTML(String display, int templateIndex, String html) {
            this._displayString = display;
            this._html = html;
            this._templateIndex = templateIndex;
        }

        String getDisplayString() {
            return this._displayString;
        }

        String getHTML(String lineSeparator) {
            if (this._html == null) {
                StringBuilder buff = new StringBuilder();
                if (!BLANK_CONTENT.equals((Object)this)) {
                    String dateString = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
                    String userName = System.getProperty("user.name", "WOLips");
                    boolean isXML = true;
                    if (HTML_UNSPECIFIED.equals((Object)this)) {
                        isXML = false;
                        buff.append("<html>");
                    } else if (HTML401_STRICT.equals((Object)this)) {
                        isXML = false;
                        buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\"").append(lineSeparator);
                        buff.append("   \"http://www.w3.org/TR/html4/strict.dtd\">").append(lineSeparator);
                        buff.append(lineSeparator);
                        buff.append("<html lang=\"en\">").append(lineSeparator);
                    } else if (HTML401_TRANSITIONAL.equals((Object)this)) {
                        isXML = false;
                        buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"").append(lineSeparator);
                        buff.append("   \"http://www.w3.org/TR/html4/loose.dtd\">").append(lineSeparator);
                        buff.append(lineSeparator);
                        buff.append("<html lang=\"en\">").append(lineSeparator);
                    } else if (XHTML10_FRAMESET.equals((Object)this)) {
                        buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\"").append(lineSeparator);
                        buff.append("\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">").append(lineSeparator);
                        buff.append(lineSeparator);
                        buff.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">").append(lineSeparator);
                    } else if (XHTML10_STRICT.equals((Object)this)) {
                        buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"").append(lineSeparator);
                        buff.append("\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">").append(lineSeparator);
                        buff.append(lineSeparator);
                        buff.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">").append(lineSeparator);
                    } else if (XHTML10_TRANSITIONAL.equals((Object)this)) {
                        buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"").append(lineSeparator);
                        buff.append("\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">").append(lineSeparator);
                        buff.append(lineSeparator);
                        buff.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">").append(lineSeparator);
                    } else if (XHTML11.equals((Object)this)) {
                        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(lineSeparator);
                        buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"").append(lineSeparator);
                        buff.append("\t\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">").append(lineSeparator);
                        buff.append(lineSeparator);
                        buff.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">").append(lineSeparator);
                    }
                    String closingTag = isXML ? "/>" : ">";
                    buff.append(lineSeparator).append("<head>").append(lineSeparator);
                    buff.append(lineSeparator).append("\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"").append(closingTag);
                    buff.append(lineSeparator).append("\t<title>untitled</title>");
                    buff.append(lineSeparator).append("\t<meta name=\"generator\" content=\"WOLips http://wiki.objectstyle.org/confluence/display/WOL/Home\"").append(closingTag);
                    buff.append(lineSeparator).append("\t<meta name=\"author\" content=\"").append(userName).append('\"').append(closingTag);
                    buff.append(lineSeparator).append("\t<!-- Date: ").append(dateString).append(" -->");
                    buff.append(lineSeparator).append("</head>");
                    buff.append(lineSeparator).append("<body>");
                    buff.append(lineSeparator).append(lineSeparator);
                    buff.append(lineSeparator).append("</body>");
                    buff.append(lineSeparator).append("</html>");
                }
                this._html = buff.toString();
            }
            return this._html;
        }

        int getTemplateIndex() {
            return this._templateIndex;
        }
    }

    private static class FluffyLayout
    extends AbstractLayout {
        private static final List<String> RESERVED_FLUFFY_PREFIX_PATHS = Arrays.asList("");
        private static final List<String> RESERVED_FLUFFY_RESOURCE_PATHS = Arrays.asList("components");
        private static final List<String> RESERVED_FLUFFY_SOURCE_PATHS = Arrays.asList("Sources", "Tests", "src");
        private static final List<String> RESERVED_ROOT_PATHS = Arrays.asList("bin", "build", "resources", "lib", "libraries", "webserverresources", "woproject");

        private FluffyLayout() {
        }

        @Override
        protected List<String> reservedJavaSourcePaths() {
            return RESERVED_FLUFFY_SOURCE_PATHS;
        }

        @Override
        protected List<String> reservedPathPrefixes() {
            return RESERVED_FLUFFY_PREFIX_PATHS;
        }

        @Override
        protected List<String> reservedPathRejects() {
            return RESERVED_ROOT_PATHS;
        }

        @Override
        protected List<String> reservedResourceSourcePaths() {
            return RESERVED_FLUFFY_RESOURCE_PATHS;
        }
    }

    class FileCreationWorker
    implements IRunnableWithProgress {
        private final IFolder fileContainer;
        private final String fileContents;
        private final String fileExtension;
        private final String fileName;

        public FileCreationWorker(IFolder container, String name, String extension, String initialContents) {
            this.fileContainer = container;
            this.fileName = name;
            this.fileExtension = extension;
            this.fileContents = initialContents == null ? "" : initialContents;
        }

        private IFile createFileHandle(IPath filePath) {
            return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFile(filePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
            try {
                IPath containerPath = this.fileContainer.getFullPath();
                IPath newFilePath = containerPath.addTrailingSeparator().append(this.fileName + "." + this.fileExtension);
                IFile newFileHandle = this.createFileHandle(newFilePath);
                try {
                    ByteArrayInputStream initialContents = new ByteArrayInputStream(this.fileContents.getBytes("UTF-8"));
                    newFileHandle.create((InputStream)initialContents, true, progressMonitor);
                }
                catch (UnsupportedEncodingException e) {
                    throw new InvocationTargetException(e);
                }
                catch (CoreException e) {
                    System.err.println(this.getClass().getName() + ".run(IProgressMonitor) Creating file failed..." + e.getLocalizedMessage());
                    e.printStackTrace(System.err);
                    IDEWorkbenchPlugin.log(this.getClass(), (String)"run(IProgressMonitor)", (Throwable)e.getCause());
                    MessageDialog.openError((Shell)NewComponentCreationPage.this.getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getMessage()));
                }
            }
            finally {
                progressMonitor.worked(1);
            }
        }
    }

    class ComponentContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        ComponentContainerFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewComponentCreationPage.this.componentContainerChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            NewComponentCreationPage.this.componentContainerDialogFieldChanged(field);
        }
    }

    class ButtonSelectionAdaptor
    implements SelectionListener {
        ButtonSelectionAdaptor() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            NewComponentCreationPage.this.handleSelectionEvent(event);
        }

        public void widgetSelected(SelectionEvent event) {
            NewComponentCreationPage.this.handleSelectionEvent(event);
        }
    }

    private static abstract class AbstractLayout {
        private AbstractLayout() {
        }

        public final boolean isReservedJavaSourcesPath(IPath path) {
            return this.isReservedPath(path, this.reservedPathPrefixes(), this.reservedJavaSourcePaths());
        }

        private boolean isReservedPath(IPath path, List<String> prefixes, List<String> reservedPaths) {
            if (path != null) {
                IPath relPath = path.makeAbsolute().makeRelative().removeFirstSegments(1);
                String relPathString = relPath.toString().toLowerCase();
                for (String reject : this.reservedPathRejects()) {
                    if (!relPathString.startsWith(reject.toLowerCase())) continue;
                    return true;
                }
                for (String prefix : prefixes) {
                    for (String reservedPath : reservedPaths) {
                        if (!relPathString.startsWith((prefix + reservedPath).toLowerCase())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public final boolean isReservedResourcesPath(IPath path) {
            return this.isReservedPath(path, this.reservedPathPrefixes(), this.reservedResourceSourcePaths());
        }

        protected abstract List<String> reservedJavaSourcePaths();

        protected abstract List<String> reservedPathPrefixes();

        protected abstract List<String> reservedPathRejects();

        protected abstract List<String> reservedResourceSourcePaths();
    }
}

