/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewLinkPage;
import org.objectstyle.wolips.wizards.Messages;

public class WOFrameworkSupportPage
extends WizardNewLinkPage {
    public static final String JNDI_STRING = Messages.getString("WOFrameworkSupportPage.checkbox.jndi.label");
    public static final String J2EE_STRING = Messages.getString("WOFrameworkSupportPage.checkbox.j2ee.label");
    public static final String JNDI_OPTIONS_STRING = Messages.getString("WOFrameworkSupportPage.options.jndi.text");
    public static final String J2EE_OPTIONS_STRING = Messages.getString("WOFrameworkSupportPage.options.j2ee.text");
    Button jndiSupportButton;
    Button j2eeDeploymentButton;
    static boolean jndiAdaptorEnabled = false;
    static boolean j2eeDeploymentEnabled = false;
    static CheckBoxListener checkboxListener;

    public WOFrameworkSupportPage(String pageName, int type) {
        super(pageName, type);
        checkboxListener = new CheckBoxListener();
        jndiAdaptorEnabled = false;
        j2eeDeploymentEnabled = false;
    }

    public boolean getJNDISupport() {
        return jndiAdaptorEnabled;
    }

    public boolean getJ2EESupport() {
        return j2eeDeploymentEnabled;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(font);
        Group jndiGroup = new Group(topLevel, 4);
        GridLayout clientlayout = new GridLayout();
        jndiGroup.setLayout((Layout)clientlayout);
        jndiGroup.setLayoutData((Object)new GridData(768));
        jndiGroup.setText(JNDI_OPTIONS_STRING);
        jndiGroup.setFont(topLevel.getFont());
        this.jndiSupportButton = new Button((Composite)jndiGroup, 32);
        this.jndiSupportButton.setText(JNDI_STRING);
        this.jndiSupportButton.setSelection(false);
        this.jndiSupportButton.addSelectionListener((SelectionListener)checkboxListener);
        Group j2eeGroup = new Group(topLevel, 4);
        GridLayout serverlayout = new GridLayout();
        j2eeGroup.setLayout((Layout)serverlayout);
        j2eeGroup.setLayoutData((Object)new GridData(768));
        j2eeGroup.setText(J2EE_OPTIONS_STRING);
        j2eeGroup.setFont(topLevel.getFont());
        this.j2eeDeploymentButton = new Button((Composite)j2eeGroup, 32);
        this.j2eeDeploymentButton.setText(J2EE_STRING);
        this.j2eeDeploymentButton.setSelection(false);
        this.j2eeDeploymentButton.addSelectionListener((SelectionListener)checkboxListener);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    public boolean handleUpdatedSelection(SelectionEvent e) {
        Button s = (Button)e.getSource();
        if (s.equals(this.jndiSupportButton)) {
            jndiAdaptorEnabled = s.getSelection();
        } else if (s.equals(this.j2eeDeploymentButton)) {
            j2eeDeploymentEnabled = s.getSelection();
        }
        return true;
    }

    class CheckBoxListener
    extends SelectionAdapter {
        CheckBoxListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            WOFrameworkSupportPage.this.handleUpdatedSelection(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            WOFrameworkSupportPage.this.handleUpdatedSelection(e);
        }
    }
}

