/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforuiplugins.utils.WorkbenchUtilities;
import org.objectstyle.wolips.wizards.WizardsPlugin;

public abstract class AbstractOpenWizardAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IStructuredSelection currentSelection;

    protected AbstractOpenWizardAction() {
    }

    public void run() {
        Shell shell = WorkbenchUtilities.getActiveWorkbenchShell();
        try {
            INewWizard wizard = this.createWizard();
            wizard.init(PlatformUI.getWorkbench(), this.currentSelection);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
        catch (CoreException e) {
            WizardsPlugin.getDefault().log(e);
        }
    }

    protected abstract INewWizard createWizard() throws CoreException;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection != null && selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }
}

