/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.wizards.EOModelCreator;
import org.objectstyle.wolips.wizards.Messages;
import org.objectstyle.wolips.wizards.WizardNewWOResourcePage;

public class EOModelCreationPage
extends WizardNewWOResourcePage {
    private IResource _resourceToReveal;
    private Button _createEOGeneratorFileButton;
    private Combo _pluginCombo;
    private Combo _adaptorCombo;

    public EOModelCreationPage(IStructuredSelection selection) {
        super("createEOModelPage1", selection);
        this.setTitle(Messages.getString("EOModelCreationPage.title"));
        this.setDescription(Messages.getString("EOModelCreationPage.description"));
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected IStatus validateLinkedResource() {
        return Status.OK_STATUS;
    }

    public void createControl(Composite parent) {
        IContainer resource;
        super.createControl(parent);
        ProjectAdapter projectAdapter = (ProjectAdapter)this.getProject().getAdapter(ProjectAdapter.class);
        if (projectAdapter != null && !projectAdapter.isResourceContainer(resource = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(this.getContainerFullPath()))) {
            this.setContainerFullPath(projectAdapter.getDefaultResourcesFolder().getFullPath());
        }
        Composite composite = (Composite)this.getControl();
        this.setFileName(Messages.getString("EOModelCreationPage.newEOModel.defaultName"));
        Group modelConfigurationGroup = new Group(composite, 0);
        modelConfigurationGroup.setLayout((Layout)new GridLayout(2, false));
        modelConfigurationGroup.setText("Options");
        modelConfigurationGroup.setLayoutData((Object)new GridData(768));
        ProjectFrameworkAdapter projectFrameworkAdapter = (ProjectFrameworkAdapter)this.getProject().getAdapter(ProjectFrameworkAdapter.class);
        Label adaptorLabel = new Label((Composite)modelConfigurationGroup, 0);
        adaptorLabel.setText("Adaptor:");
        this._adaptorCombo = new Combo((Composite)modelConfigurationGroup, 8);
        this._adaptorCombo.add("None");
        int selectedIndex = 0;
        int index = 0;
        for (Object pluginName : projectFrameworkAdapter.getAdaptorFrameworks().keySet()) {
            this._adaptorCombo.add((String)pluginName);
            if ("JDBC".equals(pluginName)) {
                selectedIndex = index;
            }
            ++index;
        }
        this._adaptorCombo.select(selectedIndex + 1);
        Label pluginLabel = new Label((Composite)modelConfigurationGroup, 0);
        pluginLabel.setText("PlugIn:");
        this._pluginCombo = new Combo((Composite)modelConfigurationGroup, 8);
        this._pluginCombo.add("None");
        for (String pluginName : projectFrameworkAdapter.getPluginFrameworks().keySet()) {
            this._pluginCombo.add(pluginName);
        }
        this._pluginCombo.select(0);
        this._createEOGeneratorFileButton = new Button((Composite)modelConfigurationGroup, 32);
        this._createEOGeneratorFileButton.setText("Use EOGenerator");
        this._createEOGeneratorFileButton.setSelection(true);
        GridData eogenData = new GridData();
        eogenData.horizontalSpan = 2;
        this._createEOGeneratorFileButton.setLayoutData((Object)eogenData);
        this.setPageComplete(this.validatePage());
    }

    public boolean createEOModel() {
        EOModelCreator modelCreator;
        String modelName = this.getFileName();
        boolean createEOGeneratorFile = this._createEOGeneratorFileButton.getSelection();
        String adaptorName = this._adaptorCombo.getItem(this._adaptorCombo.getSelectionIndex());
        String pluginName = this._pluginCombo.getItem(this._pluginCombo.getSelectionIndex());
        switch (this.getContainerFullPath().segmentCount()) {
            case 0: {
                this.setErrorMessage("unknown error");
                return false;
            }
            case 1: {
                modelCreator = new EOModelCreator((IResource)this.getProject(), modelName, adaptorName, pluginName, createEOGeneratorFile, this);
                break;
            }
            default: {
                IFolder subprojectFolder = this.getProject().getFolder(this.getContainerFullPath().removeFirstSegments(1));
                modelCreator = new EOModelCreator((IResource)subprojectFolder, modelName, adaptorName, pluginName, createEOGeneratorFile, this);
            }
        }
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)modelCreator);
        return this.createResourceOperation((IRunnableWithProgress)op);
    }

    protected String getNewFileLabel() {
        return Messages.getString("EOModelCreationPage.newEOModel.label");
    }

    public IResource getResourceToReveal() {
        return this._resourceToReveal;
    }

    public void setResourceToReveal(IResource resourceToReveal) {
        this._resourceToReveal = resourceToReveal;
    }

    public IProject getProject() {
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath == null) {
            ErrorUtils.openErrorDialog((Shell)this.getShell(), (String)"No Folder Selectd", (String)"You must select a folder to create a new EOModel.");
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(containerFullPath.segment(0));
        return project;
    }
}

