/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.objectstyle.wolips.wizards.Messages;
import org.objectstyle.wolips.wizards.NewComponentCreationPage;
import org.objectstyle.wolips.wizards.WizardsPlugin;

public class NewComponentCreationWizard
extends NewElementWizard {
    private boolean fOpenEditorOnFinish;
    private NewComponentCreationPage fPage;

    public NewComponentCreationWizard() {
        this(null, true);
    }

    public NewComponentCreationWizard(NewComponentCreationPage page, boolean openEditorOnFinish) {
        this.setDefaultPageImageDescriptor(WizardsPlugin.WOCOMPONENT_CONTROLLER_WIZARD_BANNER());
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(Messages.getString("WOComponentCreationWizard.title"));
        this.fPage = page;
        this.fOpenEditorOnFinish = openEditorOnFinish;
    }

    public void addPages() {
        super.addPages();
        if (this.fPage == null) {
            this.fPage = new NewComponentCreationPage();
            this.fPage.init(this.getSelection());
        }
        this.addPage((IWizardPage)this.fPage);
    }

    protected boolean canRunForked() {
        return !this.fPage.isEnclosingTypeSelected();
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createType(monitor);
    }

    public IJavaElement getCreatedElement() {
        return this.fPage.getCreatedType();
    }

    public boolean performFinish() {
        IResource resource;
        this.warnAboutTypeCommentDeprecation();
        boolean result = super.performFinish();
        if (result && (resource = this.fPage.getModifiedResource()) != null) {
            this.selectAndReveal(resource);
            if (this.fOpenEditorOnFinish) {
                this.openResource((IFile)resource);
            }
        }
        return result;
    }
}

