/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.components.input;

import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.part.MultiEditorInput;
import org.objectstyle.wolips.components.ComponentsPlugin;
import org.objectstyle.wolips.components.input.ComponentEditorFileEditorInput;
import org.objectstyle.wolips.components.input.ComponentEditorInputFactory;
import org.objectstyle.wolips.editors.EditorsPlugin;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;

public class ComponentEditorInput
extends MultiEditorInput
implements IPersistableElement {
    private boolean displayHtmlPartOnReveal = true;
    private boolean displayWodPartOnReveal = false;
    private boolean displayApiPartOnReveal = false;
    private boolean displayWooPartOnReveal = false;
    private LocalizedComponentsLocateResult localizedComponentsLocateResult;
    private IEditorInput[] componentEditors;
    private IEditorInput apiEditor;
    private IEditorInput standaloneHtmlEditor;
    private String name;

    public ComponentEditorInput(String name, String[] allEditorIDs, IEditorInput[] allInnerEditors, IEditorInput[] componentEditors, IEditorInput apiEditor, IEditorInput standaloneHtmlEditor) {
        super(allEditorIDs, allInnerEditors);
        this.name = name;
        this.componentEditors = componentEditors;
        this.apiEditor = apiEditor;
        this.standaloneHtmlEditor = standaloneHtmlEditor;
    }

    private static ComponentEditorInput create(IFile originalFile, LocalizedComponentsLocateResult localizedComponentsLocateResult) throws CoreException {
        LinkedList<IFolder> validFolders = new LinkedList<IFolder>();
        for (IFolder folder : localizedComponentsLocateResult.getComponents()) {
            if (folder.members().length <= 0) continue;
            validFolders.add(folder);
        }
        IFolder[] folder = validFolders.toArray(new IFolder[validFolders.size()]);
        int folderCountTimesThree = folder.length * 3;
        String[] allIds = null;
        ComponentEditorFileEditorInput[] allInput = null;
        ComponentEditorFileEditorInput[] allComponentInput = null;
        ComponentEditorFileEditorInput apiInput = null;
        allIds = new String[folderCountTimesThree + 1];
        allInput = new ComponentEditorFileEditorInput[folderCountTimesThree + 1];
        allComponentInput = new ComponentEditorFileEditorInput[folderCountTimesThree];
        int inputNum = 0;
        IFile htmlFile = null;
        IFile wodFile = null;
        IFile wooFile = null;
        for (int i = 0; i < folder.length; ++i) {
            IFolder currentFolder = folder[i];
            htmlFile = LocalizedComponentsLocateResult.getHtml((IFolder)currentFolder);
            if (htmlFile == null) {
                htmlFile = currentFolder.getFile(localizedComponentsLocateResult.getName() + ".html");
            }
            if ((wodFile = LocalizedComponentsLocateResult.getWod((IFolder)currentFolder)) == null) {
                wodFile = currentFolder.getFile(localizedComponentsLocateResult.getName() + ".wod");
            }
            if ((wooFile = LocalizedComponentsLocateResult.getWoo((IFolder)currentFolder)) == null) {
                wooFile = currentFolder.getFile(localizedComponentsLocateResult.getName() + ".woo");
            }
            allIds[inputNum] = EditorsPlugin.HTMLEditorID;
            allInput[inputNum] = new ComponentEditorFileEditorInput(htmlFile);
            allComponentInput[inputNum] = allInput[inputNum];
            allIds[++inputNum] = EditorsPlugin.WodEditorID;
            allInput[inputNum] = new ComponentEditorFileEditorInput(wodFile);
            allComponentInput[inputNum] = allInput[inputNum];
            allIds[++inputNum] = EditorsPlugin.WooEditorID;
            allInput[inputNum] = new ComponentEditorFileEditorInput(wooFile);
            allComponentInput[inputNum] = allInput[inputNum];
            ++inputNum;
        }
        String name = localizedComponentsLocateResult.getName();
        if (localizedComponentsLocateResult.getDotApi() != null) {
            allIds[inputNum] = EditorsPlugin.ApiEditorID;
            allInput[inputNum] = new ComponentEditorFileEditorInput(localizedComponentsLocateResult.getDotApi());
            apiInput = allInput[inputNum];
        } else {
            allIds[inputNum] = EditorsPlugin.ApiEditorID;
            IFile referenceFile = wodFile;
            if (referenceFile == null) {
                referenceFile = htmlFile;
            }
            if (referenceFile != null) {
                IFile api = wodFile.getParent().getParent().getFile((IPath)new Path(name + ".api"));
                allInput[inputNum] = new ComponentEditorFileEditorInput(api);
                apiInput = allInput[inputNum];
            }
        }
        ComponentEditorFileEditorInput standaloneHtmlInput = null;
        if (allComponentInput.length == 0 && apiInput == null && originalFile.getName().toLowerCase().endsWith(".html")) {
            standaloneHtmlInput = new ComponentEditorFileEditorInput(originalFile);
            name = originalFile.getName();
        }
        ComponentEditorInput input = new ComponentEditorInput(name, allIds, (IEditorInput[])allInput, (IEditorInput[])allComponentInput, (IEditorInput)apiInput, (IEditorInput)standaloneHtmlInput);
        input.localizedComponentsLocateResult = localizedComponentsLocateResult;
        for (int i = 0; i < allInput.length; ++i) {
            ComponentEditorFileEditorInput componentEditorFileEditorInput = allInput[i];
            if (componentEditorFileEditorInput == null) continue;
            componentEditorFileEditorInput.setComponentEditorInput(input);
        }
        return input;
    }

    public String getName() {
        String inputName = this.name;
        if (inputName == null) {
            inputName = this.standaloneHtmlEditor != null ? this.standaloneHtmlEditor.getName() : "Unknown Component";
        }
        return inputName;
    }

    private static ComponentEditorInput create(IFile file) throws CoreException {
        LocalizedComponentsLocateResult localizedComponentsLocateResult = null;
        try {
            localizedComponentsLocateResult = LocatePlugin.getDefault().getLocalizedComponentsLocateResult((IResource)file);
        }
        catch (CoreException e) {
            ComponentsPlugin.getDefault().log(e);
            return null;
        }
        catch (LocateException e) {
            ComponentsPlugin.getDefault().log(e);
            return null;
        }
        ComponentEditorInput input = ComponentEditorInput.create(file, localizedComponentsLocateResult);
        return input;
    }

    public static ComponentEditorInput createWithDotHtml(IFile file) throws CoreException {
        ComponentEditorInput input = ComponentEditorInput.create(file);
        if (input != null) {
            input.displayHtmlPartOnReveal = true;
        }
        return input;
    }

    public static ComponentEditorInput createWithDotWod(IFile file) throws CoreException {
        ComponentEditorInput input = ComponentEditorInput.create(file);
        if (input != null) {
            input.displayWodPartOnReveal = true;
        }
        return input;
    }

    public static ComponentEditorInput createWithDotApi(IFile file) throws CoreException {
        ComponentEditorInput input = ComponentEditorInput.create(file);
        if (input != null) {
            input.displayApiPartOnReveal = true;
        }
        return input;
    }

    public static ComponentEditorInput createWithDotWoo(IFile file) throws CoreException {
        ComponentEditorInput input = ComponentEditorInput.create(file);
        if (input != null) {
            input.displayWooPartOnReveal = true;
        }
        return input;
    }

    public static String getLanguageName(IFileEditorInput editorInput) {
        String language = null;
        if (editorInput != null) {
            IFile file = editorInput.getFile();
            language = ComponentEditorInput.getLanguageName(file);
        }
        return language;
    }

    public static String getLanguageName(IFile file) {
        String language = null;
        if (file != null && file.exists()) {
            IFile resource = file;
            boolean done = false;
            do {
                if ((resource = resource.getParent()) == null) {
                    done = true;
                    continue;
                }
                String name = resource.getName();
                if (!name.endsWith(".lproj")) continue;
                language = name.substring(0, name.lastIndexOf(46));
                done = true;
            } while (!done);
        }
        return language;
    }

    public LocalizedComponentsLocateResult getLocalizedComponentsLocateResult() {
        return this.localizedComponentsLocateResult;
    }

    public String getFactoryId() {
        return ComponentEditorInputFactory.ID_FACTORY;
    }

    public void saveState(IMemento memento) {
        ComponentEditorInputFactory.saveState(memento, this);
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public boolean isDisplayApiPartOnReveal() {
        return this.displayApiPartOnReveal;
    }

    public void setDisplayApiPartOnReveal(boolean displayApiPartOnReveal) {
        this.displayApiPartOnReveal = displayApiPartOnReveal;
    }

    public boolean isDisplayHtmlPartOnReveal() {
        return this.displayHtmlPartOnReveal;
    }

    public void setDisplayHtmlPartOnReveal(boolean displayHtmlPartOnReveal) {
        this.displayHtmlPartOnReveal = displayHtmlPartOnReveal;
    }

    public boolean isDisplayWodPartOnReveal() {
        return this.displayWodPartOnReveal;
    }

    public void setDisplayWodPartOnReveal(boolean displayWodPartOnReveal) {
        this.displayWodPartOnReveal = displayWodPartOnReveal;
    }

    public boolean isDisplayWooPartOnReveal() {
        return this.displayWooPartOnReveal;
    }

    public void setDisplayWooPartOnReveal(boolean displayWooPartOnReveal) {
        this.displayWooPartOnReveal = displayWooPartOnReveal;
    }

    public IEditorInput getApiEditor() {
        return this.apiEditor;
    }

    public IEditorInput getStandaloneHtmlEditor() {
        return this.standaloneHtmlEditor;
    }

    public IEditorInput[] getComponentEditors() {
        return this.componentEditors;
    }

    public int hashCode() {
        int hash = 0;
        String[] editors = this.getEditors();
        for (int i = 0; i < editors.length; ++i) {
            if (editors[i] == null) continue;
            hash = hash * 37 + editors[i].hashCode();
        }
        IEditorInput[] input = this.getInput();
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            hash = hash * 37 + input[i].hashCode();
        }
        return hash;
    }
}

