/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.objectstyle.wolips.builder.internal.BuildHelper;
import org.objectstyle.wolips.core.resources.types.project.IProjectPatternsets;

public class JarBuilder
extends BuildHelper {
    @Override
    public boolean handleResource(IResource resource, IResourceDelta delta) throws CoreException {
        IPath path;
        IPath outPath = this.getJavaOutputPath();
        IPath compilerOutPath = this.getJavaProject().getOutputLocation();
        int baseSegments = compilerOutPath.segmentCount();
        IProjectPatternsets adaptedProject = (IProjectPatternsets)this.getProject().getAdapter(IProjectPatternsets.class);
        if (adaptedProject.matchesClassesPattern(resource) && compilerOutPath.isPrefixOf(path = resource.getFullPath()) && !outPath.isPrefixOf(path)) {
            IPath cp = path.removeFirstSegments(baseSegments);
            path = outPath.append(cp);
            if (null != delta && delta.getKind() == 2) {
                this.addTask(new BuildHelper.DeleteTask(path, "jar"));
                this._getLogger().debug((Object)("delete: " + path.toString()));
            } else {
                this.addTask(new BuildHelper.CopyTask(resource, path, "jar"));
                this._getLogger().debug((Object)("copy: " + path.toString()));
            }
        }
        return true;
    }
}

