/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public abstract class AbstractBaseActivator
extends Plugin {
    private ResourceBundle resourceBundle;
    private static AbstractBaseActivator Plugin;
    private boolean debug = false;
    private String bundleID;

    public AbstractBaseActivator() {
        Plugin = this;
    }

    public final String getBundleID() {
        if (this.bundleID == null) {
            this.bundleID = ((Object)((Object)this)).getClass().getName() + "Resources";
        }
        return this.bundleID;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.resourceBundle = null;
    }

    public static final String getResourceString(String key) {
        ResourceBundle bundle = Plugin.getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public final ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle(this.getBundleID());
            }
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(Object message) {
        this.log((IStatus)new Status(4, this.getBundleID(), 4, "" + message, null));
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, this.getBundleID(), 4, "Internal Error", e));
    }

    public void log(Object message, Throwable e) {
        this.log((IStatus)new Status(4, this.getBundleID(), 4, "" + message, e));
    }

    public void debug(Throwable aThrowable) {
        if (this.debug) {
            this.log((IStatus)new Status(2, this.getBundleID(), 2, aThrowable.getMessage(), aThrowable));
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.debug) {
            this.log((IStatus)new Status(2, this.getBundleID(), 2, "" + message, t));
        }
    }

    public void debug(Object message) {
        if (this.debug) {
            this.log((IStatus)new Status(2, this.getBundleID(), 2, "" + message, null));
        }
    }
}

