/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.ui.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.JdtPlugin;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.ui.UIPlugin;
import org.objectstyle.wolips.ui.propertypages.WOLipsPropertyPage;
import org.objectstyle.wolips.variables.BuildProperties;

public class WOLipsDeploymentPropertyPage
extends WOLipsPropertyPage {
    private Button _servletDeploymentCheck;
    private Button _generateWebXMLCheck;
    private Map<Root, Button> _embedButtons;
    private Text _customInfoPListText;
    private Text _customWebXMLText;
    private Button _javaClientButton;
    private Button _javaWebStartButton;

    private void _addEmbedSettingsSection(Composite parent, ProjectAdapter project) {
        Composite embedGroup = this._createGroupWithLabel(parent, "Embed Frameworks");
        embedGroup.setLayout((Layout)new GridLayout(1, false));
        this._embedButtons = new HashMap<Root, Button>();
        for (Root root : JdtPlugin.getDefault().getFrameworkModel(project.getUnderlyingProject()).getRoots()) {
            Button embedButton = new Button(embedGroup, 16416);
            embedButton.setText(root.getName());
            embedButton.setEnabled(true);
            embedButton.setSelection(this.getBuildProperties().isEmbed(root));
            embedButton.setLayoutData((Object)new GridData(768));
            this._embedButtons.put(root, embedButton);
        }
    }

    private void _addCustomInfoPListSettingsSection(Composite parent, ProjectAdapter project) {
        BuildProperties buildProperties;
        Composite customInfoPListGroup = this._createGroupWithLabel(parent, "Custom Info.plist");
        customInfoPListGroup.setLayout((Layout)new GridLayout(2, false));
        this._customInfoPListText = this._addTextArea(customInfoPListGroup, null);
        if (project != null && (buildProperties = this.getBuildProperties()) != null) {
            this._customInfoPListText.setText(buildProperties.getCustomInfoPListContent(true));
        }
    }

    private void _addJavaClientSection(Composite parent) {
        Composite javaClientGroup = this._createGroupWithLabel(parent, "Java Client");
        javaClientGroup.setLayout((Layout)new GridLayout(1, false));
        this._javaClientButton = new Button(javaClientGroup, 16416);
        this._javaClientButton.setText("Java Client");
        this._javaClientButton.setEnabled(true);
        this._javaClientButton.setSelection(this.getBuildProperties().isJavaClient());
        this._javaClientButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WOLipsDeploymentPropertyPage.this.enableWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._javaWebStartButton = new Button(javaClientGroup, 16416);
        this._javaWebStartButton.setText("Java WebStart");
        this._javaWebStartButton.setEnabled(true);
        this._javaWebStartButton.setSelection(this.getBuildProperties().isJavaWebStart());
    }

    private void _addServletDeploymentSection(Composite parent) {
        Composite group = this._createGroupWithLabel(parent, "Servlet Deployment");
        group.setLayout((Layout)new GridLayout(2, false));
        this._servletDeploymentCheck = new Button(group, 16416);
        GridData servletDeploymentData = new GridData();
        servletDeploymentData.horizontalSpan = 2;
        this._servletDeploymentCheck.setLayoutData((Object)servletDeploymentData);
        this._servletDeploymentCheck.setText("Servlet Deployment");
        this._servletDeploymentCheck.setEnabled(true);
        this._servletDeploymentCheck.setSelection(this.getBuildProperties().isServletDeployment());
        this._servletDeploymentCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WOLipsDeploymentPropertyPage.this.enableWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._generateWebXMLCheck = new Button(group, 16416);
        GridData generateWebXmlData = new GridData();
        generateWebXmlData.horizontalSpan = 2;
        this._generateWebXMLCheck.setLayoutData((Object)generateWebXmlData);
        this._generateWebXMLCheck.setText("Autogenerate web.xml");
        this._generateWebXMLCheck.setEnabled(true);
        this._generateWebXMLCheck.setSelection(this.getBuildProperties().getWebXML());
        this._generateWebXMLCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WOLipsDeploymentPropertyPage.this.enableWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._customWebXMLText = this._addTextArea(group, "Custom web.xml");
        this._customWebXMLText.setText(this.getBuildProperties().getWebXML_CustomContent(true));
    }

    protected void enableWidgets() {
        this._customInfoPListText.setEnabled(true);
        if (this.getProjectAdapter() != null) {
            boolean isApplication = this.getProjectAdapter().isApplication();
            this._servletDeploymentCheck.setEnabled(isApplication);
            this._generateWebXMLCheck.setEnabled(isApplication && this._servletDeploymentCheck.getSelection());
            this._customWebXMLText.setEnabled(isApplication && this._servletDeploymentCheck.getSelection() && !this._generateWebXMLCheck.getSelection());
            for (Button embedButton : this._embedButtons.values()) {
                embedButton.setEnabled(isApplication && !this._servletDeploymentCheck.getSelection());
            }
            this._javaWebStartButton.setEnabled(this._javaClientButton.getSelection());
        }
    }

    @Override
    protected void _createContents(Composite parent, ProjectAdapter projectAdapter, boolean isWOProject) {
        this._addCustomInfoPListSettingsSection(parent, projectAdapter);
        this._addServletDeploymentSection(parent);
        this._addJavaClientSection(parent);
        this._addEmbedSettingsSection(parent, projectAdapter);
        this.enableWidgets();
    }

    @Override
    protected void setDefaults(ProjectAdapter project) {
        String customInfoPListContent = this.getBuildProperties().getCustomInfoPListContent(true);
        if (customInfoPListContent != null) {
            this._customInfoPListText.setText(customInfoPListContent);
        }
        this._customWebXMLText.setText("");
        this._servletDeploymentCheck.setSelection(false);
        this._generateWebXMLCheck.setSelection(false);
    }

    public boolean performOk() {
        try {
            ProjectAdapter projectAdapter = this.getProjectAdapter();
            if (projectAdapter != null) {
                BuildProperties buildProperties = this.getBuildProperties();
                buildProperties.setCustomInfoPListContent(this._customInfoPListText.getText());
                buildProperties.setServletDeployment(this._servletDeploymentCheck.getSelection());
                buildProperties.setWebXML(this._generateWebXMLCheck.getSelection());
                buildProperties.setWebXML_CustomContent(this._customWebXMLText.getText());
                ProjectFrameworkAdapter projectFrameworkAdapter = this.getProjectFrameworkAdapter();
                if (buildProperties.isServletDeployment()) {
                    projectFrameworkAdapter.addFrameworkNamed("JavaWOJSPServlet");
                } else {
                    projectFrameworkAdapter.removeFrameworkNamed("JavaWOJSPServlet");
                }
                for (Root root : this._embedButtons.keySet()) {
                    Button embedButton = this._embedButtons.get(root);
                    boolean embed = buildProperties.isServletDeployment() || embedButton.isEnabled() && embedButton.getSelection();
                    buildProperties.setEmbed(root, embed);
                }
                buildProperties.setJavaClient(this._javaClientButton.getSelection());
                buildProperties.setJavaWebStart(this._javaClientButton.getSelection() && this._javaWebStartButton.getSelection());
                buildProperties.save();
            }
        }
        catch (Exception up) {
            UIPlugin.getDefault().log(up);
            return false;
        }
        return true;
    }
}

