/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.ui.propertypages;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.objectstyle.wolips.baseforplugins.util.WOLipsNatureUtils;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.ui.UIPlugin;
import org.objectstyle.wolips.ui.propertypages.WOLipsPropertyPage;
import org.objectstyle.wolips.variables.BuildProperties;

public class WOLipsDevelopmentPropertyPage
extends WOLipsPropertyPage {
    private static final String BUILD_STYLE_TITLE = "Build Style";
    private static final String PROJECT_KIND_TITLE = "Bundle Settings";
    private static final String WO_NATURE_TITLE = "WebObjects Project";
    private static final String WO_IS_FRAMEWORK_TITLE = "Framework";
    private static final String WO_IS_APP_TITLE = "Application";
    private static final String WO_USE_INCREMENTAL_TITLE = "Incremental";
    private static final String WO_USE_ANT_TITLE = "Ant (build.xml)";
    private static final String WO_USE_TARGET_BUILDER_TITLE = "Use Target Builder for JavaClient";
    private Button _useTargetBuilderCheck;
    private Button _webObjectsProjectCheck;
    private Button _buildStyleAntButton;
    private Button _buildStyleIncrementalButton;
    private Button _bundleTypeFrameworkButton;
    private Button _bundleTypeApplicationButton;
    private Button _wellFormedRequiredButton;
    private Text _inlineBindingsPrefixText;
    private Text _inlineBindingsSuffixText;
    private Text _principalClassText;
    private Text _eoAdaptorClassText;
    private Text _projectFrameworkFolderText;

    private void _addWOProjectSection(Composite parent, boolean isWOProject) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this._webObjectsProjectCheck = new Button(group, 16416);
        this._webObjectsProjectCheck.setText(WO_NATURE_TITLE);
        this._webObjectsProjectCheck.setEnabled(true);
        this._webObjectsProjectCheck.setSelection(isWOProject);
        this._webObjectsProjectCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WOLipsDevelopmentPropertyPage.this.enableWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void _addBuildStyleSection(Composite parent, ProjectAdapter project) {
        boolean isIncremental;
        Composite buildStyleGroup = this._createGroupWithLabel(parent, BUILD_STYLE_TITLE);
        this._buildStyleIncrementalButton = new Button(buildStyleGroup, 16400);
        this._buildStyleIncrementalButton.setText(WO_USE_INCREMENTAL_TITLE);
        this._buildStyleIncrementalButton.setEnabled(true);
        FormData incrementalLayoutData = new FormData();
        incrementalLayoutData.left = new FormAttachment(0, 0);
        this._buildStyleIncrementalButton.setLayoutData((Object)incrementalLayoutData);
        this._buildStyleIncrementalButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WOLipsDevelopmentPropertyPage.this.enableWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._buildStyleAntButton = new Button(buildStyleGroup, 16400);
        this._buildStyleAntButton.setText(WO_USE_ANT_TITLE);
        this._buildStyleAntButton.setEnabled(true);
        FormData antLayoutData = new FormData();
        antLayoutData.top = new FormAttachment((Control)this._buildStyleIncrementalButton, 5);
        this._buildStyleAntButton.setLayoutData((Object)antLayoutData);
        boolean bl = isIncremental = project == null || project.isIncrementalBuilderInstalled();
        if (isIncremental) {
            this._buildStyleIncrementalButton.setSelection(true);
        } else {
            this._buildStyleAntButton.setSelection(true);
        }
        this._useTargetBuilderCheck = new Button(buildStyleGroup, 16416);
        this._useTargetBuilderCheck.setText(WO_USE_TARGET_BUILDER_TITLE);
        this._useTargetBuilderCheck.setEnabled(true);
        this._useTargetBuilderCheck.setSelection(project != null && project.isTargetBuilderInstalled());
        FormData targetBuilderData = new FormData();
        targetBuilderData.top = new FormAttachment((Control)this._buildStyleAntButton, 15);
        this._useTargetBuilderCheck.setLayoutData((Object)targetBuilderData);
        Composite textSettingsGroup = new Composite(buildStyleGroup, 0);
        GridLayout textSettingsLayout = new GridLayout(2, false);
        textSettingsLayout.marginLeft = -3;
        textSettingsGroup.setLayout((Layout)textSettingsLayout);
        FormData textSettingsLayoutData = new FormData();
        textSettingsLayoutData.top = new FormAttachment((Control)this._useTargetBuilderCheck, 10);
        textSettingsLayoutData.left = new FormAttachment(0, 0);
        textSettingsLayoutData.right = new FormAttachment(100, 0);
        textSettingsGroup.setLayoutData((Object)textSettingsLayoutData);
        this._projectFrameworkFolderText = this._addTextField(textSettingsGroup, "Framework Folder");
        if (project != null) {
            String projectFrameworkFolder = this.getBuildProperties().getProjectFrameworkFolder();
            if (projectFrameworkFolder == null) {
                projectFrameworkFolder = "";
            }
            this._projectFrameworkFolderText.setText(projectFrameworkFolder);
        }
    }

    private void _addComponentsSection(Composite parent, ProjectAdapter project) {
        Composite componentsGroup = this._createGroupWithLabel(parent, "Components");
        this._wellFormedRequiredButton = new Button(componentsGroup, 16416);
        this._wellFormedRequiredButton.setText("Require well-formed HTML");
        this._wellFormedRequiredButton.setEnabled(true);
        FormData wellFormedLayoutData = new FormData();
        wellFormedLayoutData.left = new FormAttachment(0, 0);
        this._wellFormedRequiredButton.setLayoutData((Object)wellFormedLayoutData);
        this._wellFormedRequiredButton.setSelection(project.getBuildProperties().isWellFormedTemplateRequired());
        this._wellFormedRequiredButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WOLipsDevelopmentPropertyPage.this.enableWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite textSettingsGroup = new Composite(componentsGroup, 0);
        GridLayout textSettingsLayout = new GridLayout(2, false);
        textSettingsLayout.marginLeft = -3;
        textSettingsGroup.setLayout((Layout)textSettingsLayout);
        FormData textSettingsLayoutData = new FormData();
        textSettingsLayoutData.top = new FormAttachment((Control)this._wellFormedRequiredButton, 10);
        textSettingsLayoutData.left = new FormAttachment(0, 0);
        textSettingsLayoutData.right = new FormAttachment(100, 0);
        textSettingsGroup.setLayoutData((Object)textSettingsLayoutData);
        this._inlineBindingsPrefixText = this._addTextField(textSettingsGroup, "Inline Bindings Prefix");
        if (project != null) {
            this._inlineBindingsPrefixText.setText(project.getBuildProperties().getInlineBindingPrefix());
        }
        this._inlineBindingsSuffixText = this._addTextField(textSettingsGroup, "Inline Bindings Suffix");
        if (project != null) {
            this._inlineBindingsSuffixText.setText(project.getBuildProperties().getInlineBindingSuffix());
        }
    }

    private void _addBundleSettingsSection(Composite parent, ProjectAdapter project) {
        boolean isFramework;
        Composite bundleTypeGroup = this._createGroupWithLabel(parent, PROJECT_KIND_TITLE);
        this._bundleTypeApplicationButton = new Button(bundleTypeGroup, 16400);
        this._bundleTypeApplicationButton.setText(WO_IS_APP_TITLE);
        this._bundleTypeApplicationButton.setEnabled(true);
        FormData applicationLayoutData = new FormData();
        applicationLayoutData.left = new FormAttachment(0, 0);
        this._bundleTypeApplicationButton.setLayoutData((Object)applicationLayoutData);
        this._bundleTypeApplicationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WOLipsDevelopmentPropertyPage.this.enableWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._bundleTypeFrameworkButton = new Button(bundleTypeGroup, 16400);
        this._bundleTypeFrameworkButton.setText(WO_IS_FRAMEWORK_TITLE);
        this._bundleTypeFrameworkButton.setEnabled(true);
        FormData frameworkLayoutData = new FormData();
        frameworkLayoutData.top = new FormAttachment((Control)this._bundleTypeApplicationButton, 5);
        this._bundleTypeFrameworkButton.setLayoutData((Object)frameworkLayoutData);
        boolean bl = isFramework = project == null || project.isFramework();
        if (isFramework) {
            this._bundleTypeFrameworkButton.setSelection(true);
        } else {
            this._bundleTypeApplicationButton.setSelection(true);
        }
        Composite textSettingsGroup = new Composite(bundleTypeGroup, 0);
        GridLayout textSettingsLayout = new GridLayout(2, false);
        textSettingsLayout.marginLeft = -3;
        textSettingsGroup.setLayout((Layout)textSettingsLayout);
        FormData textSettingsLayoutData = new FormData();
        textSettingsLayoutData.top = new FormAttachment((Control)this._bundleTypeFrameworkButton, 10);
        textSettingsLayoutData.left = new FormAttachment(0, 0);
        textSettingsLayoutData.right = new FormAttachment(100, 0);
        textSettingsGroup.setLayoutData((Object)textSettingsLayoutData);
        this._principalClassText = this._addTextField(textSettingsGroup, "Principal Class");
        if (project != null) {
            this._principalClassText.setText(project.getBuildProperties().getPrincipalClass(true));
        }
        this._eoAdaptorClassText = this._addTextField(textSettingsGroup, "EOAdaptor Class");
        if (project != null) {
            this._eoAdaptorClassText.setText(project.getBuildProperties().getEOAdaptorClassName(true));
        }
    }

    protected void enableWidgets() {
        this._useTargetBuilderCheck.setEnabled(this._buildStyleIncrementalButton.getSelection());
        this._principalClassText.setEnabled(true);
        this._eoAdaptorClassText.setEnabled(!this._bundleTypeApplicationButton.getSelection());
    }

    @Override
    protected void _createContents(Composite parent, ProjectAdapter projectAdapter, boolean isWOProject) {
        this._addWOProjectSection(parent, isWOProject);
        this._addBundleSettingsSection(parent, projectAdapter);
        this._addComponentsSection(parent, projectAdapter);
        this._addBuildStyleSection(parent, projectAdapter);
        this.enableWidgets();
    }

    @Override
    protected void setDefaults(ProjectAdapter project) {
        Map args = project.getBuilderArgs();
        String string = WOLipsDevelopmentPropertyPage._getArg(args, "nsprincipalclass", "");
        if (string == null || string.length() == 0) {
            string = project.getBuildProperties().getPrincipalClass(true);
        }
        if (string != null) {
            this._principalClassText.setText(string);
        }
        if ((string = project.getBuildProperties().getEOAdaptorClassName(true)) != null) {
            this._eoAdaptorClassText.setText(string);
        }
    }

    public boolean performOk() {
        try {
            boolean useTargetBuilder = this._useTargetBuilderCheck.getSelection();
            if (this._webObjectsProjectCheck.getSelection()) {
                if (this._bundleTypeFrameworkButton.getSelection()) {
                    if (this._buildStyleIncrementalButton.getSelection()) {
                        WOLipsNatureUtils.setNatureForProject((String)"org.objectstyle.wolips.incrementalframeworknature", (boolean)useTargetBuilder, (IProject)this.getProject(), (IProgressMonitor)new NullProgressMonitor());
                    } else if (this._buildStyleAntButton.getSelection()) {
                        WOLipsNatureUtils.setNatureForProject((String)"org.objectstyle.wolips.antframeworknature", (boolean)useTargetBuilder, (IProject)this.getProject(), (IProgressMonitor)new NullProgressMonitor());
                    }
                } else if (this._bundleTypeApplicationButton.getSelection()) {
                    if (this._buildStyleIncrementalButton.getSelection()) {
                        WOLipsNatureUtils.setNatureForProject((String)"org.objectstyle.wolips.incrementalapplicationnature", (boolean)useTargetBuilder, (IProject)this.getProject(), (IProgressMonitor)new NullProgressMonitor());
                    } else if (this._buildStyleAntButton.getSelection()) {
                        WOLipsNatureUtils.setNatureForProject((String)"org.objectstyle.wolips.antapplicationnature", (boolean)useTargetBuilder, (IProject)this.getProject(), (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                ProjectAdapter project = this.getProjectAdapter();
                if (project != null) {
                    BuildProperties buildProperties = this.getBuildProperties();
                    buildProperties.setPrincipalClass(this._principalClassText.getText());
                    buildProperties.setEOAdaptorClassName(this._eoAdaptorClassText.getText());
                    String projectFrameworkFolderText = this._projectFrameworkFolderText.getText();
                    if (projectFrameworkFolderText.length() == 0) {
                        buildProperties.setProjectFrameworkFolder(null);
                    } else {
                        buildProperties.setProjectFrameworkFolder(projectFrameworkFolderText);
                    }
                    buildProperties.setFramework(this._bundleTypeFrameworkButton.getSelection());
                    buildProperties.setWellFormedTemplateRequired(Boolean.valueOf(this._wellFormedRequiredButton.getSelection()));
                    buildProperties.setInlineBindingPrefix(this._inlineBindingsPrefixText.getText());
                    buildProperties.setInlineBindingSuffix(this._inlineBindingsSuffixText.getText());
                    buildProperties.save();
                }
            } else {
                WOLipsNatureUtils.removeNaturesFromProject((IProject)this.getProject(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception up) {
            UIPlugin.getDefault().log(up);
            return false;
        }
        return true;
    }
}

