/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.objectstyle.wolips.eomodeler.core.Activator;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;

public interface IEOClassLoaderFactory {
    public ClassLoader createClassLoaderForModel(EOModel var1) throws EOModelException;

    public static class Utility {
        public static ClassLoader createClassLoader(EOModel model) throws EOModelException {
            LinkedList<IEOClassLoaderFactory> classLoaderFactories = new LinkedList<IEOClassLoaderFactory>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.objectstyle.wolips.eomodeler.eoclassLoaderFactory");
            IExtension[] extensions = extensionPoint.getExtensions();
            ClassLoader finalClassLoader = null;
            for (IExtension extension : extensions) {
                IConfigurationElement[] configurationElements;
                for (IConfigurationElement configurationElement : configurationElements = extension.getConfigurationElements()) {
                    try {
                        IEOClassLoaderFactory classLoaderFactory = (IEOClassLoaderFactory)configurationElement.createExecutableExtension("class");
                        ClassLoader classLoader = classLoaderFactory.createClassLoaderForModel(model);
                        if (classLoader != null) {
                            if (finalClassLoader == null) {
                                finalClassLoader = classLoader;
                            } else {
                                Activator.getDefault().log("There was more than one valid EOF ClassLoader factory defined. The ClassLoader generated by the first one will be used.");
                            }
                        }
                        classLoaderFactories.add(classLoaderFactory);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().log("Could not create EOClassLoader factory from configuration element: " + configurationElement, e);
                    }
                }
            }
            if (finalClassLoader == null) {
                throw new EOModelException("There was no valid EOF ClassLoader factory defined.");
            }
            return finalClassLoader;
        }
    }
}

