/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entity;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.editors.storedProcedures.EOStoredProceduresLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.storedProcedures.EOStoredProceduresListContentProvider;
import org.objectstyle.wolips.eomodeler.utils.ComboViewerBinding;
import org.objectstyle.wolips.eomodeler.utils.FormUtils;

public class EOEntityStoredProceduresEditorSection
extends AbstractPropertySection {
    private EOEntity myEntity;
    private ComboViewer myInsertComboViewer;
    private ComboViewer myDeleteComboViewer;
    private ComboViewer myFetchAllComboViewer;
    private ComboViewer myFetchWithPrimaryKeyComboViewer;
    private ComboViewer myNextPrimaryKeyComboViewer;
    private ComboViewerBinding myInsertBinding;
    private ComboViewerBinding myDeleteBinding;
    private ComboViewerBinding myFetchAllBinding;
    private ComboViewerBinding myFetchWithPrimaryKeyBinding;
    private ComboViewerBinding myNextPrimaryKeyBinding;

    public void createControls(Composite _parent, TabbedPropertySheetPage _tabbedPropertySheetPage) {
        super.createControls(_parent, _tabbedPropertySheetPage);
        Composite form = this.getWidgetFactory().createFlatFormComposite(_parent);
        FormLayout formLayout = new FormLayout();
        form.setLayout((Layout)formLayout);
        Composite topForm = FormUtils.createForm(this.getWidgetFactory(), form);
        this.myInsertComboViewer = this.createStoredProcedureComboViewer(topForm, "insertProcedure");
        this.myDeleteComboViewer = this.createStoredProcedureComboViewer(topForm, "deleteProcedure");
        this.myFetchAllComboViewer = this.createStoredProcedureComboViewer(topForm, "fetchAllProcedure");
        this.myFetchWithPrimaryKeyComboViewer = this.createStoredProcedureComboViewer(topForm, "fetchWithPrimaryKeyProcedure");
        this.myNextPrimaryKeyComboViewer = this.createStoredProcedureComboViewer(topForm, "nextPrimaryKeyProcedure");
    }

    protected ComboViewer createStoredProcedureComboViewer(Composite _parent, String _name) {
        this.getWidgetFactory().createCLabel(_parent, Messages.getString("EOEntity." + _name), 0);
        Combo insertCombo = new Combo(_parent, 0x800808);
        ComboViewer comboViewer = new ComboViewer(insertCombo);
        comboViewer.setLabelProvider((IBaseLabelProvider)new EOStoredProceduresLabelProvider());
        comboViewer.setContentProvider((IContentProvider)new EOStoredProceduresListContentProvider(true));
        GridData comboLayoutData = new GridData(768);
        insertCombo.setLayoutData((Object)comboLayoutData);
        return comboViewer;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (ComparisonUtils.equals((Object)selection, (Object)this.getSelection())) {
            return;
        }
        super.setInput(part, selection);
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        EOEntity entity = (EOEntity)selectedObject;
        if (!ComparisonUtils.equals((Object)entity, (Object)this.myEntity)) {
            this.disposeBindings();
            this.myEntity = entity;
            if (this.myEntity != null) {
                this.myInsertComboViewer.setInput((Object)this.myEntity);
                this.myDeleteComboViewer.setInput((Object)this.myEntity);
                this.myFetchAllComboViewer.setInput((Object)this.myEntity);
                this.myFetchWithPrimaryKeyComboViewer.setInput((Object)this.myEntity);
                this.myNextPrimaryKeyComboViewer.setInput((Object)this.myEntity);
                this.myInsertBinding = new ComboViewerBinding(this.myInsertComboViewer, this.myEntity, "insertProcedure", this.myEntity.getModel(), "storedProcedures", EOStoredProceduresListContentProvider.BLANK_STORED_PROCEDURE);
                this.myDeleteBinding = new ComboViewerBinding(this.myDeleteComboViewer, this.myEntity, "deleteProcedure", this.myEntity.getModel(), "storedProcedures", EOStoredProceduresListContentProvider.BLANK_STORED_PROCEDURE);
                this.myFetchAllBinding = new ComboViewerBinding(this.myFetchAllComboViewer, this.myEntity, "fetchAllProcedure", this.myEntity.getModel(), "storedProcedures", EOStoredProceduresListContentProvider.BLANK_STORED_PROCEDURE);
                this.myFetchWithPrimaryKeyBinding = new ComboViewerBinding(this.myFetchWithPrimaryKeyComboViewer, this.myEntity, "fetchWithPrimaryKeyProcedure", this.myEntity.getModel(), "storedProcedures", EOStoredProceduresListContentProvider.BLANK_STORED_PROCEDURE);
                this.myNextPrimaryKeyBinding = new ComboViewerBinding(this.myNextPrimaryKeyComboViewer, this.myEntity, "nextPrimaryKeyProcedure", this.myEntity.getModel(), "storedProcedures", EOStoredProceduresListContentProvider.BLANK_STORED_PROCEDURE);
            }
        }
    }

    protected void disposeBindings() {
        if (this.myInsertBinding != null) {
            this.myInsertBinding.dispose();
        }
        if (this.myDeleteBinding != null) {
            this.myDeleteBinding.dispose();
        }
        if (this.myFetchAllBinding != null) {
            this.myFetchAllBinding.dispose();
        }
        if (this.myFetchWithPrimaryKeyBinding != null) {
            this.myFetchWithPrimaryKeyBinding.dispose();
        }
        if (this.myNextPrimaryKeyBinding != null) {
            this.myNextPrimaryKeyBinding.dispose();
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeBindings();
    }
}

