/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.templateeditor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.objectstyle.wolips.bindings.api.ApiUtils;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.bindings.wod.TagShortcut;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.templateeditor.InlineWodTagInfo;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.completion.WodCompletionProposal;
import org.objectstyle.wolips.wodclipse.core.completion.WodCompletionUtils;
import org.objectstyle.wolips.wodclipse.core.completion.WodDeprecatedCompletionProposal;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.TagDefinition;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;

public class TemplateAssistProcessor
extends HTMLAssistProcessor {
    private static final int SCOPE = 100;
    private static final int CLASS = 101;
    private List<TagInfo> _tagList;
    private WodParserCache _cache;
    private IFile _file;
    private IEditorPart _editorPart;
    private BuildProperties _buildProperties;

    public TemplateAssistProcessor(IEditorPart editorPart, WodParserCache wodParserCache, BuildProperties buildProperties) {
        this._buildProperties = buildProperties;
        this._editorPart = editorPart;
        this._cache = wodParserCache;
        this._tagList = new ArrayList<TagInfo>(TagDefinition.getTagInfoAsList());
        TagInfo webobject = new TagInfo("webobject", true);
        webobject.addAttributeInfo(new AttributeInfo("name", true, 0, true));
        this._tagList.add(webobject);
        TagInfo wo = new TagInfo("wo", true);
        wo.addAttributeInfo(new AttributeInfo("name", true, 0, true));
        this._tagList.add(wo);
    }

    @Override
    protected boolean supportTagRelation() {
        return false;
    }

    protected IFile getFile() {
        IFile wodFile = null;
        IEditorInput input = this._editorPart.getEditorInput();
        if (input instanceof IPathEditorInput) {
            IPathEditorInput pathInput = (IPathEditorInput)input;
            IPath path = pathInput.getPath();
            wodFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        }
        return wodFile;
    }

    protected IJavaProject getJavaProject() {
        IJavaProject javaProject = null;
        IFile wodFile = this.getFile();
        if (wodFile != null) {
            IProject project = wodFile.getProject();
            javaProject = JavaCore.create((IProject)project);
        }
        return javaProject;
    }

    @Override
    protected List<TagInfo> getDynamicTagInfo(String tagName) {
        LinkedList<InlineWodTagInfo> tagInfos = null;
        if (tagName.startsWith("wo:")) {
            String partialElementType = tagName.substring("wo:".length());
            IJavaProject javaProject = this.getJavaProject();
            try {
                HashSet<WodCompletionProposal> proposals = new HashSet<WodCompletionProposal>();
                WodCompletionUtils.fillInElementTypeCompletionProposals((IJavaProject)javaProject, (String)partialElementType, (int)0, (int)partialElementType.length(), proposals, (boolean)false, null);
                for (TagShortcut tagShortcut : this._cache.getTagShortcuts()) {
                    String shortcut = tagShortcut.getShortcut();
                    if (!shortcut.startsWith(partialElementType.toLowerCase())) continue;
                    proposals.add(new WodCompletionProposal(partialElementType, 0, partialElementType.length(), shortcut));
                }
                if (!proposals.isEmpty()) {
                    tagInfos = new LinkedList<InlineWodTagInfo>();
                    for (WodCompletionProposal proposal : proposals) {
                        InlineWodTagInfo tagInfo = new InlineWodTagInfo(proposal.getProposal(), WodParserCache.getTypeCache());
                        tagInfo.setJavaProject(javaProject);
                        tagInfos.add(tagInfo);
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return tagInfos;
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        return super.computeCompletionProposals(viewer, documentOffset);
    }

    @Override
    protected AssistInfo[] getAttributeValues(String tagName, String value, TagInfo tagInfo, AttributeInfo attrInfo) {
        AssistInfo[] attributeValues;
        if (tagInfo instanceof InlineWodTagInfo) {
            LinkedList<AssistInfo> attributeValuesList = new LinkedList<AssistInfo>();
            try {
                InlineWodTagInfo wodTagInfo = (InlineWodTagInfo)tagInfo;
                String bindingValue = value;
                String prefix = "$";
                String suffix = "";
                String inlineBindingPrefix = this._buildProperties.getInlineBindingPrefix();
                String inlineBindingSuffix = this._buildProperties.getInlineBindingSuffix();
                if (value.startsWith(inlineBindingPrefix)) {
                    prefix = inlineBindingPrefix;
                    bindingValue = value.substring(inlineBindingPrefix.length());
                    if (inlineBindingSuffix.length() > 0 && value.endsWith(inlineBindingSuffix)) {
                        bindingValue = bindingValue.substring(0, bindingValue.length() - inlineBindingSuffix.length());
                        suffix = inlineBindingSuffix;
                    }
                } else if (value.startsWith("~")) {
                    Matcher m = Pattern.compile("[a-z0-9.]*$").matcher(value);
                    if (m.find()) {
                        int index = m.start();
                        prefix = value.substring(0, index);
                        bindingValue = value.substring(index);
                    } else {
                        prefix = "~";
                        bindingValue = "";
                    }
                }
                IFile wodFile = this.getFile();
                String componentTypeName = wodFile.getLocation().removeFileExtension().lastSegment();
                IType componentType = BindingReflectionUtils.findElementType((IJavaProject)wodTagInfo.getJavaProject(), (String)componentTypeName, (boolean)true, (TypeCache)WodParserCache.getTypeCache());
                HashSet<WodCompletionProposal> proposals = new HashSet<WodCompletionProposal>();
                int dotIndex = bindingValue.lastIndexOf(46);
                dotIndex = dotIndex == -1 ? 0 : (dotIndex += prefix.length() + 1);
                boolean checkBindingValue = WodCompletionUtils.fillInBindingValueCompletionProposals((IJavaProject)wodTagInfo.getJavaProject(), (IType)componentType, (String)bindingValue, (int)0, (int)bindingValue.length(), proposals, (TypeCache)WodParserCache.getTypeCache());
                if (checkBindingValue) {
                    try {
                        String elementTypeName = wodTagInfo.getExpandedElementTypeName();
                        IType elementType = BindingReflectionUtils.findElementType((IJavaProject)wodTagInfo.getJavaProject(), (String)elementTypeName, (boolean)false, (TypeCache)WodParserCache.getTypeCache());
                        String[] validValues = ApiUtils.getValidValues((String)value, (IJavaProject)wodTagInfo.getJavaProject(), (IType)this._cache.getComponentType(), (IType)elementType, (String)attrInfo.getAttributeName(), (TypeCache)WodParserCache.getTypeCache());
                        if (validValues != null) {
                            String lowercaseBindingValue = bindingValue.toLowerCase();
                            for (String validValue : validValues) {
                                String lowercaseValidValue = validValue.toLowerCase();
                                if (!lowercaseValidValue.toLowerCase().startsWith(lowercaseBindingValue) && (!lowercaseValidValue.startsWith("\"") || !lowercaseValidValue.substring(1).toLowerCase().startsWith(lowercaseBindingValue))) continue;
                                proposals.add(new WodCompletionProposal(bindingValue, 0, bindingValue.length(), validValue));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                for (WodCompletionProposal proposal : proposals) {
                    Object proposalString = proposal.getProposal();
                    if (dotIndex == 0) {
                        proposalString = ((String)proposalString).startsWith("\"") ? ((String)proposalString).substring(1, ((String)proposalString).length() - 1) : prefix + (String)proposalString + suffix;
                    }
                    AssistInfo assist = new AssistInfo((String)proposalString);
                    assist.setOffset(dotIndex);
                    if (proposal instanceof WodDeprecatedCompletionProposal) {
                        assist.setDeprecated(true);
                    }
                    attributeValuesList.add(assist);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            attributeValues = attributeValuesList.toArray(new AssistInfo[attributeValuesList.size()]);
        } else if ("name".equals(attrInfo.getAttributeName()) && WodHtmlUtils.isWOTag((String)tagName)) {
            LinkedList<AssistInfo> attributeValuesList = new LinkedList<AssistInfo>();
            try {
                IWodModel wodModel = (IWodModel)this._cache.getWodEntry().getModel();
                if (wodModel != null) {
                    for (IWodElement wodElement : wodModel.getElements()) {
                        String wodElementName = wodElement.getElementName();
                        if (!wodElementName.toLowerCase().startsWith(value.toLowerCase())) continue;
                        AssistInfo assist = new AssistInfo(wodElementName);
                        attributeValuesList.add(assist);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            attributeValues = attributeValuesList.toArray(new AssistInfo[attributeValuesList.size()]);
        } else {
            attributeValues = super.getAttributeValues(tagName, value, tagInfo, attrInfo);
        }
        return attributeValues;
    }

    @Override
    protected TagInfo getTagInfo(String name) {
        if (name.startsWith("wo:")) {
            String elementTypeName = name.substring("wo:".length());
            InlineWodTagInfo tagInfo = new InlineWodTagInfo(elementTypeName, WodParserCache.getTypeCache());
            tagInfo.setJavaProject(this.getJavaProject());
            return tagInfo;
        }
        List<TagInfo> tagList = this.getTagList();
        for (int i = 0; i < tagList.size(); ++i) {
            TagInfo info = tagList.get(i);
            if (info.getTagName() == null || !name.equals(info.getTagName().toLowerCase())) continue;
            return info;
        }
        return null;
    }

    @Override
    protected List<TagInfo> getTagList() {
        ArrayList<TagInfo> list = new ArrayList<TagInfo>();
        list.addAll(this._tagList);
        return list;
    }

    @Override
    public void update(HTMLSourceEditor editor, String source) {
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
            this._file = input.getFile();
        }
        super.update(editor, source);
    }
}

