/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.templateeditor;

import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.components.editor.ComponentEditorInteraction;
import org.objectstyle.wolips.components.editor.IEmbeddedEditor;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.templateeditor.TemplateBreadcrumb;
import org.objectstyle.wolips.templateeditor.TemplateOutlinePage;
import org.objectstyle.wolips.templateeditor.TemplateSourceViewerDecorationSupport;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.ITextWOEditor;
import org.objectstyle.wolips.wodclipse.core.refactoring.DeleteTagRefactoring;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;

public class TemplateSourceEditor
extends HTMLSourceEditor
implements ITextWOEditor,
IEmbeddedEditor {
    public static final String ACTION_DELETE_TAG = "_template_deleteTag";
    public static final String ACTION_UNWRAP_TAG = "_template_unwrapTag";
    private TemplateOutlinePage _templateOutlinePage;
    private WodParserCache _cache;
    private TemplateBreadcrumb _breadcrumb;
    private boolean _cacheOutOfSync;
    private ComponentEditorInteraction _editorInteraction;

    public TemplateSourceEditor(HTMLConfiguration config) {
        super(config);
        this.setAction(ACTION_DELETE_TAG, (IAction)new DeleteTagAction());
        this.setAction(ACTION_UNWRAP_TAG, (IAction)new UnwrapTagAction());
    }

    public void initEditorInteraction(ComponentEditorInteraction editorInteraction) {
        this._editorInteraction = editorInteraction;
    }

    public ComponentEditorInteraction getEditorInteraction() {
        return this._editorInteraction;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (this._editorInteraction == null || this._editorInteraction.embeddedEditorWillSave(monitor)) {
            super.doSave(monitor);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.objectstyle.wolips.componenteditor.componentEditorScope"});
    }

    @Override
    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this._cache = null;
    }

    public MarkerAnnotationPreferences getAnnotationPreferences() {
        return super.getAnnotationPreferences();
    }

    public AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        return super.getAnnotationPreferenceLookup();
    }

    @Override
    public void createPartControl(Composite parent) {
        Composite templateParent = new Composite(parent, 0);
        GridLayout templateLayout = new GridLayout();
        templateLayout.marginTop = 0;
        templateLayout.marginLeft = 0;
        templateLayout.marginBottom = 0;
        templateLayout.marginRight = 0;
        templateLayout.marginHeight = 0;
        templateLayout.marginWidth = 0;
        templateLayout.verticalSpacing = 0;
        templateLayout.horizontalSpacing = 0;
        templateParent.setLayout((Layout)templateLayout);
        Composite editorParent = new Composite(templateParent, 0);
        editorParent.setLayoutData((Object)new GridData(1808));
        FillLayout editorLayout = new FillLayout();
        editorLayout.marginHeight = 0;
        editorLayout.marginWidth = 0;
        editorParent.setLayout((Layout)editorLayout);
        super.createPartControl(editorParent);
        this._breadcrumb = new TemplateBreadcrumb(this, templateParent, 0);
        this._breadcrumb.setLayoutData(new GridData(768));
        this.getViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                TemplateSourceEditor.this.setCacheOutOfSync(true);
            }
        });
    }

    @Override
    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return super.createSourceViewer(parent, ruler, styles);
    }

    protected void setCacheOutOfSync(boolean cacheOutOfSync) {
        this._cacheOutOfSync = cacheOutOfSync;
    }

    @Override
    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
    }

    public Point getSelectedRange() {
        return this.getSourceViewer().getSelectedRange();
    }

    @Override
    public void dispose() {
        try {
            WodParserCache cache = this.getParserCache();
            cache.getHtmlEntry().setDocument(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    @Override
    public void update() {
        try {
            WodParserCache cache = this.getParserCache();
            cache.getHtmlEntry().setDocument(this.getDocumentProvider().getDocument((Object)this.getEditorInput()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.update();
    }

    @Override
    protected void doValidate() {
        try {
            String[] natureIds = HTMLPlugin.getDefault().getNoValidationNatureId();
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            for (int i = 0; i < natureIds.length; ++i) {
                if (!file.getProject().hasNature(natureIds[i])) continue;
                return;
            }
            boolean autoBuild = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("description.autobuilding");
            if (!autoBuild) {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        TemplateSourceEditor.this._validate();
                    }
                }, null);
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected void _validate() {
        try {
            WodParserCache cache = this.getParserCache();
            cache.parse();
            cache.validate(false, true);
            if (this._breadcrumb != null) {
                this._breadcrumb.updateBreadcrumb();
            }
        }
        catch (Exception ex) {
            Activator.getDefault().log((Throwable)ex);
        }
    }

    public WodParserCache getParserCache() throws CoreException, LocateException {
        if (this._cache == null) {
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            IFile inputFile = input.getFile();
            this._cache = WodParserCache.parser((IResource)inputFile);
        }
        return this._cache;
    }

    protected void handleElementContentReplaced() {
        super.handleElementContentReplaced();
    }

    public FuzzyXMLDocument getHtmlXmlDocument(boolean refreshModel) throws Exception {
        FuzzyXMLDocument doc;
        if (refreshModel || this.isDirty()) {
            BuildProperties buildProperties = (BuildProperties)this.getParserCache().getProject().getAdapter(BuildProperties.class);
            FuzzyXMLParser parser = new FuzzyXMLParser(buildProperties != null ? buildProperties.isWellFormedTemplateRequired() : false, true);
            doc = parser.parse(this.getHTMLSource());
            this.getParserCache().getHtmlEntry().setModel((Object)doc);
            this.setCacheOutOfSync(false);
        } else {
            doc = (FuzzyXMLDocument)this.getParserCache().getHtmlEntry().getModel();
        }
        return doc;
    }

    public IWodElement getSelectedElement(boolean resolveWodElement, boolean refreshModel) throws Exception {
        IWodElement wodElement = null;
        WodParserCache cache = this.getParserCache();
        if (this.getSelectionProvider() != null) {
            IStructuredSelection structuredSelection;
            Object obj;
            ISelection realSelection = this.getSelectionProvider().getSelection();
            if (realSelection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)realSelection;
                FuzzyXMLDocument document = this.getHtmlXmlDocument(refreshModel);
                if (document != null) {
                    FuzzyXMLElement element = document.getElementByOffset(textSelection.getOffset());
                    BuildProperties buildProperties = (BuildProperties)cache.getProject().getAdapter(BuildProperties.class);
                    wodElement = WodHtmlUtils.getWodElement((FuzzyXMLElement)element, (BuildProperties)buildProperties, (boolean)resolveWodElement, (WodParserCache)cache);
                }
            } else if (realSelection instanceof IStructuredSelection && (obj = (structuredSelection = (IStructuredSelection)realSelection).getFirstElement()) instanceof FuzzyXMLElement) {
                FuzzyXMLElement element = (FuzzyXMLElement)obj;
                BuildProperties buildProperties = (BuildProperties)cache.getProject().getAdapter(BuildProperties.class);
                wodElement = WodHtmlUtils.getWodElement((FuzzyXMLElement)element, (BuildProperties)buildProperties, (boolean)resolveWodElement, (WodParserCache)cache);
            }
        }
        return wodElement;
    }

    public TemplateOutlinePage getTemplateOutlinePage() {
        if (this._templateOutlinePage == null) {
            this._templateOutlinePage = (TemplateOutlinePage)this.createOutlinePage();
        }
        return this._templateOutlinePage;
    }

    @Override
    protected IHTMLOutlinePage createOutlinePage() {
        this._templateOutlinePage = new TemplateOutlinePage(this);
        return this._templateOutlinePage;
    }

    @Override
    protected void addContextMenuActions(IMenuManager menu) {
        super.addContextMenuActions(menu);
        this.addAction(menu, "_html", ACTION_DELETE_TAG);
        this.addAction(menu, "_html", ACTION_UNWRAP_TAG);
    }

    @Override
    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
    }

    @Override
    protected void updateAssist() {
        super.updateAssist();
    }

    public int getOffsetAtPoint(Point point) {
        int modelOffset;
        StyledText st = this.getViewer().getTextWidget();
        if (!st.getBounds().contains(point)) {
            modelOffset = -1;
        } else {
            try {
                int offset = st.getOffsetAtLocation(point);
                modelOffset = AbstractTextEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)offset);
            }
            catch (IllegalArgumentException e) {
                modelOffset = -1;
            }
        }
        return modelOffset;
    }

    public ISourceViewer getWOSourceViewer() {
        return this.getViewer();
    }

    public StyledText getWOEditorControl() {
        return this.getViewer().getTextWidget();
    }

    public IWodElement getWodElementAtPoint(Point point, boolean resolveWodElement, boolean refreshModel) throws Exception {
        IWodElement wodElement = null;
        FuzzyXMLElement element = this.getElementAtPoint(point, refreshModel);
        if (WodHtmlUtils.isWOTag((FuzzyXMLElement)element)) {
            WodParserCache cache = this.getParserCache();
            BuildProperties buildProperties = (BuildProperties)cache.getProject().getAdapter(BuildProperties.class);
            wodElement = WodHtmlUtils.getWodElement((FuzzyXMLElement)element, (BuildProperties)buildProperties, (boolean)resolveWodElement, (WodParserCache)cache);
        }
        return wodElement;
    }

    public FuzzyXMLElement getElementAtPoint(Point point, boolean refreshModel) throws Exception {
        int offset = this.getOffsetAtPoint(point);
        FuzzyXMLElement element = this.getElementAtOffset(offset, refreshModel);
        return element;
    }

    public FuzzyXMLElement getElementAtOffset(int offset, boolean refreshModel) throws Exception {
        FuzzyXMLDocument xmlDocument;
        FuzzyXMLElement element = null;
        if (offset >= 0 && (xmlDocument = this.getHtmlXmlDocument(refreshModel)) != null) {
            element = xmlDocument.getElementByOffset(offset);
        }
        return element;
    }

    public IRegion getSelectionRegionAtPoint(Point point, boolean regionForInsert, boolean refreshModel) throws Exception {
        int offset = this.getOffsetAtPoint(point);
        return this.getSelectionRegionAtOffset(offset, regionForInsert, refreshModel);
    }

    public IRegion getSelectionRegionForElementAtPoint(FuzzyXMLElement element, Point point, boolean regionForInsert) throws Exception {
        int offset = this.getOffsetAtPoint(point);
        return this.getSelectionRegionForElementAtOffset(element, offset, regionForInsert);
    }

    public IRegion getSelectionRegionAtOffset(int offset, boolean regionForInsert, boolean refreshModel) throws Exception {
        FuzzyXMLElement element = this.getElementAtOffset(offset, refreshModel);
        IRegion region = this.getSelectionRegionForElementAtOffset(element, offset, regionForInsert);
        return region;
    }

    public IRegion getSelectionRegionForElementAtOffset(FuzzyXMLElement element, int offset, boolean regionForInsert) throws Exception {
        IRegion region = null;
        if (element != null) {
            IDocument doc = this.getParserCache().getHtmlEntry().getDocument();
            region = element.getRegionAtOffset(offset, doc, regionForInsert);
        }
        return region;
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new TemplateSourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    public Saveable[] getSaveables() {
        return super.getSaveables();
    }

    public class UnwrapTagAction
    extends Action {
        public UnwrapTagAction() {
            super("Unwrap Tag");
        }

        public void run() {
            try {
                int offset;
                FuzzyXMLElement element;
                ITextSelection templateSelection = (ITextSelection)TemplateSourceEditor.this.getSelectionProvider().getSelection();
                if (templateSelection != null && (element = TemplateSourceEditor.this.getElementAtOffset(offset = templateSelection.getOffset(), true)) != null) {
                    BuildProperties buildProperties = (BuildProperties)TemplateSourceEditor.this.getParserCache().getProject().getAdapter(BuildProperties.class);
                    DeleteTagRefactoring.run((FuzzyXMLElement)element, (boolean)true, (BuildProperties)buildProperties, (WodParserCache)TemplateSourceEditor.this.getParserCache(), (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class DeleteTagAction
    extends Action {
        public DeleteTagAction() {
            super("Delete Tag");
        }

        public void run() {
            try {
                int offset;
                FuzzyXMLElement element;
                ITextSelection templateSelection = (ITextSelection)TemplateSourceEditor.this.getSelectionProvider().getSelection();
                if (templateSelection != null && (element = TemplateSourceEditor.this.getElementAtOffset(offset = templateSelection.getOffset(), true)) != null) {
                    BuildProperties buildProperties = (BuildProperties)TemplateSourceEditor.this.getParserCache().getProject().getAdapter(BuildProperties.class);
                    DeleteTagRefactoring.run((FuzzyXMLElement)element, (boolean)false, (BuildProperties)buildProperties, (WodParserCache)TemplateSourceEditor.this.getParserCache(), (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

