/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.util.HashMap;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.ICustomTagValidator;
import tk.eclipse.plugin.htmleditor.ICustomTagValidatorContributer;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.editors.HTMLValidator;
import tk.eclipse.plugin.jspeditor.editors.IJSPFilter;
import tk.eclipse.plugin.jspeditor.editors.IJSPValidationMarkerCreator;
import tk.eclipse.plugin.jspeditor.editors.JSPInfo;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;

public class JSPValidator
extends HTMLValidator
implements IJSPValidationMarkerCreator {
    private JSPInfo info;

    public JSPValidator(IFile file) {
        super(file);
    }

    public JSPValidator(IFile file, JSPInfo info) {
        super(file);
        this.info = info;
    }

    @Override
    protected void validateDocument(FuzzyXMLDocument doc) {
        if (doc != null) {
            if (this.info == null) {
                this.info = JSPInfo.getJSPInfo(this.getFile(), this.getContent());
            }
            this.validateElement((FuzzyXMLElement)XPath.selectSingleNode(doc.getDocumentElement(), "*"));
        }
    }

    @Override
    protected boolean validateUsingFuzzyXML() {
        return true;
    }

    @Override
    protected boolean validateUsingTidy() {
        return false;
    }

    private void validateElement(FuzzyXMLElement element) {
        String[] dim;
        if (element == null) {
            return;
        }
        if (element.getName().indexOf(":") > 0 && (dim = element.getName().split(":")).length != 1) {
            String prefix = dim[0];
            String uri = this.info.getTaglibUri(prefix);
            ICustomTagValidator validator = null;
            if (uri != null) {
                ICustomTagValidatorContributer contributer = HTMLPlugin.getDefault().getCustomTagValidatorContributer(uri);
                if (contributer != null) {
                    validator = contributer.getConverter(dim[1]);
                }
                if (validator != null) {
                    HashMap<String, String> attrMap = new HashMap<String, String>();
                    FuzzyXMLAttribute[] attrs = element.getAttributes();
                    for (int i = 0; i < attrs.length; ++i) {
                        attrMap.put(attrs[i].getName(), attrs[i].getValue());
                    }
                    validator.validate(this, attrMap, element, this.info);
                    return;
                }
            }
            if (!prefix.equals("jsp")) {
                TLDInfo tld = this.getTLDInfo(prefix);
                if (tld == null) {
                    this.addElementMarker(element, "Validation.NoTLD", prefix);
                } else if (tld.getUri() != null || tld.getTagdir() != null) {
                    TagInfo tagInfo = this.getTagInfo(tld, element.getName());
                    if (tagInfo == null) {
                        this.addElementMarker(element, "Validation.NoCustomTag", element.getName());
                    } else {
                        AttributeInfo[] attrs = tagInfo.getAttributeInfo();
                        for (int i = 0; i < attrs.length; ++i) {
                            if (!attrs[i].isRequired() || element.hasAttribute(attrs[i].getAttributeName())) continue;
                            boolean findAttribute = false;
                            FuzzyXMLNode[] nodes = element.getChildren();
                            for (int j = 0; j < nodes.length; ++j) {
                                FuzzyXMLAttribute attr;
                                if (!(nodes[j] instanceof FuzzyXMLElement) || !((FuzzyXMLElement)nodes[j]).getName().equals("jsp:attribute") || (attr = ((FuzzyXMLElement)nodes[j]).getAttributeNode("name")) == null || !attr.getValue().equals(attrs[i].getAttributeName())) continue;
                                findAttribute = true;
                                break;
                            }
                            if (findAttribute) continue;
                            this.addElementMarker(element, "Validation.RequiredAttr", attrs[i].getAttributeName());
                        }
                    }
                }
            }
        }
        FuzzyXMLNode[] nodes = element.getChildren();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FuzzyXMLElement)) continue;
            this.validateElement((FuzzyXMLElement)nodes[i]);
        }
    }

    private TLDInfo getTLDInfo(String prefix) {
        TLDInfo[] tlds = this.info.getTLDInfo();
        for (int i = 0; i < tlds.length; ++i) {
            if (!tlds[i].getPrefix().equals(prefix)) continue;
            return tlds[i];
        }
        return null;
    }

    private TagInfo getTagInfo(TLDInfo tld, String tagName) {
        List<TagInfo> list = tld.getTagInfo();
        for (int j = 0; j < list.size(); ++j) {
            TagInfo tagInfo = list.get(j);
            if (!tagInfo.getTagName().equals(tagName)) continue;
            return tagInfo;
        }
        return null;
    }

    private void addElementMarker(FuzzyXMLElement element, String key, String value) {
        String message = HTMLPlugin.createMessage(HTMLPlugin.getResourceString(key), new String[]{value});
        int offset = element.getOffset() + 1;
        HTMLUtil.addMarker((IResource)this.getFile(), 2, this.getLineAtOffset(offset), offset, element.getName().length(), message);
    }

    @Override
    public void addMarker(int severity, int offset, int length, String message) {
        HTMLUtil.addMarker((IResource)this.getFile(), severity, this.getLineAtOffset(offset), offset, length, message);
    }

    @Override
    protected String filterContents(String jspContents, IFile file) {
        IJSPFilter[] jspFilters = HTMLPlugin.getDefault().getJSPFilters();
        for (int i = 0; i < jspFilters.length; ++i) {
            jspContents = jspFilters[i].filterJSP(jspContents, file);
        }
        return jspContents;
    }
}

