/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.classpath.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.wolips.baseforplugins.util.WOLipsNatureUtils;
import org.objectstyle.wolips.jdt.classpath.model.EclipseJarFramework;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;

public class ProjectClasspathRoot
extends Root<IEclipseFramework> {
    private IProject project;
    private Set<IEclipseFramework> frameworks;

    public ProjectClasspathRoot(String shortName, String name, IProject project) {
        super(shortName, name);
        this.project = project;
    }

    public Set<IEclipseFramework> getFrameworks() {
        if (this.frameworks == null) {
            HashSet<IEclipseFramework> result = new HashSet<IEclipseFramework>();
            boolean isMaven = WOLipsNatureUtils.isMavenNature((IProject)this.project);
            if (isMaven) {
                IJavaProject javaProject = JavaCore.create((IProject)this.project);
                try {
                    IClasspathEntry[] entries;
                    for (IClasspathEntry entry : entries = javaProject.getResolvedClasspath(false)) {
                        EclipseJarFramework jarFramework;
                        if (1 != entry.getEntryKind() || (jarFramework = new EclipseJarFramework(this, entry.getPath().toFile())).getInfoPlist() == null) continue;
                        result.add(jarFramework);
                    }
                }
                catch (JavaModelException e) {
                    throw new RuntimeException(e);
                }
            }
            this.frameworks = result;
        }
        return this.frameworks;
    }

    public Set<IEclipseFramework> getApplications() {
        return new HashSet<IEclipseFramework>();
    }
}

