/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension2;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.objectstyle.wolips.jdt.JdtPlugin;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.jdt.classpath.WOFrameworkClasspathContainer;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;
import org.objectstyle.wolips.jdt.ui.WOFrameworkContentProvider;
import org.objectstyle.wolips.jdt.ui.WOFrameworkLabelProvider;

public class WOFrameworkContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension2,
IClasspathContainerPageExtension {
    private CheckboxTableViewer _frameworkTableViewer;
    private Set<IEclipseFramework> _frameworks;
    private Set<IEclipseFramework> _usedFrameworks;
    private IJavaProject _project;

    public WOFrameworkContainerPage() {
        super("WebObjects Frameworks");
        this.setTitle("WebObjects Frameworks");
        this.setMessage("Select the frameworks to add to this project.");
    }

    protected boolean isFrameworkUsed(IEclipseFramework framework) {
        return this._usedFrameworks.contains(framework);
    }

    public void createControl(Composite parent) {
        Composite thisPage = new Composite(parent, 0);
        thisPage.setLayoutData((Object)new GridData(1808));
        thisPage.setLayout((Layout)new GridLayout());
        this._frameworkTableViewer = CheckboxTableViewer.newCheckList((Composite)thisPage, (int)2050);
        TableColumn frameworkNameColumn = new TableColumn(this._frameworkTableViewer.getTable(), 0);
        frameworkNameColumn.setText("Name");
        frameworkNameColumn.setWidth(200);
        TableColumn rootNameColumn = new TableColumn(this._frameworkTableViewer.getTable(), 0);
        rootNameColumn.setText("Location");
        rootNameColumn.setWidth(200);
        GridData tableLayoutData = new GridData(1808);
        tableLayoutData.heightHint = 200;
        this._frameworkTableViewer.getTable().setHeaderVisible(true);
        this._frameworkTableViewer.getTable().setLayoutData((Object)tableLayoutData);
        this._frameworkTableViewer.setSorter(new ViewerSorter());
        final CheckboxTableViewer finalFrameworkTableViewer = this._frameworkTableViewer;
        this._frameworkTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IEclipseFramework checkedFramework = (IEclipseFramework)event.getElement();
                if (!event.getChecked() && WOFrameworkContainerPage.this.isFrameworkUsed(checkedFramework)) {
                    finalFrameworkTableViewer.setChecked((Object)checkedFramework, true);
                }
            }
        });
        WOFrameworkContentProvider frameworkContentProvider = new WOFrameworkContentProvider(this._frameworks);
        WOFrameworkLabelProvider labelProvider = new WOFrameworkLabelProvider(this._usedFrameworks);
        this._frameworkTableViewer.setContentProvider((IContentProvider)frameworkContentProvider);
        this._frameworkTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this._frameworkTableViewer.setInput((Object)frameworkContentProvider);
        this._frameworkTableViewer.setGrayedElements(this._usedFrameworks.toArray());
        this._frameworkTableViewer.setCheckedElements(this._usedFrameworks.toArray());
        this.setControl((Control)thisPage);
    }

    public void initialize(IJavaProject javaProject, IClasspathEntry[] currentEntries) {
        this._project = javaProject;
        this._frameworks = JdtPlugin.getDefault().getFrameworkModel(this._project.getProject()).getAllFrameworks();
        this._usedFrameworks = new HashSet<IEclipseFramework>();
        try {
            HashMap<String, IEclipseFramework> namedFrameworksMap = new HashMap<String, IEclipseFramework>();
            for (IEclipseFramework framework : this._frameworks) {
                namedFrameworksMap.put(framework.getName(), framework);
            }
            ProjectFrameworkAdapter frameworkAdapter = (ProjectFrameworkAdapter)this._project.getProject().getAdapter(ProjectFrameworkAdapter.class);
            Set<String> linkedFrameworkNames = frameworkAdapter.getLinkedFrameworkNames();
            for (String linkedFrameworkName : linkedFrameworkNames) {
                IEclipseFramework localFramework = (IEclipseFramework)namedFrameworksMap.get(linkedFrameworkName);
                if (localFramework == null) continue;
                this._usedFrameworks.add(localFramework);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to remove already linked frameworks from the framework list.", t);
        }
    }

    public boolean finish() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void setSelection(IClasspathEntry containerEntry) {
    }

    public IClasspathEntry getSelection() {
        return null;
    }

    public IClasspathEntry[] getNewContainers() {
        HashSet<IClasspathEntry> classpathEntries = new HashSet<IClasspathEntry>();
        if (this._frameworkTableViewer != null) {
            Object[] checkedObjects;
            for (Object checkedObject : checkedObjects = this._frameworkTableViewer.getCheckedElements()) {
                IEclipseFramework selectedFramework = (IEclipseFramework)checkedObject;
                if (this.isFrameworkUsed(selectedFramework)) continue;
                WOFrameworkClasspathContainer frameworkContainer = new WOFrameworkClasspathContainer(selectedFramework);
                classpathEntries.add(JavaCore.newContainerEntry((IPath)frameworkContainer.getPath()));
            }
        }
        return classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]);
    }
}

