/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.eomodeler.core.Messages;
import org.objectstyle.wolips.eomodeler.core.kvc.IKey;
import org.objectstyle.wolips.eomodeler.core.kvc.ResolvedKey;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOArgument;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityIndex;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityIndexAttributeReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOFactoryMethodArgumentType;
import org.objectstyle.wolips.eomodeler.core.model.EOFlattenedAttributeAttributeReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOJoin;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipAttributeReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.IEOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.ISortableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.MissingPrototypeFailure;
import org.objectstyle.wolips.eomodeler.core.model.VerificationContext;
import org.objectstyle.wolips.eomodeler.core.model.history.EOAttributeRenamedEvent;
import org.objectstyle.wolips.eomodeler.core.utils.BooleanUtils;

public class EOAttribute
extends AbstractEOArgument<EOEntity>
implements IEOAttribute,
ISortableEOModelObject {
    public static final String PRIMARY_KEY = "primaryKey";
    public static final String CLASS_PROPERTY = "classProperty";
    public static final String USED_FOR_LOCKING = "usedForLocking";
    public static final String PROTOTYPE = "prototype";
    public static final String READ_FORMAT = "readFormat";
    public static final String WRITE_FORMAT = "writeFormat";
    public static final String CLIENT_CLASS_PROPERTY = "clientClassProperty";
    public static final String COMMON_CLASS_PROPERTY = "commonClassProperty";
    public static final String INDEXED = "indexed";
    public static final String READ_ONLY = "readOnly";
    public static final String GENERATE_SOURCE = "generateSource";
    private static final String[] PROTOTYPED_PROPERTIES = new String[]{"name", "columnName", "allowsNull", "adaptorValueConversionClassName", "adaptorValueConversionMethodName", "externalType", "factoryMethodArgumentType", "precision", "scale", "valueClassName", "className", "valueFactoryClassName", "valueFactoryMethodName", "valueType", "definition", "width", "readFormat", "writeFormat", "indexed", "readOnly"};
    private static Map<String, IKey> myCachedPropertyKeys = new HashMap<String, IKey>();
    private EOEntity myEntity;
    private String myPrototypeName;
    private EOAttribute myCachedPrototype;
    private Boolean myClassProperty;
    private Boolean myPrimaryKey;
    private Boolean myUsedForLocking;
    private Boolean myClientClassProperty;
    private Boolean _commonClassProperty;
    private Boolean myIndexed;
    private Boolean myReadOnly;
    private String myReadFormat;
    private String myWriteFormat;
    private EOAttributePath myDefinitionPath;
    private boolean _generateSource = true;
    private static final String SQL_ALLOWS_NULL = "ALLOWS_NULL";
    private static final String SQL_NOT_NULL = "NOT_NULL";

    protected static synchronized IKey getPropertyKey(String _property) {
        IKey key = myCachedPropertyKeys.get(_property);
        if (key == null) {
            key = new ResolvedKey(EOAttribute.class, _property);
            myCachedPropertyKeys.put(_property, key);
        }
        return key;
    }

    public EOAttribute() {
    }

    public EOAttribute(String _name) {
        super(_name);
    }

    public EOAttribute(String _name, String _definition) {
        super(_name, _definition);
    }

    @Override
    public void pasted() {
    }

    @Override
    protected AbstractEOArgument _createArgument(String _name) {
        return new EOAttribute(_name);
    }

    @Override
    protected void _propertyChanged(String _propertyName, Object _oldValue, Object _newValue) {
        if (this.myEntity != null) {
            this.myEntity._attributeChanged(this, _propertyName, _oldValue, _newValue);
        }
    }

    public void guessColumnNameInEntity(EOEntity entity) {
        String columnName = this.getName();
        if (entity != null) {
            columnName = entity.getModel().getAttributeNamingConvention().format(columnName);
        }
        this.setColumnName(columnName);
    }

    public void guessPrototype(boolean _skipIfAlreadyPrototyped) {
        if (!_skipIfAlreadyPrototyped || this.getPrototype() == null) {
            boolean probablyBooleanString = Integer.valueOf(5).equals(this.getWidth()) && ("S".equals(this.getValueType()) || "c".equals(this.getValueType()));
            EOAttribute matchingPrototypeAttribute = null;
            Iterator<EOAttribute> prototypeAttributesIter = this.getEntity().getModel().getPrototypeAttributes().iterator();
            while (matchingPrototypeAttribute == null && prototypeAttributesIter.hasNext()) {
                EOAttribute prototypeAttribute = prototypeAttributesIter.next();
                boolean prototypeMatches = true;
                for (int propertyNum = 0; prototypeMatches && propertyNum < PROTOTYPED_PROPERTIES.length; ++propertyNum) {
                    String propertyName = PROTOTYPED_PROPERTIES[propertyNum];
                    if ("name" == propertyName || "columnName" == propertyName) continue;
                    Object currentValue = EOAttribute.getPropertyKey(propertyName).getValue(this);
                    Object prototypeValue = EOAttribute.getPropertyKey(propertyName).getValue(prototypeAttribute);
                    if (prototypeValue == null || this.prototypeValueEquals(propertyName, currentValue, prototypeValue)) continue;
                    prototypeMatches = !(!"valueType".equals(propertyName) || !"S".equals(currentValue) && !"c".equals(currentValue) || !"S".equals(prototypeValue) && !"c".equals(prototypeValue)) ? true : ("valueType".equals(propertyName) && "B".equals(currentValue) && "i".equals(prototypeValue) ? true : ("valueClassName".equals(propertyName) && "NSDecimalNumber".equals(currentValue) && "NSNumber".equals(prototypeValue) ? true : (probablyBooleanString && "adaptorValueConversionClassName".equals(propertyName) && currentValue == null && "toString".equals(prototypeValue) ? true : (probablyBooleanString && "adaptorValueConversionMethodName".equals(propertyName) && currentValue == null && "toString".equals(prototypeValue) ? true : (probablyBooleanString && "factoryMethodArgumentType".equals(propertyName) && currentValue == null && EOFactoryMethodArgumentType.STRING.equals(prototypeValue) ? true : (probablyBooleanString && "valueClassName".equals(propertyName) && "NSString".equals(currentValue) && "java.lang.Boolean".equals(prototypeValue) ? true : (probablyBooleanString && "valueFactoryClassName".equals(propertyName) && currentValue == null && "valueOf".equals(prototypeValue) ? true : probablyBooleanString && "valueFactoryMethodName".equals(propertyName) && currentValue == null && "valueOf".equals(prototypeValue))))))));
                }
                if (!prototypeMatches) continue;
                matchingPrototypeAttribute = prototypeAttribute;
            }
            if (matchingPrototypeAttribute != null) {
                this.setPrototype(matchingPrototypeAttribute);
            }
        }
    }

    @Override
    public Boolean isToMany() {
        return Boolean.FALSE;
    }

    protected boolean prototypeValueEquals(String propertyName, Object value1, Object value2) {
        if ("valueType".equals(propertyName)) {
            return ComparisonUtils.equals((Object)value1, (Object)value2);
        }
        return ComparisonUtils.equalsIgnoreCaseIfStrings((Object)value1, (Object)value2);
    }

    public boolean isPrototyped(String _property) {
        IKey key;
        Object value;
        EOAttribute prototype;
        boolean prototyped = false;
        if (this.myPrototypeName != null && (prototype = this.getPrototype()) != null && (value = (key = EOAttribute.getPropertyKey(_property)).getValue(this)) != null) {
            Object prototypeValue = key.getValue(prototype);
            prototyped = this.prototypeValueEquals(_property, value, prototypeValue);
        }
        return prototyped;
    }

    @Override
    public boolean isPrototyped() {
        boolean prototyped = false;
        EOAttribute prototype = this.getPrototype();
        if (prototype != null) {
            prototyped = true;
        }
        return prototyped;
    }

    @Override
    public boolean isFlattened() {
        return StringUtils.isKeyPath((String)this._getDefinition());
    }

    @Override
    public boolean isInherited() {
        EOEntity parent;
        boolean inherited = false;
        if (this.myEntity != null && (parent = this.myEntity.getParent()) != null) {
            EOAttribute attribute = parent.getAttributeNamed(this.getName());
            inherited = attribute != null;
        }
        return inherited;
    }

    public boolean isGenerateSource() {
        return this._generateSource;
    }

    public void setGenerateSource(boolean generateSource) {
        boolean oldGenerateSource = this._generateSource;
        this._generateSource = generateSource;
        this.firePropertyChange(GENERATE_SOURCE, oldGenerateSource, this._generateSource);
    }

    public EOAttribute getPrototype() {
        if (this.myCachedPrototype == null && this.myPrototypeName != null && this.myEntity != null) {
            this.myCachedPrototype = this.myEntity.getModel().getPrototypeAttributeNamed(this.myPrototypeName);
        }
        return this.myCachedPrototype;
    }

    public void clearCachedPrototype(Set<EOModelVerificationFailure> _failures, boolean _reload) {
        if (this.myPrototypeName != null) {
            this.clearCachedPrototype(this.myPrototypeName, _failures, true, _reload);
        }
    }

    public void clearCachedPrototype(String _prototypeName, Set<EOModelVerificationFailure> _failures, boolean _callSetPrototype, boolean _reload) {
        this.myCachedPrototype = null;
        this.myPrototypeName = _prototypeName;
        if (_reload && _prototypeName != null && this.myEntity != null) {
            EOAttribute prototype = this.myEntity.getModel().getPrototypeAttributeNamed(_prototypeName);
            if (_callSetPrototype) {
                this.setPrototype(prototype);
            }
            if (prototype == null) {
                this.myCachedPrototype = prototype;
                this.myPrototypeName = _prototypeName;
                if (_failures != null) {
                    _failures.add(new MissingPrototypeFailure(_prototypeName, this));
                }
            }
        }
    }

    public void setPrototype(EOAttribute _prototype) {
        this.setPrototype(_prototype, true);
    }

    public void setPrototype(EOAttribute _prototype, boolean _updateFromPrototype) {
        String propertyName;
        int propertyNum;
        EOAttribute oldPrototype = this.getPrototype();
        boolean prototypeNameChanged = true;
        if (_prototype == null && oldPrototype == null) {
            prototypeNameChanged = false;
        } else if (ComparisonUtils.equals((Object)_prototype, (Object)oldPrototype)) {
            prototypeNameChanged = false;
        }
        HashMap<String, Object> oldValues = new HashMap<String, Object>();
        for (propertyNum = 0; propertyNum < PROTOTYPED_PROPERTIES.length; ++propertyNum) {
            propertyName = PROTOTYPED_PROPERTIES[propertyNum];
            oldValues.put(propertyName, EOAttribute.getPropertyKey(propertyName).getValue(this));
        }
        this.myCachedPrototype = _prototype;
        this.myPrototypeName = _prototype == null ? null : _prototype.getName();
        this.firePropertyChange(PROTOTYPE, oldPrototype, _prototype);
        if (prototypeNameChanged && _updateFromPrototype) {
            for (propertyNum = 0; propertyNum < PROTOTYPED_PROPERTIES.length; ++propertyNum) {
                Object newPrototypeValue;
                propertyName = PROTOTYPED_PROPERTIES[propertyNum];
                IKey propertyKey = EOAttribute.getPropertyKey(propertyName);
                Object oldValue = oldValues.get(propertyName);
                Object object = newPrototypeValue = _prototype != null ? propertyKey.getValue(_prototype) : oldValue;
                Object newValue = "name".equals(propertyName) ? oldValue : ("columnName".equals(propertyName) && oldValue != null ? oldValue : newPrototypeValue);
                propertyKey.setValue(this, newValue);
                this.firePropertyChange(propertyName, oldValue, newValue);
            }
            this.updateDataType(null);
        }
    }

    protected Object _prototypeValueIfNull(String _property, Object _value) {
        EOAttribute prototype;
        Object value = _value;
        if ((value == null || value instanceof String && ((String)_value).length() == 0) && this.myPrototypeName != null && (prototype = this.getPrototype()) != null) {
            value = EOAttribute.getPropertyKey(_property).getValue(prototype);
        }
        return value;
    }

    protected Object _nullIfPrototyped(String _property, Object _value) {
        EOAttribute prototype;
        Object value = _value;
        if (value != null && this.myPrototypeName != null && (prototype = this.getPrototype()) != null && this.prototypeValueEquals(_property, value, EOAttribute.getPropertyKey(_property).getValue(prototype))) {
            value = null;
        }
        return value;
    }

    @Override
    public void setName(String _name, boolean _fireEvents) throws DuplicateNameException {
        String oldName = this.getName();
        String newName = (String)this._prototypeValueIfNull("name", _name);
        if (newName == null) {
            throw new NullPointerException(Messages.getString("EOAttribute.noBlankAttributeNames"));
        }
        if (this.myEntity != null) {
            this.myEntity._checkForDuplicateAttributeName(this, newName, null);
            EOModel model = this.myEntity.getModel();
            if (model != null) {
                model.getModelEvents().addEvent(new EOAttributeRenamedEvent(this));
            }
        }
        super.setName((String)this._nullIfPrototyped("name", newName), _fireEvents);
        if (this.myEntity != null && this.myEntity.getModel() != null) {
            for (EOEntity childrenEntity : this.myEntity.getChildrenEntities()) {
                EOAttribute childAttribute = childrenEntity.getAttributeNamed(oldName);
                if (childAttribute == null) continue;
                childAttribute.setName(newName, _fireEvents);
            }
            EOModelGroup modelGroup = this.myEntity.getModel().getModelGroup();
            for (EOEntity entity : modelGroup.getEntities()) {
                for (EOAttribute attribute : entity.getAttributes()) {
                    attribute.updateDefinitionBecauseAttributeNameChanged(this);
                }
            }
            for (EOEntityIndex index : this.getReferencingEntityIndexes()) {
                index.getEntity().setEntityDirty(true);
            }
            for (EORelationship relationship : this.getReferencingRelationships(true, new VerificationContext(this.getEntity().getModel().getModelGroup()))) {
                relationship.getEntity().setEntityDirty(true);
            }
        }
        if (_fireEvents) {
            this.synchronizeNameChange(oldName, newName);
        }
    }

    @Override
    public String getName() {
        return (String)this._prototypeValueIfNull("name", super.getName());
    }

    public String getUppercaseName() {
        return this.getName().toUpperCase();
    }

    public String getUppercaseUnderscoreName() {
        return StringUtils.camelCaseToUnderscore((String)this.getName()).toUpperCase();
    }

    public String getCapitalizedName() {
        String name = this.getName();
        if (name != null) {
            name = StringUtils.toUppercaseFirstLetter((String)name);
        }
        return name;
    }

    public Boolean getReadOnly() {
        return this.isReadOnly();
    }

    public Boolean isReadOnly() {
        return (Boolean)this._prototypeValueIfNull(READ_ONLY, this.myReadOnly);
    }

    public void setReadOnly(Boolean _readOnly) {
        this.setReadOnly(_readOnly, true);
    }

    public void setReadOnly(Boolean _readOnly, boolean _fireEvents) {
        Boolean oldReadOnly = this.getReadOnly();
        this.myReadOnly = (Boolean)this._nullIfPrototyped(READ_ONLY, _readOnly);
        if (_fireEvents) {
            this.firePropertyChange(READ_ONLY, oldReadOnly, this.getReadOnly());
        }
    }

    public Boolean getIndexed() {
        return this.isIndexed();
    }

    public Boolean isIndexed() {
        return (Boolean)this._prototypeValueIfNull(INDEXED, this.myIndexed);
    }

    public void setIndexed(Boolean _indexed) {
        this.setIndexed(_indexed, true);
    }

    public void setIndexed(Boolean _indexed, boolean _fireEvents) {
        Boolean oldIndexed = this.getIndexed();
        this.myIndexed = (Boolean)this._nullIfPrototyped(INDEXED, _indexed);
        if (_fireEvents) {
            this.firePropertyChange(INDEXED, oldIndexed, this.getIndexed());
        }
    }

    @Override
    public Boolean isAllowsNull() {
        return (Boolean)this._prototypeValueIfNull("allowsNull", super.isAllowsNull());
    }

    @Override
    public void setAllowsNull(Boolean allowsNull) {
        this.setAllowsNull(allowsNull, true);
    }

    @Override
    public void setAllowsNull(Boolean _allowsNull, boolean _fireEvents) {
        EOModelGroup modelGroup;
        EOModel model;
        Boolean newAllowsNull = _allowsNull;
        if (_fireEvents && BooleanUtils.isTrue(this.getPrimaryKey())) {
            newAllowsNull = Boolean.FALSE;
        }
        super.setAllowsNull((Boolean)this._nullIfPrototyped("allowsNull", newAllowsNull), _fireEvents);
        Boolean mandatory = BooleanUtils.negate(newAllowsNull);
        EOEntity entity = this.getEntity();
        if (entity != null && !entity.isSingleTableInheritance() && (model = entity.getModel()) != null && (modelGroup = model.getModelGroup()) != null) {
            for (EORelationship referencingRelationship : entity.getRelationships()) {
                if (!BooleanUtils.isTrue(referencingRelationship.isToOne())) continue;
                boolean relationshipReferencesAttribute = false;
                List<EOJoin> joins = referencingRelationship.getJoins();
                for (EOJoin join : joins) {
                    if (join.getSourceAttribute() != this) continue;
                    relationshipReferencesAttribute = true;
                }
                if (!relationshipReferencesAttribute) continue;
                referencingRelationship._setMandatory(mandatory);
            }
        }
    }

    @Override
    public Boolean getClassProperty() {
        return this.isClassProperty();
    }

    @Override
    public Boolean isClassProperty() {
        return BooleanUtils.isTrue(this.myClassProperty);
    }

    @Override
    public void setClassProperty(Boolean _classProperty) {
        this.setClassProperty(_classProperty, true);
    }

    @Override
    public void setClassProperty(Boolean _classProperty, boolean _fireEvents) {
        Boolean oldClassProperty = this.getClassProperty();
        this.myClassProperty = _classProperty;
        if (_fireEvents) {
            this.firePropertyChange(CLASS_PROPERTY, oldClassProperty, this.getClassProperty());
        }
    }

    @Override
    public String getColumnName() {
        if (this.isFlattened()) {
            return null;
        }
        return (String)this._prototypeValueIfNull("columnName", super.getColumnName());
    }

    @Override
    public void setColumnName(String _columnName) {
        super.setColumnName((String)this._nullIfPrototyped("columnName", _columnName));
    }

    public void _setEntity(EOEntity _entity) {
        this.myEntity = _entity;
    }

    @Override
    public EOEntity getEntity() {
        return this.myEntity;
    }

    public Boolean getPrimaryKey() {
        return this.isPrimaryKey();
    }

    public Boolean isPrimaryKey() {
        return BooleanUtils.isTrue(this.myPrimaryKey);
    }

    public void setPrimaryKey(Boolean _primaryKey) {
        this.setPrimaryKey(_primaryKey, true);
    }

    public void setPrimaryKey(Boolean _primaryKey, boolean _fireEvents) {
        Boolean oldPrimaryKey = this.getPrimaryKey();
        this.myPrimaryKey = _primaryKey;
        if (_fireEvents && BooleanUtils.isTrue(_primaryKey)) {
            this.setAllowsNull(Boolean.FALSE, _fireEvents);
            this.setClassProperty(Boolean.FALSE, _fireEvents);
        }
        if (_fireEvents) {
            this.firePropertyChange(PRIMARY_KEY, oldPrimaryKey, this.getPrimaryKey());
        }
    }

    public Boolean getUsedForLocking() {
        return this.isUsedForLocking();
    }

    public Boolean isUsedForLocking() {
        return BooleanUtils.isTrue(this.myUsedForLocking);
    }

    public void setUsedForLocking(Boolean _usedForLocking) {
        this.setUsedForLocking(_usedForLocking, true);
    }

    public void setUsedForLocking(Boolean _usedForLocking, boolean _fireEvents) {
        Boolean oldUsedForLocking = this.getUsedForLocking();
        this.myUsedForLocking = _usedForLocking;
        if (_fireEvents) {
            this.firePropertyChange(USED_FOR_LOCKING, oldUsedForLocking, this.getUsedForLocking());
        }
    }

    @Override
    public String getAdaptorValueConversionClassName() {
        return (String)this._prototypeValueIfNull("adaptorValueConversionClassName", super.getAdaptorValueConversionClassName());
    }

    @Override
    public void setAdaptorValueConversionClassName(String _adaptorValueConversionClassName) {
        super.setAdaptorValueConversionClassName((String)this._nullIfPrototyped("adaptorValueConversionClassName", _adaptorValueConversionClassName));
    }

    @Override
    public String getAdaptorValueConversionMethodName() {
        return (String)this._prototypeValueIfNull("adaptorValueConversionMethodName", super.getAdaptorValueConversionMethodName());
    }

    @Override
    public void setAdaptorValueConversionMethodName(String _adaptorValueConversionMethodName) {
        super.setAdaptorValueConversionMethodName((String)this._nullIfPrototyped("adaptorValueConversionMethodName", _adaptorValueConversionMethodName));
    }

    @Override
    public String getExternalType() {
        return (String)this._prototypeValueIfNull("externalType", super.getExternalType());
    }

    @Override
    public void setExternalType(String _externalType) {
        super.setExternalType((String)this._nullIfPrototyped("externalType", _externalType));
    }

    @Override
    public EOFactoryMethodArgumentType getFactoryMethodArgumentType() {
        return (EOFactoryMethodArgumentType)this._prototypeValueIfNull("factoryMethodArgumentType", super.getFactoryMethodArgumentType());
    }

    @Override
    public void setFactoryMethodArgumentType(EOFactoryMethodArgumentType _factoryMethodArgumentType) {
        super.setFactoryMethodArgumentType((EOFactoryMethodArgumentType)this._nullIfPrototyped("factoryMethodArgumentType", _factoryMethodArgumentType));
    }

    @Override
    public Integer getPrecision() {
        return (Integer)this._prototypeValueIfNull("precision", super.getPrecision());
    }

    @Override
    public void setPrecision(Integer _precision) {
        super.setPrecision((Integer)this._nullIfPrototyped("precision", _precision));
    }

    @Override
    public Integer getScale() {
        return (Integer)this._prototypeValueIfNull("scale", super.getScale());
    }

    @Override
    public void setScale(Integer _scale) {
        super.setScale((Integer)this._nullIfPrototyped("scale", _scale));
    }

    @Override
    public String getServerTimeZone() {
        return (String)this._prototypeValueIfNull("serverTimeZone", super.getServerTimeZone());
    }

    @Override
    public void setServerTimeZone(String _serverTimeZone) {
        super.setServerTimeZone((String)this._nullIfPrototyped("serverTimeZone", _serverTimeZone));
    }

    @Override
    public String getClassName() {
        return (String)this._prototypeValueIfNull("className", super.getClassName());
    }

    @Override
    public synchronized void setClassName(String className) {
        super.setClassName((String)this._nullIfPrototyped("className", className));
    }

    @Override
    public String getValueClassName() {
        return (String)this._prototypeValueIfNull("valueClassName", super.getValueClassName());
    }

    @Override
    public synchronized void setValueClassName(String _valueClassName, boolean _updateDataType) {
        super.setValueClassName((String)this._nullIfPrototyped("valueClassName", _valueClassName), _updateDataType);
    }

    @Override
    public String getValueFactoryClassName() {
        return (String)this._prototypeValueIfNull("valueFactoryClassName", super.getValueFactoryClassName());
    }

    @Override
    public void setValueFactoryClassName(String _valueFactoryClassName) {
        super.setValueFactoryClassName((String)this._nullIfPrototyped("valueFactoryClassName", _valueFactoryClassName));
    }

    @Override
    public String getValueFactoryMethodName() {
        return (String)this._prototypeValueIfNull("valueFactoryMethodName", super.getValueFactoryMethodName());
    }

    @Override
    public void setValueFactoryMethodName(String _valueFactoryMethodName) {
        super.setValueFactoryMethodName((String)this._nullIfPrototyped("valueFactoryMethodName", _valueFactoryMethodName));
    }

    @Override
    public String getValueType() {
        return (String)this._prototypeValueIfNull("valueType", super.getValueType());
    }

    @Override
    public synchronized void setValueType(String _valueType, boolean _updateDataType) {
        super.setValueType((String)this._nullIfPrototyped("valueType", _valueType), _updateDataType);
    }

    @Override
    public Integer getWidth() {
        return (Integer)this._prototypeValueIfNull("width", super.getWidth());
    }

    @Override
    public void setWidth(Integer _width) {
        super.setWidth((Integer)this._nullIfPrototyped("width", _width));
    }

    @Override
    public String getDefinition() {
        String definition = this.isFlattened() && this.myDefinitionPath != null ? this.myDefinitionPath.toKeyPath() : this._getDefinition();
        return definition;
    }

    public EOAttributePath getDefinitionPath() {
        if (this.myDefinitionPath == null) {
            this.updateDefinitionPath();
        }
        return this.myDefinitionPath;
    }

    @Override
    public String _getDefinition() {
        return (String)this._prototypeValueIfNull("definition", super._getDefinition());
    }

    public boolean hasDefinition() {
        return this.getDefinition() != null;
    }

    public void updateDefinitionBecauseRelationshipNameChanged(EORelationship relationship) {
        EOAttributePath definitionPath;
        if (this.isFlattened() && (definitionPath = this.getDefinitionPath()) != null && definitionPath.isRelatedTo(relationship)) {
            this.setDefinition(definitionPath.toKeyPath());
        }
    }

    public void updateDefinitionBecauseAttributeNameChanged(EOAttribute attribute) {
        EOAttributePath definitionPath;
        if (this.isFlattened() && (definitionPath = this.getDefinitionPath()) != null && definitionPath.isRelatedTo(attribute)) {
            this.setDefinition(definitionPath.toKeyPath());
        }
    }

    @Override
    protected void updateDefinitionPath() {
        AbstractEOAttributePath definitionPath;
        this.myDefinitionPath = this.isFlattened() ? ((definitionPath = this.getEntity().resolveKeyPath(this._getDefinition())) instanceof EOAttributePath && definitionPath.isValid() ? (EOAttributePath)definitionPath : null) : null;
    }

    @Override
    public void setDefinition(String _definition) {
        super.setDefinition((String)this._nullIfPrototyped("definition", _definition));
    }

    public String getReadFormat() {
        return (String)this._prototypeValueIfNull(READ_FORMAT, this.myReadFormat);
    }

    public void setReadFormat(String _readFormat) {
        String oldReadFormat = this.getReadFormat();
        this.myReadFormat = (String)this._nullIfPrototyped(READ_FORMAT, _readFormat);
        this.firePropertyChange(READ_FORMAT, oldReadFormat, this.getReadFormat());
    }

    public String getWriteFormat() {
        return (String)this._prototypeValueIfNull(WRITE_FORMAT, this.myWriteFormat);
    }

    public void setWriteFormat(String _writeFormat) {
        String oldWriteFormat = this.getWriteFormat();
        this.myWriteFormat = (String)this._nullIfPrototyped(WRITE_FORMAT, _writeFormat);
        this.firePropertyChange(WRITE_FORMAT, oldWriteFormat, this.getWriteFormat());
    }

    @Override
    public void setCommonClassProperty(Boolean commonClassProperty) {
        this.setCommonClassProperty(commonClassProperty, true);
    }

    @Override
    public void setCommonClassProperty(Boolean commonClassProperty, boolean fireEvents) {
        Boolean oldCommonClassProperty = this.getCommonClassProperty();
        this._commonClassProperty = commonClassProperty;
        if (fireEvents) {
            this.firePropertyChange(COMMON_CLASS_PROPERTY, oldCommonClassProperty, this.getCommonClassProperty());
        }
    }

    @Override
    public Boolean getCommonClassProperty() {
        return this.isCommonClassProperty();
    }

    @Override
    public Boolean isCommonClassProperty() {
        return BooleanUtils.isTrue(this._commonClassProperty);
    }

    @Override
    public void setClientClassProperty(Boolean _clientClassProperty) {
        this.setClientClassProperty(_clientClassProperty, true);
    }

    @Override
    public void setClientClassProperty(Boolean _clientClassProperty, boolean _fireEvents) {
        Boolean oldClientClassProperty = this.getClientClassProperty();
        this.myClientClassProperty = _clientClassProperty;
        if (_fireEvents) {
            this.firePropertyChange(CLIENT_CLASS_PROPERTY, oldClientClassProperty, this.getClientClassProperty());
        }
    }

    @Override
    public Boolean getClientClassProperty() {
        return this.isClientClassProperty();
    }

    @Override
    public Boolean isClientClassProperty() {
        return BooleanUtils.isTrue(this.myClientClassProperty);
    }

    @Override
    public Set<EOModelReferenceFailure> getReferenceFailures() {
        HashSet<EOModelReferenceFailure> referenceFailures = new HashSet<EOModelReferenceFailure>();
        for (EORelationship referencingRelationship : this.getReferencingRelationships(true, new VerificationContext(this.getEntity().getModel().getModelGroup()))) {
            referenceFailures.add(new EORelationshipAttributeReferenceFailure(referencingRelationship, this));
        }
        for (EOAttribute referencingAttributes : this.getReferencingFlattenedAttributes()) {
            referenceFailures.add(new EOFlattenedAttributeAttributeReferenceFailure(referencingAttributes, this));
        }
        for (EOEntityIndex referencingEntityIndex : this.getReferencingEntityIndexes()) {
            referenceFailures.add(new EOEntityIndexAttributeReferenceFailure(referencingEntityIndex, this));
        }
        return referenceFailures;
    }

    public List<EOAttribute> getReferencingFlattenedAttributes() {
        LinkedList<EOAttribute> referencingFlattenedAttributes = new LinkedList<EOAttribute>();
        if (this.myEntity != null) {
            for (EOModel model : this.getEntity().getModel().getModelGroup().getModels()) {
                for (EOEntity entity : model.getEntities()) {
                    for (EOAttribute attribute : entity.getAttributes()) {
                        EOAttributePath attributePath;
                        if (!attribute.isFlattened() || (attributePath = attribute.getDefinitionPath()) == null || !attributePath.isRelatedTo(this)) continue;
                        referencingFlattenedAttributes.add(attribute);
                    }
                }
            }
        }
        return referencingFlattenedAttributes;
    }

    public Set<EORelationship> getReferencingRelationships(boolean includeInheritedAttributes, VerificationContext verificationContext) {
        HashSet<EORelationship> referencingRelationships = new HashSet<EORelationship>();
        if (this.myEntity != null) {
            Set<EORelationship> directReferencingRelationships = verificationContext.getReferencingRelationshipsCache().get(this);
            if (directReferencingRelationships != null) {
                referencingRelationships.addAll(directReferencingRelationships);
            }
            if (includeInheritedAttributes && this.myEntity != null) {
                String name = this.getName();
                Set<EOEntity> childrenEntities = verificationContext.getInheritanceCache().get(this.myEntity);
                if (childrenEntities != null) {
                    for (EOEntity childEntity : childrenEntities) {
                        EOAttribute childAttribute = childEntity.getAttributeNamed(name);
                        if (childAttribute == null) continue;
                        referencingRelationships.addAll(childAttribute.getReferencingRelationships(includeInheritedAttributes, verificationContext));
                    }
                }
            }
        }
        return referencingRelationships;
    }

    public Set<EOEntityIndex> getReferencingEntityIndexes() {
        HashSet<EOEntityIndex> referencingEntityIndexes = new HashSet<EOEntityIndex>();
        if (this.myEntity != null) {
            for (EOModel model : this.getEntity().getModel().getModelGroup().getModels()) {
                for (EOEntity entity : model.getEntities()) {
                    for (EOEntityIndex entityIndex : entity.getEntityIndexes()) {
                        for (EOAttribute attribute : entityIndex.getAttributes()) {
                            if (attribute != this) continue;
                            referencingEntityIndexes.add(entityIndex);
                        }
                    }
                }
            }
        }
        return referencingEntityIndexes;
    }

    @Override
    public void loadFromMap(EOModelMap _attributeMap, Set<EOModelVerificationFailure> _failures) {
        super.loadFromMap(_attributeMap, _failures);
        this.myReadOnly = _attributeMap.getBoolean("isReadOnly");
        this.myIndexed = _attributeMap.getBoolean("isIndexed");
        this.myReadFormat = _attributeMap.containsKey("selectFormat") ? _attributeMap.getString("selectFormat", true) : _attributeMap.getString(READ_FORMAT, true);
        this.myWriteFormat = _attributeMap.containsKey("updateFormat") ? _attributeMap.getString("updateFormat", true) : (_attributeMap.containsKey("insertFormat") ? _attributeMap.getString("insertFormat", true) : _attributeMap.getString(WRITE_FORMAT, true));
        EOModelMap entityModelerMap = this.getEntityModelerMap(false);
        Boolean generateSource = entityModelerMap.getBoolean(GENERATE_SOURCE);
        this._generateSource = generateSource == null ? true : generateSource;
        Boolean commonClassProperty = entityModelerMap.getBoolean(COMMON_CLASS_PROPERTY);
        if (commonClassProperty != null) {
            this._commonClassProperty = (boolean)commonClassProperty;
        }
    }

    @Override
    protected void writeUserInfo(EOModelMap modelMap) {
        super.writeUserInfo(modelMap);
    }

    @Override
    public EOModelMap toMap() {
        EOModelMap entityModelerMap = this.getEntityModelerMap(true);
        if (this._generateSource) {
            entityModelerMap.remove(GENERATE_SOURCE);
        } else {
            entityModelerMap.setBoolean(GENERATE_SOURCE, Boolean.FALSE, 1);
        }
        if (this._commonClassProperty != null && this._commonClassProperty.booleanValue()) {
            entityModelerMap.setBoolean(COMMON_CLASS_PROPERTY, Boolean.TRUE, 1);
        } else {
            entityModelerMap.remove(COMMON_CLASS_PROPERTY);
        }
        EOModelMap attributeMap = super.toMap();
        if (this.myPrototypeName != null) {
            attributeMap.setString("prototypeName", this.myPrototypeName, true);
        } else {
            attributeMap.remove("prototypeName");
        }
        attributeMap.setBoolean("isReadOnly", this.myReadOnly, 2);
        attributeMap.setBoolean("isIndexed", this.myIndexed, 2);
        attributeMap.setString(READ_FORMAT, this.myReadFormat, true);
        attributeMap.remove("selectFormat");
        attributeMap.setString(WRITE_FORMAT, this.myWriteFormat, true);
        attributeMap.remove("updateFormat");
        attributeMap.remove("insertFormat");
        return attributeMap;
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
        String prototypeName = this.getArgumentMap().getString("prototypeName", true);
        if (prototypeName != null && this.myEntity != null && this.myEntity.isPrototype()) {
            HashSet<String> checkPrototypeNames = new HashSet<String>();
            checkPrototypeNames.add(this.getName());
            String checkPrototypeName = prototypeName;
            while (checkPrototypeName != null) {
                if (checkPrototypeNames.contains(checkPrototypeName)) {
                    _failures.add(new EOModelVerificationFailure(this.getEntity().getModel(), this, "The prototype '" + prototypeName + "' is a prototype of itself. Removing the prototype cycle.", false));
                    this.setPrototype(null);
                    checkPrototypeName = null;
                    prototypeName = null;
                    continue;
                }
                checkPrototypeNames.add(checkPrototypeName);
                EOAttribute prototype = this.myEntity.getModel().getPrototypeAttributeNamed(checkPrototypeName);
                checkPrototypeName = prototype.getArgumentMap().getString("prototypeName", true);
            }
        }
        this.clearCachedPrototype(prototypeName, _failures, false, true);
        if (super.getClassName() != null && this.getPrototype() != null && this._nullIfPrototyped("className", super.getClassName()) == null) {
            if (!this._inferredClassName) {
                _failures.add(new EOModelVerificationFailure(this.getEntity().getModel(), this, "Removed redundant 'className' attribute that was defined in the prototype '" + this.getPrototype().getName() + "'.", true));
            }
            this.setClassName(this.getClassName());
            this.setValueClassName(this.getPrototype().getValueClassName(), false);
            this.getEntity()._attributeChanged(this, "className", null, null);
        }
        if (super.getValueClassName() != null && this.getPrototype() != null && this._nullIfPrototyped("valueClassName", super.getValueClassName()) == null) {
            if (!this._inferredValueClassName) {
                _failures.add(new EOModelVerificationFailure(this.getEntity().getModel(), this, "Removed redundant 'valueClassName' attribute that was defined in the prototype '" + this.getPrototype().getName() + "'.", true));
            }
            this.setValueClassName(this.getPrototype().getValueClassName(), false);
            this.getEntity()._attributeChanged(this, "valueClassName", null, null);
        } else if (("NSTimestamp".equals(super.getValueClassName()) || "com.webobjects.foundation.NSTimestamp".equals(super.getValueClassName())) && this.getPrototype() != null && this._nullIfPrototyped("valueClassName", "NSCalendarDate") == null) {
            if (!this._inferredValueClassName) {
                _failures.add(new EOModelVerificationFailure(this.getEntity().getModel(), this, "Removed redundant 'valueClassName' attribute that was defined in the prototype '" + this.getPrototype().getName() + "'.", true));
            }
            this.setValueClassName(this.getPrototype().getValueClassName(), false);
            this.getEntity()._attributeChanged(this, "valueClassName", null, null);
        }
    }

    public void verify(Set<EOModelVerificationFailure> _failures, VerificationContext verificationContext) {
        String name = this.getName();
        if (name == null || name.trim().length() == 0) {
            _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The attribute " + this.getName() + " has an empty name.", false));
        } else {
            if (name.indexOf(32) != -1 && !name.startsWith("[") && !name.endsWith("]")) {
                _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The attribute " + this.getName() + "'s name has a space in it.", false));
            }
            if (name.equals("entityName")) {
                _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The attribute " + this.getName() + " is named 'entityName', which is a method in EOEnterpriseObject.", true));
            }
        }
        if (this.myPrototypeName != null && this.myPrototypeName.length() > 0 && this.getPrototype() == null) {
            _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The attribute " + this.getName() + " references the prototype '" + this.myPrototypeName + "' which no longer appears to exist.", true));
        }
        if (!this.myEntity.isPrototype() && !this.isFlattened()) {
            String columnName = this.getColumnName();
            if (columnName == null || columnName.trim().length() == 0) {
                if (this.getDefinition() == null && !BooleanUtils.isTrue(this.getEntity().isAbstractEntity())) {
                    _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The attribute " + this.getName() + " does not have a column name set.", true));
                }
            } else if (columnName.indexOf(32) != -1) {
                _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The attribute " + this.getName() + "'s column name '" + columnName + "' has a space in it.", false));
            } else if (this.getDefinition() == null) {
                for (EOAttribute attribute : this.myEntity.getAttributes()) {
                    if (attribute == this || !this.prototypeValueEquals("columnName", columnName, attribute.getColumnName()) || this.isReadOnly() != null && this.isReadOnly().booleanValue() || attribute.isReadOnly() != null && attribute.isReadOnly().booleanValue()) continue;
                    _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The attribute " + this.getName() + "'s column name is the same as " + attribute.getName() + "'s and it is not read only.", true));
                }
            }
            if (this.getValueClassName() == null && this.getClassName() == null && !BooleanUtils.isTrue(this.getEntity().isAbstractEntity())) {
                _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The attribute " + this.getName() + " does not have a value class name or a class name.", true));
            }
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return (this.myEntity == null ? "?" : this.myEntity.getFullyQualifiedName()) + "/attr: " + this.getName();
    }

    public EOAttribute _cloneModelObject() {
        EOAttribute attribute = (EOAttribute)this._cloneArgument();
        return attribute;
    }

    @Override
    public void _cloneIntoArgument(AbstractEOArgument argument, boolean updatingFlattenedAttribute) {
        super._cloneIntoArgument(argument, updatingFlattenedAttribute);
        EOAttribute attribute = (EOAttribute)argument;
        attribute.myPrototypeName = this.myPrototypeName;
        attribute.myCachedPrototype = this.myCachedPrototype;
        attribute.myClassProperty = this.myClassProperty;
        attribute.myPrimaryKey = this.myPrimaryKey;
        attribute.myUsedForLocking = this.myUsedForLocking;
        attribute.myClientClassProperty = this.myClientClassProperty;
        attribute._commonClassProperty = this._commonClassProperty;
        attribute.myIndexed = this.myIndexed;
        attribute.myReadOnly = this.myReadOnly;
        attribute.myReadFormat = this.myReadFormat;
        attribute.myWriteFormat = this.myWriteFormat;
        attribute._generateSource = this._generateSource;
    }

    @Override
    public Class<EOEntity> _getModelParentType() {
        return EOEntity.class;
    }

    @Override
    public EOEntity _getModelParent() {
        return this.getEntity();
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
        if (this.getEntity() != null) {
            this.getEntity().removeAttribute(this, true);
        }
    }

    public void synchronizeNameChange(String oldName, String newName) {
        EOModel model;
        EOEntity entity;
        boolean reverseEngineered = false;
        String columnName = this.getColumnName();
        if (columnName == null) {
            columnName = newName;
        }
        if ((entity = this.getEntity()) != null && (model = entity.getModel()) != null && !(reverseEngineered = model.isReverseEngineered())) {
            columnName = model.getAttributeNamingConvention().format(oldName, newName, this.getColumnName());
        }
        if (!reverseEngineered) {
            this.setColumnName(columnName);
        }
    }

    @Override
    public void _addToModelParent(EOEntity modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) throws EOModelException {
        if (findUniqueName) {
            String oldName = this.getName();
            String newName = modelParent.findUnusedAttributeName(oldName);
            this.setName(newName);
            modelParent.addAttribute(this);
            this.synchronizeNameChange(oldName, newName);
        } else {
            modelParent.addAttribute(this);
        }
    }

    public boolean getSqlGenerationAllowsNull() {
        return this.getEntity().isSingleTableInheritance() || BooleanUtils.isTrue(this.isAllowsNull());
    }

    public String getSqlGenerationAllowsNullAsConstant() {
        return this.getSqlGenerationAllowsNull() ? SQL_ALLOWS_NULL : SQL_NOT_NULL;
    }

    public boolean getSqlGenerationCreateProperty() {
        return !this.hasDefinition() && (!this.isInherited() || this.getEntity().getSqlGenerationCreateInheritedProperties() || this.isInherited() && !this.isFlattened() && this.getEntity().isVerticalInheritance());
    }

    @Override
    public String toString() {
        return "[EOAttribute: " + this.getName() + "]";
    }
}

