/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;

public class EOEntityTreeNode
implements Comparable<EOEntityTreeNode> {
    private EOEntity _entity;
    private EOEntityTreeNode _parent;
    private Set<EOEntityTreeNode> _children;

    public EOEntityTreeNode(EOEntity entity) {
        this._entity = entity;
        this._children = new TreeSet<EOEntityTreeNode>();
    }

    public EOEntity getEntity() {
        return this._entity;
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public EOEntityTreeNode getParent() {
        return this._parent;
    }

    public Set<EOEntityTreeNode> getChildren() {
        return this._children;
    }

    public void addChild(EOEntityTreeNode entity) {
        entity._parent = this;
        this._children.add(entity);
    }

    public void removeChild(EOEntityTreeNode entity) {
        entity._parent = null;
        this._children.remove(entity);
    }

    public void _breadthFirst(List<EOEntity> entities) {
        for (EOEntityTreeNode childNode : this.getChildren()) {
            entities.add(childNode.getEntity());
        }
        for (EOEntityTreeNode childNode : this.getChildren()) {
            childNode._breadthFirst(entities);
        }
    }

    public String toString() {
        return "[EOEntityNode: entity=" + this._entity.getName() + "]";
    }

    @Override
    public int compareTo(EOEntityTreeNode otherNode) {
        return this._entity.getName().compareTo(otherNode.getEntity().getName());
    }
}

