/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectstyle.wolips.eomodeler.core.model.ISortableEOModelObject;

public class PropertyListComparator
implements Comparator<Object> {
    public static final PropertyListComparator AscendingInsensitivePropertyListComparator = new PropertyListComparator(true);
    public static final PropertyListComparator AscendingSensitivePropertyListComparator = new PropertyListComparator(false);
    private boolean _caseInsensitive;
    protected Map guideMap;

    public static PropertyListComparator propertyListComparatorWithGuideArray(Object[] guideArray) {
        if (guideArray != null && guideArray.length > 0) {
            Object[] sortedArray = (Object[])guideArray.clone();
            Arrays.sort(sortedArray, AscendingInsensitivePropertyListComparator);
            if (!Arrays.equals(guideArray, sortedArray)) {
                PropertyListComparator result = new PropertyListComparator(true);
                int size = guideArray.length;
                if (size > 0) {
                    result.guideMap = new HashMap(size);
                    for (int i = 0; i < size; ++i) {
                        Object origEntry;
                        Object oneEntry = origEntry = guideArray[i];
                        if (origEntry instanceof Map) {
                            Object name = ((Map)origEntry).get("name");
                            if (name == null) {
                                name = ((Map)origEntry).get("prototypeName");
                            }
                            if (name != null) {
                                oneEntry = name;
                            }
                        }
                        if (oneEntry == null) continue;
                        result.guideMap.put(oneEntry, i);
                    }
                }
                return result;
            }
        }
        return AscendingInsensitivePropertyListComparator;
    }

    public PropertyListComparator(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        if (arg0 == null) {
            return arg1 == null ? 0 : -1;
        }
        if (arg1 == null) {
            return 1;
        }
        if (this.guideMap != null && (this.guideMap.get(arg0) != null || this.guideMap.get(arg1) != null)) {
            Integer guide0 = (Integer)this.guideMap.get(arg0);
            Integer guide1 = (Integer)this.guideMap.get(arg1);
            if (guide0 == null) {
                return 1;
            }
            if (guide1 == null) {
                return -1;
            }
            return guide0.compareTo(guide1);
        }
        if (arg0 instanceof String && arg1 instanceof String) {
            if (this._caseInsensitive) {
                return ((String)arg0).compareToIgnoreCase((String)arg1);
            }
            return ((String)arg0).compareTo((String)arg1);
        }
        if (arg0 instanceof Number && arg1 instanceof Number) {
            double d1;
            double d0 = ((Number)arg0).doubleValue();
            if (d0 > (d1 = ((Number)arg1).doubleValue())) {
                return 1;
            }
            if (d0 < d1) {
                return -1;
            }
            return 0;
        }
        if (arg0 instanceof Timestamp && arg1 instanceof Timestamp) {
            return ((Timestamp)arg0).compareTo((Timestamp)arg1);
        }
        if (arg0 instanceof ISortableEOModelObject && arg1 instanceof ISortableEOModelObject) {
            int comparison = this.compare(((ISortableEOModelObject)arg0).getName(), ((ISortableEOModelObject)arg1).getName());
            return comparison;
        }
        if (arg0 instanceof Map && arg1 instanceof Map) {
            Object key1;
            Map dic0 = (Map)arg0;
            Map dic1 = (Map)arg1;
            Object key0 = dic0.get("name");
            if (key0 == null) {
                key0 = dic0.get("prototypeName");
            }
            if ((key1 = dic1.get("name")) == null) {
                key1 = dic1.get("prototypeName");
            }
            if (key0 != null && key1 != null) {
                return this.compare(key0, key1);
            }
            if (key0 != key1) {
                throw new IllegalArgumentException("no 'name' key for either: " + arg0 + " or " + arg1);
            }
            Set allKeys0 = dic0.keySet();
            Set allKeys1 = dic1.keySet();
            Iterator allKeys0Iter = allKeys0.iterator();
            Iterator allKeys1Iter = allKeys1.iterator();
            while (allKeys0Iter.hasNext() && allKeys1Iter.hasNext()) {
                key0 = allKeys0Iter.next();
                int compareResult = this.compare(key0, key1 = allKeys1Iter.next());
                if (compareResult != 0) {
                    return compareResult;
                }
                compareResult = this.compare(dic0.get(key0), dic1.get(key1));
                if (compareResult == 0) continue;
                return compareResult;
            }
            return this.compare((Object)allKeys0.size(), (Object)allKeys1.size());
        }
        int compareResult = this.compare(arg0.getClass().getName(), arg1.getClass().getName());
        if (compareResult != 0) {
            return compareResult;
        }
        return arg0.toString().compareTo(arg1.toString());
    }
}

