/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.eclipse;

import java.net.URL;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOClassLoader;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.utils.EclipseFileUtils;
import org.objectstyle.wolips.launching.actions.WOJavaApplicationLaunchShortcut;

public class EclipseEOClassLoaderFactory
extends AbstractEOClassLoader {
    @Override
    protected String getCacheKey(EOModel model, Set<URL> classpathUrlSet) {
        IProject project = null;
        IFile eclipseFile = EclipseFileUtils.getEclipseFile(model.getModelURL());
        if (eclipseFile != null) {
            project = eclipseFile.getProject();
        }
        String cacheKey = project != null ? project.getName() : super.getCacheKey(model, classpathUrlSet);
        return cacheKey;
    }

    @Override
    protected void fillInDevelopmentClasspath(Set<URL> classpathUrls) throws Exception {
    }

    @Override
    protected void fillInModelClasspath(EOModel model, Set<URL> classpathUrls) throws Exception {
        IProject project = null;
        IFile eclipseFile = EclipseFileUtils.getEclipseFile(model.getModelURL());
        if (eclipseFile != null) {
            project = eclipseFile.getProject();
        }
        if (project == null) {
            URL modelURL = model.getModelURL();
            if (modelURL != null) {
                IContainer[] modelContainers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation((IPath)new Path(URLUtils.cheatAndTurnIntoFile((URL)modelURL).getAbsolutePath()));
                for (int modelContainerNum = 0; modelContainerNum < modelContainers.length; ++modelContainerNum) {
                    IContainer modelContainer = modelContainers[modelContainerNum];
                    IProject modelProject = modelContainer.getProject();
                    classpathUrls.addAll(WOJavaApplicationLaunchShortcut.createClasspathURLsForProject((IJavaProject)JavaCore.create((IProject)modelProject)));
                }
            }
        } else {
            classpathUrls.addAll(WOJavaApplicationLaunchShortcut.createClasspathURLsForProject((IJavaProject)JavaCore.create((IProject)project)));
        }
    }
}

