/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.refactoring.AddKeyInfo;
import org.objectstyle.wolips.wodclipse.core.refactoring.AddKeyOperation;

public class AddKeyDialog
extends Dialog {
    private static final String PREPEND_GET_METHOD = "AddKeyDialog.prependGetMethod";
    private Text _nameField;
    private Button _typeAsGivenButton;
    private Button _arrayOfButton;
    private Button _mutableArrayOfButton;
    private Combo _typeCombo;
    private Button _instanceVariableButton;
    private Button _getMethodButton;
    private Button _prependGetButton;
    private Button _setMethodButton;
    private AddKeyInfo _addKeyInfo;
    private IDialogSettings _settings = Activator.getDefault().getDialogSettings();

    public AddKeyDialog(AddKeyInfo addKeyInfo, Shell parentShell) {
        super(parentShell);
        this._addKeyInfo = addKeyInfo;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 10;
        gridLayout.marginTop = 10;
        gridLayout.marginRight = 10;
        gridLayout.marginLeft = 10;
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        Label _nameLabel = new Label(container, 0);
        GridData gd_nameLabel = new GridData(131072, 0x1000000, false, false);
        _nameLabel.setLayoutData((Object)gd_nameLabel);
        _nameLabel.setText("Name:");
        new Label(container, 0);
        this._nameField = new Text(container, 2048);
        GridData gd_nameButton = new GridData(4, 0x1000000, true, false);
        this._nameField.setLayoutData((Object)gd_nameButton);
        Label _typeLabel = new Label(container, 0);
        GridData gd_typeLabel = new GridData(131072, 0x1000000, false, false);
        gd_typeLabel.verticalIndent = 5;
        _typeLabel.setLayoutData((Object)gd_typeLabel);
        _typeLabel.setText("Type:");
        new Label(container, 0);
        this._typeAsGivenButton = new Button(container, 16);
        GridData gd_typeAsGivenButton = new GridData();
        gd_typeAsGivenButton.verticalIndent = 5;
        this._typeAsGivenButton.setLayoutData((Object)gd_typeAsGivenButton);
        this._typeAsGivenButton.setText("... (type as given)");
        new Label(container, 0);
        new Label(container, 0);
        this._arrayOfButton = new Button(container, 16);
        this._arrayOfButton.setText("Array of ...");
        new Label(container, 0);
        new Label(container, 0);
        this._mutableArrayOfButton = new Button(container, 16);
        this._mutableArrayOfButton.setText("Mutable array of ...");
        new Label(container, 0);
        new Label(container, 0);
        this._typeCombo = new Combo(container, 2048);
        this._typeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label _generateLabel = new Label(container, 0);
        GridData gd_generateLabel = new GridData(4, 0x1000000, false, false, 3, 1);
        gd_generateLabel.verticalIndent = 10;
        _generateLabel.setLayoutData((Object)gd_generateLabel);
        _generateLabel.setText("Generate source code for:");
        new Label(container, 0);
        new Label(container, 0);
        this._instanceVariableButton = new Button(container, 32);
        this._instanceVariableButton.setSelection(true);
        this._instanceVariableButton.setText("An instance variable");
        new Label(container, 0);
        new Label(container, 0);
        this._getMethodButton = new Button(container, 32);
        this._getMethodButton.setSelection(true);
        this._getMethodButton.setText("A method getting the value");
        new Label(container, 0);
        new Label(container, 0);
        this._prependGetButton = new Button(container, 32);
        GridData gd_prependGetButton = new GridData();
        gd_prependGetButton.horizontalIndent = 20;
        this._prependGetButton.setLayoutData((Object)gd_prependGetButton);
        this._prependGetButton.setText("Prepend \"get\" to method name");
        new Label(container, 0);
        new Label(container, 0);
        this._setMethodButton = new Button(container, 32);
        this._setMethodButton.setSelection(true);
        this._setMethodButton.setText("A method setting the value");
        String name = this._addKeyInfo.getName();
        if (name == null) {
            name = "newKey";
        }
        this._nameField.setText(name);
        this._typeCombo.setItems(this._addKeyInfo.getEntityNames());
        if (this._addKeyInfo.getParameterTypeName() != null) {
            this._typeCombo.setText(this._addKeyInfo.getParameterTypeName());
            if (this._addKeyInfo.getTypeName() != null) {
                String typeName = this._addKeyInfo.getTypeName();
                if ("com.webobjects.foundation.NSArray".equals(typeName)) {
                    this._arrayOfButton.setSelection(true);
                } else {
                    this._mutableArrayOfButton.setSelection(true);
                }
            }
        } else if (this._addKeyInfo.getTypeName() != null) {
            this._typeCombo.setText(this._addKeyInfo.getTypeName());
            this._typeAsGivenButton.setSelection(true);
        } else {
            this._typeCombo.setText("java.lang.String");
            this._typeAsGivenButton.setSelection(true);
        }
        this._addKeyInfo.setPrependGetToAccessorMethod(this._settings.getBoolean(PREPEND_GET_METHOD));
        this._instanceVariableButton.setSelection(this._addKeyInfo.isCreateField());
        this._getMethodButton.setSelection(this._addKeyInfo.isCreateAccessorMethod());
        this._prependGetButton.setSelection(this._addKeyInfo.isPrependGetToAccessorMethod());
        this._setMethodButton.setSelection(this._addKeyInfo.isCreateMutatorMethod());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Add", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(345, 358);
    }

    protected void buttonPressed(int buttonId) {
        this._addKeyInfo.setName(this._nameField.getText());
        if (this._typeAsGivenButton.getSelection()) {
            this._addKeyInfo.setParameterTypeName(null);
            this._addKeyInfo.setTypeName(this._typeCombo.getText());
        } else if (this._arrayOfButton.getSelection()) {
            this._addKeyInfo.setParameterTypeName(this._typeCombo.getText());
            this._addKeyInfo.setTypeName("com.webobjects.foundation.NSArray");
        } else if (this._mutableArrayOfButton.getSelection()) {
            this._addKeyInfo.setParameterTypeName(this._typeCombo.getText());
            this._addKeyInfo.setTypeName("com.webobjects.foundation.NSMutableArray");
        } else {
            this._addKeyInfo.setParameterTypeName(null);
            this._addKeyInfo.setTypeName(null);
        }
        this._addKeyInfo.setCreateField(this._instanceVariableButton.getSelection());
        this._addKeyInfo.setCreateAccessorMethod(this._getMethodButton.getSelection());
        this._addKeyInfo.setPrependGetToAccessorMethod(this._prependGetButton.getSelection());
        this._addKeyInfo.setCreateMutatorMethod(this._setMethodButton.getSelection());
        this._settings.put(PREPEND_GET_METHOD, this._prependGetButton.getSelection());
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Add Key");
    }

    public static void open(AddKeyInfo info, Shell shell) throws CoreException {
        AddKeyDialog dialog = new AddKeyDialog(info, shell);
        if (dialog.open() == 0) {
            AddKeyOperation.addKey(info);
        }
    }
}

