/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.util.NodeFilter;
import jp.aonir.fuzzyxml.util.NodeSelectUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.bindings.wod.IWodUnit;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.NamedWebobjectTagFilter;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;

public class QuickRenameRefactoring {
    public static void renameWodSelection(int offset, ITextViewer htmlViewer, ITextViewer wodViewer, WodParserCache cache) throws Exception {
        String elementName;
        IWodElement wodElement;
        Position elementNamePosition;
        IWodUnit wodUnit;
        IWodModel wodModel = (IWodModel)cache.getWodEntry().getModel();
        if (wodModel != null && (wodUnit = wodModel.getWodUnitAtIndex(offset)) != null && wodUnit instanceof IWodElement && (elementNamePosition = (wodElement = (IWodElement)wodUnit).getElementNamePosition()) != null && elementNamePosition.includes(offset) && (elementName = wodElement.getElementName()) != null) {
            QuickRenameRefactoring.renameElement(elementName, htmlViewer, wodViewer, cache, false);
        }
    }

    public static void renameHtmlSelection(int offset, ITextViewer htmlViewer, ITextViewer wodViewer, WodParserCache cache) throws Exception {
        FuzzyXMLDocument htmlModel = (FuzzyXMLDocument)cache.getHtmlEntry().getModel();
        FuzzyXMLElement element = htmlModel.getElementByOffset(offset);
        if (element != null) {
            String woElementName;
            FuzzyXMLAttribute nameAttribute;
            String tagName = element.getName();
            if (tagName != null && element.getOffset() + element.getNameOffset() + 1 <= offset && element.getOffset() + element.getNameOffset() + element.getNameLength() >= offset) {
                QuickRenameRefactoring.renameHtmlTag(element, htmlViewer, cache);
            } else if (WodHtmlUtils.isWOTag(tagName) && (nameAttribute = element.getAttributeNode("name")) != null && (woElementName = nameAttribute.getValue()) != null && element.getOffset() + nameAttribute.getValueDataOffset() + 1 <= offset && element.getOffset() + nameAttribute.getValueDataOffset() + nameAttribute.getValueDataLength() >= offset) {
                QuickRenameRefactoring.renameElement(woElementName, htmlViewer, wodViewer, cache, true);
            }
        }
    }

    public static void renameHtmlTag(FuzzyXMLElement element, ITextViewer htmlViewer, WodParserCache cache) throws BadLocationException {
        IDocument htmlDocument = htmlViewer.getDocument();
        LinkedModeModel.closeAllModels((IDocument)htmlDocument);
        LinkedPositionGroup linkedGroup = new LinkedPositionGroup();
        linkedGroup.addPosition(new LinkedPosition(htmlDocument, element.getOffset() + element.getNameOffset() + 1, element.getNameLength(), 0));
        if (element.hasCloseTag()) {
            linkedGroup.addPosition(new LinkedPosition(htmlDocument, element.getCloseTagOffset() + element.getCloseNameOffset() + 1, element.getCloseNameLength(), 1));
        }
        QuickRenameRefactoring.enterLinkedMode(linkedGroup, cache, htmlViewer);
    }

    protected static int linkHtml(String woElementName, IDocument htmlDocument, LinkedPositionGroup linkedGroup, WodParserCache cache, int sequence) throws Exception {
        FuzzyXMLDocument htmlModel = (FuzzyXMLDocument)cache.getHtmlEntry().getModel();
        FuzzyXMLNode[] woTags = NodeSelectUtil.getNodeByFilter((FuzzyXMLElement)htmlModel.getDocumentElement(), (NodeFilter)new NamedWebobjectTagFilter(woElementName));
        LinkedModeModel.closeAllModels((IDocument)htmlDocument);
        for (FuzzyXMLNode woTag : woTags) {
            FuzzyXMLElement woElement = (FuzzyXMLElement)woTag;
            FuzzyXMLAttribute woNameAttr = woElement.getAttributeNode("name");
            if (woNameAttr == null) continue;
            int offset = woElement.getOffset() + woNameAttr.getValueDataOffset() + 1;
            int length = woNameAttr.getValueDataLength();
            linkedGroup.addPosition(new LinkedPosition(htmlDocument, offset, length, sequence++));
        }
        return sequence;
    }

    protected static int linkWod(String woElementName, IDocument wodDocument, LinkedPositionGroup linkedGroup, WodParserCache cache, int sequence) throws Exception {
        Position namePosition;
        LinkedModeModel.closeAllModels((IDocument)wodDocument);
        IWodModel wodModel = (IWodModel)cache.getWodEntry().getModel();
        IWodElement wodElement = wodModel.getElementNamed(woElementName);
        if (wodElement != null && (namePosition = wodElement.getElementNamePosition()) != null) {
            linkedGroup.addPosition(new LinkedPosition(wodDocument, namePosition.getOffset(), namePosition.getLength(), sequence++));
        }
        return sequence;
    }

    public static void renameElement(String woElementName, ITextViewer htmlViewer, ITextViewer wodViewer, WodParserCache cache, boolean highlightHtml) throws Exception {
        int sequence = 0;
        LinkedPositionGroup linkedGroup = new LinkedPositionGroup();
        IDocument htmlDocument = htmlViewer.getDocument();
        IDocument wodDocument = wodViewer.getDocument();
        if (highlightHtml) {
            sequence = QuickRenameRefactoring.linkHtml(woElementName, htmlDocument, linkedGroup, cache, sequence);
            sequence = QuickRenameRefactoring.linkWod(woElementName, wodDocument, linkedGroup, cache, sequence);
        } else {
            sequence = QuickRenameRefactoring.linkWod(woElementName, wodDocument, linkedGroup, cache, sequence);
            sequence = QuickRenameRefactoring.linkHtml(woElementName, htmlDocument, linkedGroup, cache, sequence);
        }
        QuickRenameRefactoring.enterLinkedMode(linkedGroup, cache, htmlViewer, wodViewer);
    }

    protected static void enterLinkedMode(LinkedPositionGroup linkedGroup, final WodParserCache cache, ITextViewer ... textViewers) throws BadLocationException {
        if (!linkedGroup.isEmpty()) {
            LinkedModeModel linkedModeModel = new LinkedModeModel();
            linkedModeModel.addGroup(linkedGroup);
            linkedModeModel.forceInstall();
            linkedModeModel.addLinkingListener(new ILinkedModeListener(){

                public void resume(LinkedModeModel model, int flags) {
                }

                public void suspend(LinkedModeModel model) {
                }

                public void left(LinkedModeModel model, int flags) {
                    try {
                        cache.clearCache();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            EditorLinkedModeUI htmlUI = new EditorLinkedModeUI(linkedModeModel, textViewers);
            htmlUI.enter();
        }
    }
}

