/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.api;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.bindings.api.AbstractApiModelElement;
import org.objectstyle.wolips.bindings.api.AbstractNamedValidation;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.ApiUtils;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.api.IValidation;
import org.objectstyle.wolips.bindings.api.Unbound;
import org.objectstyle.wolips.bindings.api.Unsettable;
import org.objectstyle.wolips.bindings.api.Validation;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.w3c.dom.Element;

public class Binding
extends AbstractApiModelElement
implements IApiBinding {
    private BindingChangedListener bindingChangedListener;
    public static final String BINDING = "binding";
    public static final String NAME = "name";
    private static final String DEFAULTS = "defaults";
    private Wo parent;

    protected Binding(Element element, ApiModel apiModel, Wo parent) {
        super(element, apiModel);
        this.parent = parent;
    }

    @Override
    public boolean isAction() {
        return ApiUtils.isActionBinding(this);
    }

    @Override
    public int compareTo(IApiBinding o) {
        return o == null ? -1 : (this.getName() == null ? -1 : this.getName().compareTo(o.getName()));
    }

    public boolean equals(Object o) {
        return o instanceof Binding && ComparisonUtils.equals((Object)((Binding)o).getName(), (Object)this.getName());
    }

    public int hashCode() {
        String name = this.getName();
        return name == null ? 0 : name.hashCode();
    }

    public Wo getElement() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            return this.element.getAttribute(NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String className) {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            String oldName = this.getName();
            if (!ComparisonUtils.equals((Object)className, (Object)oldName)) {
                if (className == null || className.length() == 0) {
                    throw new IllegalArgumentException("Binding names cannot be blank.");
                }
                if (this.parent.getBinding(className) != null) {
                    throw new IllegalArgumentException("Binding names must be unique.");
                }
                this.element.setAttribute(NAME, className);
                for (IValidation validation : this.parent.getDeepAffectedValidations(oldName)) {
                    if (!(validation instanceof AbstractNamedValidation)) continue;
                    ((AbstractNamedValidation)validation).setName(className);
                }
                this.markAsDirty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaults() {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            return this.element.getAttribute(DEFAULTS);
        }
    }

    @Override
    public int getSelectedDefaults() {
        return ApiUtils.getSelectedDefaults(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(String defaults) {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            this.element.setAttribute(DEFAULTS, defaults);
            this.markAsDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(int defaults) {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            if (defaults == 0) {
                if (this.getDefaults() == null) {
                    return;
                }
                this.element.removeAttribute(DEFAULTS);
            } else {
                if (this.getDefaults() != null && this.getDefaults().equals(ALL_DEFAULTS[defaults])) {
                    return;
                }
                this.setDefaults(ALL_DEFAULTS[defaults]);
            }
            this.markAsDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExplicitlyRequired() {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            return "YES".equalsIgnoreCase(this.element.getAttribute("required"));
        }
    }

    @Override
    public boolean isRequired() {
        boolean required = this.isExplicitlyRequired();
        if (!required) {
            List<Validation> validations = this.parent.getValidations();
            for (int i = 0; !required && i < validations.size(); ++i) {
                Validation validation = validations.get(i);
                List<Unbound> unbounds = validation.getUnbounds();
                if (unbounds.size() != 1 || !unbounds.get(0).isAffectedByBindingNamed(this.getName())) continue;
                required = true;
            }
        }
        return required;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsRequired(boolean isRequired) {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            if (this.isRequired() == isRequired) {
                return;
            }
            if (this.element.hasAttribute("required")) {
                if (isRequired) {
                    this.element.setAttribute("required", "YES");
                } else {
                    this.element.setAttribute("required", "NO");
                }
            } else if (isRequired) {
                Unbound.addToWoWithBinding(this.parent, this);
            } else {
                Unbound.removeFromWoWithBinding(this.parent, this);
            }
            this.markAsDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExplicitlySettable() {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            return "YES".equalsIgnoreCase(this.element.getAttribute("settable"));
        }
    }

    @Override
    public boolean isWillSet() {
        boolean settable = this.isExplicitlySettable();
        if (!settable) {
            List<Validation> validations = this.parent.getValidations();
            for (Validation validation : validations) {
                List<Unsettable> unsettables = validation.getUnsettables();
                if (unsettables.size() != 1 || !unsettables.get(0).isAffectedByBindingNamed(this.getName())) continue;
                settable = true;
                break;
            }
        }
        return settable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsWillSet(boolean isWillSet) {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            if (this.isWillSet() == isWillSet) {
                return;
            }
            if (this.element.hasAttribute("settable")) {
                if (isWillSet) {
                    this.element.setAttribute("settable", "YES");
                } else {
                    this.element.setAttribute("settable", "NO");
                }
            } else if (isWillSet) {
                Unsettable.addToWoWithBinding(this.parent, this);
            } else {
                Unsettable.removeFromWoWithBinding(this.parent, this);
            }
            this.markAsDirty();
        }
    }

    @Override
    public String[] getValidValues(String partialValue, IJavaProject javaProject, IType componentType, TypeCache typeCache) throws JavaModelException {
        return ApiUtils.getValidValues(this, partialValue, javaProject, componentType, typeCache);
    }

    public void setBindingChangedListener(BindingChangedListener bindingChangedListener) {
        this.bindingChangedListener = bindingChangedListener;
    }

    public void markAsDirty() {
        this.apiModel.markAsDirty();
        if (this.bindingChangedListener != null) {
            this.bindingChangedListener.bindingChanged(this);
        }
    }

    public static interface BindingChangedListener {
        public void bindingChanged(Binding var1);
    }
}

