/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.componenteditor.ComponenteditorPlugin;

public class WOBrowserColumnLabelProvider
extends BaseLabelProvider
implements ILabelProvider,
ITableLabelProvider,
ITableFontProvider {
    private IType _type;
    private Control _control;
    private Font _titleFont;

    public WOBrowserColumnLabelProvider(IType type, Control control) {
        this._type = type;
        this._control = control;
    }

    protected Font getTitleFont() {
        if (this._titleFont == null) {
            Font originalFont = this._control.getFont();
            FontData[] fontData = this._control.getFont().getFontData();
            this._titleFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        }
        return this._titleFont;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public void dispose() {
        if (this._titleFont != null) {
            this._titleFont.dispose();
            this._titleFont = null;
        }
        super.dispose();
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        BindingValueKey bindingValueKey;
        Image image = null;
        if (columnIndex == 0) {
            if (element instanceof String) {
                // empty if block
            }
        } else if (columnIndex == 1 && element instanceof BindingValueKey && (bindingValueKey = (BindingValueKey)element) != null) {
            try {
                if (!bindingValueKey.isLeaf()) {
                    image = ComponenteditorPlugin.getDefault().getImage("toOne");
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = null;
        if (columnIndex == 0) {
            if (element instanceof BindingValueKey) {
                BindingValueKey bindingValueKey = (BindingValueKey)element;
                if (bindingValueKey != null) {
                    StringBuffer nameBuffer = new StringBuffer();
                    IType declaringType = bindingValueKey.getDeclaringType();
                    if (declaringType != null && this._type != null && !this._type.equals(declaringType)) {
                        nameBuffer.append("    ");
                    }
                    nameBuffer.append(bindingValueKey.getBindingName());
                    int minWidth = 40;
                    if (text != null && text.length() < minWidth) {
                        for (int i = text.length(); i < minWidth; ++i) {
                            nameBuffer.append(' ');
                        }
                    }
                    text = nameBuffer.toString();
                }
            } else if (element instanceof String) {
                text = (String)element;
            }
            if (text == null) {
                text = "<unknown>";
            }
        } else if (columnIndex == 1) {
            text = null;
        }
        return text;
    }

    public Font getFont(Object element, int columnIndex) {
        Font font = null;
        if (element instanceof String) {
            font = this.getTitleFont();
        }
        return font;
    }
}

